/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.util.locator;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import tsukuba_bunko.util.ResourceDetectionException;
import tsukuba_bunko.util.ResourceLocator;

public class ResourceLocatorImpl
extends ResourceLocator {
    public File findLocation(String string, ClassLoader classLoader) throws ResourceDetectionException {
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            throw new ResourceDetectionException("fail to find resource from classpath");
        }
        String string2 = uRL.getProtocol();
        if ("file".equals(string2)) {
            String string3 = uRL.getFile();
            try {
                string3 = URLDecoder.decode(string3, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ResourceDetectionException("system is not supoort UTF-8. This Java VM may be broken.", unsupportedEncodingException);
            }
            int n = string3.indexOf(string);
            if (n > 0) {
                string = string.substring(0, n);
            }
            return new File(string);
        }
        if ("jar".equals(string2)) {
            String string4 = uRL.toString();
            int n = string4.indexOf("!/");
            if (n == -1) {
                throw new ResourceDetectionException("invalid JAR URL.");
            }
            String string5 = string4.substring(4, n);
            if (!string5.startsWith("file:")) {
                throw new ResourceDetectionException("supported file protocol only");
            }
            try {
                return new File(URLDecoder.decode(new URL(string5).getFile(), "UTF-8"));
            }
            catch (Exception exception) {
                throw new ResourceDetectionException("invalid URL.", exception);
            }
        }
        throw new ResourceDetectionException("supported jar or file protocol only");
    }
}

