/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * (c) Copyright 2002 by Tsukuba Bunko.
 *
 * $Id: Actor.java,v 1.1.2.1 2003/12/11 10:23:10 ppoi Exp $
 */
package tsukuba_bunko.peko.canvas.stage;

import	java.awt.Image;

import	java.io.Serializable;


/**
 * ̓olłB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class Actor	implements Serializable	{

	/**
	 * ʒuF
	 */
	public static final int	POSITION_CENTER = 0;

	/**
	 * ʒuF
	 */
	public static final int	POSITION_LEFT = 1;

	/**
	 * ʒuFE
	 */
	public static final int	POSITION_RIGHT = 2;

	/**
	 * ʒuFΎw
	 */
	public static final int	POSITION_ABSOLUTE = 3;


	/**
	 * l
	 */
	private String	_name = null;

	/**
	 * `C[W
	 */
	private String	_looks = null;

	/**
	 * `C[W
	 */
	transient private Image	_looksImage = null;

	/**
	 * ʒu
	 */
	private int	_position = Actor.POSITION_CENTER;

	/**
	 * ʒu̐Έʒu
	 */
	private float	_absolutePosition = 0.0f;


	/**
	 * <code>Actor</code> ̃CX^X쐬܂B
	 * @param	name	l
	 * @throws	IllegalArgumentException	<code>name</code>  <code>null</code> ̏ꍇ
	 */
	public Actor( String name )
	{
		super();
		if( name == null )	{
			throw new IllegalArgumentException( "name is not specified." );
		}
		_name = name;
	}


	/**
	 * l擾܂B
	 * @return	l
	 */
	public String getName()
	{
		return _name;
	}

	/**
	 * \(G)ݒ肵܂B
	 * @param	looks	\(G)
	 */
	public void setLooks( String looks )
	{
		ImageManager	images = ImageManager.getInstance();
		if( (_looks != null) && _looks.equals(looks) )	{
			if( _looksImage == null )	{
				setLooksImage( images.getImage(looks, true) );
			}
		}
		else	{
			if( _looksImage != null )	{
				images.putImage( _looks, _looksImage );
			}
			setLooksImage( images.getImage(looks, true) );
		}
		_looks = looks;
	}

	/**
	 * \(G)擾܂B
	 * @return	\(G)
	 */
	public String getLooks()
	{
		return _looks;
	}

	/**
	 * \(G)摜ݒ肵܂B
	 * @param	looks	\(G)
	 */
	public void setLooksImage( Image looks )
	{
		_looksImage = looks;
	}

	/**
	 * \(G)摜擾܂B
	 * @return	\(G)
	 */
	public Image getLooksImage()
	{
		return _looksImage;
	}

	/**
	 * ʒuݒ肵܂B
	 * @param	position	ʒuB{@link #POSITION_CENTER}, {@link #POSITION_LEFT}, {@link #POSITION_RIGHT} I܂B
	 */
	public void setPosition( int position )
	{
		if( (position == Actor.POSITION_CENTER) || (position == Actor.POSITION_LEFT) || (position == Actor.POSITION_RIGHT) )	{
			_position = position;
		}
		else	{
			throw new IllegalArgumentException( "invalid position type is specified." );
		}
	}

	/**
	 * ʒuΎwŐݒ肵܂B
	 * @param	absolutePosition	Ύw肳ꂽʒu
	 */
	public void setPosition( float absolutePosition )
	{
		_position = Actor.POSITION_ABSOLUTE;
		_absolutePosition = absolutePosition;
	}

	/**
	 * ʒu擾܂B
	 * @return	ʒu
	 */
	public int getPosition()
	{
		return _position;
	}

	/**
	 * ʒu̐Έʒu擾܂B
	 * @return	Ύw肳ꂽʒu
	 */
	public float getAbsolutePosition()
	{
		return _absolutePosition;
	}

	/**
	 *  Actor j܂B
	 */
	void disposeLooks()
	{
		if( _looksImage != null )	{
			ImageManager	images = ImageManager.getInstance();
			images.putImage( _looks, _looksImage );
			_looksImage = null;
		}
	}

	/**
	 */
	void prepare()
	{
		setLooks( _looks );
	}


	/**
	 * ݂̏Ԃ <code>actor</code> ɃRs[܂B
	 * @param	actor	Rs[ Actor IuWFNg
	 */
	public void copyTo( Actor actor )
	{
		actor._name = _name;
		actor._looksImage = _looksImage;
		actor._looks = _looks;
		actor._position = _position;
		actor._absolutePosition = _absolutePosition;
	}
}