/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: FontDeserializer.java,v 1.1.2.1 2003/12/11 11:11:53 ppoi Exp $
 */
package tsukuba_bunko.peko.resource;

import	java.awt.font.TextAttribute;

import	java.util.Map;

import	org.xml.sax.Attributes;
import	org.xml.sax.SAXException;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.resource.FontManager;

import	tsukuba_bunko.resource.BasicDeserializer;


/**
 * {@link java.awt.Font} ^̃\[Xɑ΂ {@link tsukuba_bunko.resource.ResourceDeserializer} łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 * @see <a href="http://softlab.tsukuba-bunko.org/peko/userguide/resource.html#type-peko:font">peko:font ^̃\[X</a>
 */
public class FontDeserializer	extends BasicDeserializer	{

	/**
	 * tHg}bv
	 */
	protected Map	_fontAttributes = null;

	/**
	 */
	protected StringBuffer	_text = null;

	/**
	 * <code>FontDeserializer</code> ̃CX^X𐶐܂B
	 */
	public FontDeserializer()
	{
		super();
	}


//
//	ContentHandler ̎
//
	public void startDocument()
	{
		_fontAttributes = new java.util.HashMap();
		_fontAttributes.put( TextAttribute.FAMILY, "Serif" );
		_fontAttributes.put( TextAttribute.SIZE, new Float(20f) );
		_fontAttributes.put( TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR );
		_fontAttributes.put( TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR );
	}

	public void endDocument()
	{
		FontManager	fonts = FontManager.getInstance();
		setValue( fonts.getFont(_fontAttributes) );
	}

	public void startElement( String namespaceURI, String localName, String qName, Attributes attrs )
	{
		_text = new StringBuffer();
	}

	public void endElement( String namespaceURI, String localName, String qName )
		throws SAXException
	{
		if( qName.equals("family") )	{
			_fontAttributes.put( TextAttribute.FAMILY, new String(_text) );
		}
		else if( qName.equals("size") )	{
			try	{
				_fontAttributes.put( TextAttribute.SIZE, Float.valueOf(new String(_text)) );
			}
			catch( Exception e )	{
				Logger.warn( "[resource.font] invalid font size is specified :" + _text, e );
			}
		}
		else if( qName.equals("style") )	{
			String	style = new String( _text );
			if( "italic".equals(style) )	{
				_fontAttributes.put( TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE );
			}
		}
		else if( qName.equals("weight") )	{
			String	weight = new String( _text );
			if( "bold".equals(weight) )	{
				_fontAttributes.put( TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD );
			}
		}
		_text = null;
	}

	public void characters( char[] ch, int begin, int length )
	{
		if( _text != null )	{
			_text.append( ch, begin, length );
		}
	}
}