/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: LocationResources.java,v 1.1.2.1 2003/12/11 11:11:53 ppoi Exp $
 */
package tsukuba_bunko.peko.resource;

import	java.io.File;

import	java.net.URL;

import	tsukuba_bunko.resource.Resources;


/**
 * P[V\[Xi[ <code>Resources</coe> głB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class LocationResources	extends Resources	{

	/**
	 * f[^^Cv scenes ̃f[^i[fBNg URL
	 */
	public static final String	BASEURL_SCENES = "peko.system.location.scenes";

	/**
	 * f[^^Cv images ̃f[^i[fBNg URL
	 */
	public static final String	BASEURL_IMAGES = "peko.system.location.images";

	/**
	 * f[^^Cv sounds ̃f[^i[fBNg URL
	 */
	public static final String	BASEURL_SOUNDS = "peko.system.location.sounds";

	/**
	 * f[^^Cv misc ̃f[^i[fBNg URL
	 */
	public static final String	BASEURL_MISC = "peko.system.location.misc";

	/**
	 * CXg[fBNg
	 */
	public static final String	DIR_INSTALL = "peko.system.location.install";

	/**
	 * Z[uf[^fBNg
	 */
	public static final String	DIR_SAVE = "peko.system.location.save";


	/**
	 * sωtO
	 */
	private boolean	_emutable = false;


	/**
	 * <code>LocationResources</code> ̃CX^X𐶐܂B
	 */
	public LocationResources()
	{
		super();
	}


	/**
	 * f[^^Cv scenes ̃f[^i[fBNg URL ݒ肵܂B
	 * @param	url	fBNg URL
	 */
	public void setScenesDirecotryURL( URL url )
	{
		setResource( LocationResources.BASEURL_SCENES, url );
	}

	/**
	 * f[^^Cv scenes ̃f[^i[fBNg URL 擾܂B
	 * @return	fBNg URL
	 */
	public URL getScenesDirecotryURL()
	{
		return (URL)getResource( LocationResources.BASEURL_SCENES );
	}

	/**
	 * f[^^Cv images ̃f[^i[fBNg URL ݒ肵܂B
	 * @param	url	fBNg URL
	 */
	public void setImagesDirecotryURL( URL url )
	{
		setResource( LocationResources.BASEURL_IMAGES, url );
	}

	/**
	 * f[^^Cv images ̃f[^i[fBNg URL 擾܂B
	 * @return	fBNg URL
	 */
	public URL getImagesDirecotryURL()
	{
		return (URL)getResource( LocationResources.BASEURL_IMAGES );
	}

	/**
	 * f[^^Cv sounds ̃f[^i[fBNg URL ݒ肵܂B
	 * @param	url	fBNg URL
	 */
	public void setSoundsDirecotryURL( URL url )
	{
		setResource( LocationResources.BASEURL_SOUNDS, url );
	}

	/**
	 * f[^^Cv sounds ̃f[^i[fBNg URL 擾܂B
	 * @return	fBNg URL
	 */
	public URL getSoundsDirecotryURL()
	{
		return (URL)getResource( LocationResources.BASEURL_SOUNDS );
	}

	/**
	 * f[^^Cv misc ̃f[^i[fBNg URL ݒ肵܂B
	 * @param	url	fBNg URL
	 */
	public void setMiscDirecotryURL( URL url )
	{
		setResource( LocationResources.BASEURL_MISC, url );
	}

	/**
	 * f[^^Cv misc ̃f[^i[fBNg URL 擾܂B
	 * @return	fBNg URL
	 */
	public URL getMiscDirecotryURL()
	{
		return (URL)getResource( LocationResources.BASEURL_MISC );
	}


	/**
	 * CXg[fBNgݒ肵܂B
	 * @param	installDir	CXg[fBNg
	 */
	public void setInstallDirectory( File installDir )
	{
		setResource( LocationResources.DIR_INSTALL, installDir );
	}

	/**
	 * CXg[fBNg擾܂B
	 * @return	CXg[fBNg
	 */
	public File getInstallDirectory()
	{
		return (File)getResource( LocationResources.DIR_INSTALL );
	}

	/**
	 * Z[uf[^fBNgݒ肵܂B
	 * @param	saveDirectory	Z[uf[^fBNg
	 */
	public void setSaveDirectory( File saveDirectory )
	{
		setResource( LocationResources.DIR_SAVE, saveDirectory );
	}

	/**
	 * Z[uf[^fBNg擾܂B
	 * @return	Z[uf[^fBNg
	 */
	public File getSaveDirectory()
	{
		return (File)getResource( LocationResources.DIR_SAVE );
	}
}