/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: TypeMapping.java,v 1.1.2.1 2003/12/11 11:11:53 ppoi Exp $
 */
package tsukuba_bunko.peko.resource;

import	java.io.InputStream;
import	java.io.IOException;

import	java.util.Properties;

import	tsukuba_bunko.peko.InitializationError;
import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.resource.DeserializerMapping;
import	tsukuba_bunko.resource.ResourceDeserializer;


/**
 * \[X ID  f[^^̃}bsOǗ܂B
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class TypeMapping	{

	/**
	 * B̃CX^X
	 */
	private static TypeMapping	_instance = null;


	/**
	 * \[X ID - f[^^}bv
	 */
	private Properties	_typeMapping = null;

	/**
	 * DeserializerMapping
	 */
	private DeserializerMapping	_deserializerMapping = null;


	/**
	 * <code>TypeMapping</code> ̃CX^X쐬܂B
	 */
	protected TypeMapping()
	{
		super();
	}


	/**
	 * w肳ꂽ\[X̃f[^^擾܂B
	 * @param	resourceID	\[X ID
	 * @return	f[^^
	 */
	public String getDataType( String resourceID )
	{
		return _typeMapping.getProperty( resourceID );
	}

	/**
	 * w肳ꂽ\[XfVACY ResourceDeserializer 擾܂B
	 * @param	resourceID	\[X ID
	 * @return	ResourceDeserializer
	 */
	public ResourceDeserializer getResourceDeserializer( String resourceID )
	{
		String	type = _typeMapping.getProperty( resourceID );
		if( type != null )	{
			return _deserializerMapping.getResourceDeserializer( type );
		}
		else	{
			return null;
		}
	}

	/**
	 * DeserializerMapping 擾܂B
	 * @return	DeserializerMapping
	 */
	public DeserializerMapping getDeserializerMapping()
	{
		return _deserializerMapping;
	}

	/**
	 * <cpde>TypeMapping</code> ܂B
	 * @throws	InitializationError	Ɏsꍇ
	 */
	protected void initialize()
	{
		ClassLoader	cl = getClass().getClassLoader();
		InputStream	is = cl.getResourceAsStream( "resources.def" );
		if( is == null )	{
			throw new InitializationError( "resources.def not found." );
		}

		Properties	props = new Properties();
		try	{
			props.load( is );
		}
		catch( IOException ioe )	{
			Logger.fatal( "[resource] fail to initialize TypeMapping.", ioe );
			throw new InitializationError( "fail to initialize TypeMapping.", ioe );
		}
		finally	{
			try	{
				is.close();
			}
			catch( IOException ioe )	{
				Logger.fatal( "[resource] fail to initialize TypeMapping.", ioe );
			}
		}
		_typeMapping = props;

		_deserializerMapping = DeserializerMapping.newInstance( "tsukuba_bunko.peko.resource.mapping" );
	}



	/**
	 * B <code>TypeMapping</code> ̃CX^X擾܂B
	 * @return	B <code>TypeMapping</code> ̃CX^X
	 * @throws	InitializationError	Ɏsꍇ
	 */
	public static TypeMapping getInstance()
	{
		if( _instance == null )	{
			synchronized( TypeMapping.class )	{
				if( _instance == null )	{
					_instance = new TypeMapping();
					_instance.initialize();
				}
			}
		}
		return _instance;
	}
}
