/*
 * "Peko" Visual Novel System
 * 
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 * 
 * $Id: ColorManagerTestCase.java,v 1.1 2003/12/03 12:10:22 ppoi Exp $
 */
package tsukuba_bunko.peko.resource.test;

import	java.awt.Color;

import	junit.framework.TestCase;

import	tsukuba_bunko.peko.resource.ColorManager;


/**
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1 $
 */
public class ColorManagerTestCase extends TestCase {

	/**
	 * Constructor for ColorManagerTestCase.
	 * @param arg0
	 */
	public ColorManagerTestCase(String arg0)
	{
		super(arg0);
	}


	/**
	 * Fwɂ getColor ̃eXg
	 */
	public void testGetColor_Fw()
	{
		ColorManager	colors = ColorManager.getInstance();
		assertNotNull( "ColorMangaer should not be null.", colors );

		assertEquals( "unmatch color.", Color.black, colors.getColor("black") );
		assertEquals( "unmatch color.", Color.white, colors.getColor("white") );
		assertEquals( "unmatch color.", Color.red, colors.getColor("red") );
		assertEquals( "unmatch color.", Color.blue, colors.getColor("blue") );
		assertEquals( "unmatch color.", Color.green, colors.getColor("green") );
		assertEquals( "unmatch color.", Color.yellow, colors.getColor("yellow") );
		assertEquals( "unmatch color.", Color.gray, colors.getColor("gray") );
		assertEquals( "unmatch color.", Color.darkGray, colors.getColor("darkGray") );
		assertEquals( "unmatch color.", Color.lightGray, colors.getColor("lightGray") );
		assertEquals( "unmatch color.", Color.cyan, colors.getColor("cyan") );
		assertEquals( "unmatch color.", Color.magenta, colors.getColor("magenta") );
		assertEquals( "unmatch color.", Color.orange, colors.getColor("orange") );
		assertEquals( "unmatch color.", Color.pink, colors.getColor("pink") );
		assertEquals( "unmatch color.", Color.black, colors.getColor("") );
		assertEquals( "unmatch color.", Color.black, colors.getColor(null) );

		assertEquals( "unmatch color.", Color.black, colors.getColor("hoge") );
	}

}