/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: SceneContext.java,v 1.1.2.1 2003/12/11 10:13:39 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario;

import	java.io.Serializable;

import	java.util.List;
import	java.util.Map;
import	java.util.Set;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.session.Session;


/**
 * V[̃ReNXgłB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class SceneContext	implements Serializable	{

	/**
	 * V[
	 */
	protected String	_sceneName = null;

	/**
	 * V[^Cg
	 */
	protected String	_sceneTitle = null;

	/**
	 * V[̃vpeB
	 */
	protected Map	_properties = null;

	/**
	 * V[Jڐ\
	 */
	protected NextSceneMapping	_nextSceneMapping = null;

	/**
	 * ݈ʒu
	 */
	transient protected Node	_current = null;

	/**
	 * ۑꂽŌ̈ʒu
	 */
	protected Node	_lastCommittedNode = null;

	/**
	 * V[XR[v tO
	 */
	protected Set	_sceneScopeFlags = null;

	/**
	 * ZbV
	 */
	transient protected Session	_session = null;

	/**
	 * ̃V[ SceneProcessor
	 */
	transient protected SceneProcessor	_processor = null;


	/**
	 * <code>SceneContext</code> ̃CX^X𐶐܂B
	 * @param	sceneName	V[
	 * @param	session	ZbV
	 * @param	processor	̃V[V[vZbT
	 */
	public SceneContext( String sceneName, Session session, SceneProcessor processor )
	{
		_sceneName = sceneName;
		_session = session;
		_processor = processor;

		SceneContext	previous = session.getSceneContext();
		if( previous != null )	{
			_lastCommittedNode = previous.getLastCommittedNode();
			_properties = previous._properties;
			_nextSceneMapping = previous.getNextSceneMapping();
			_sceneScopeFlags = previous._sceneScopeFlags;
		}
		else	{
			_nextSceneMapping = new NextSceneMapping();
			_sceneScopeFlags = new java.util.HashSet();
		}
	}


	/**
	 * V[擾܂B
	 * @return	V[
	 */
	public String getSceneName()
	{
		return _sceneName;
	}

	/**
	 * V[^Cgݒ肵܂B
	 * @param	title	V[^Cg
	 */
	public void setSceneTitle( String title )
	{
		_sceneTitle = title;
	}

	/**
	 * V[^Cg擾܂B
	 * @return	V[^Cg
	 */
	public String getSceneTitle()
	{
		return _sceneTitle;
	}

	/**
	 * ZbV擾܂B
	 * @return	ZbV
	 */
	public Session getSession()
	{
		return _session;
	}

	/**
	 * V[vZbT擾܂B
	 * @return	V[vZbT
	 */
	public SceneProcessor getSceneProcessor()
	{
		return _processor;
	}

	/**
	 * V[vpeBݒ肵܂B
	 * @param	name	vpeB
	 * @param	value	vpeBl
	 */
	public void setProperty( String name, String value )
	{
		if( _properties == null )	{
			_properties = new java.util.HashMap( 17 );
		}
		_properties.put( name, value );
	}

	/**
	 * V[vpeB擾܂B
	 * @param	name	vpeB
	 * @return	vpeBlB<code>name</code> ŎʂvpeBݒ肳ĂȂꍇ <code>null</code>B
	 */
	public String getProperty( String name )
	{
		if( _properties == null )	{
			return null;
		}
		else	{
			return (String)_properties.get( name );
		}
	}

	/**
	 * Jڐ\ݒ肵܂B
	 * @param	mapping	Jڐ\
	 */
	public void setNextSceneMapping( NextSceneMapping mapping )
	{
		_nextSceneMapping = mapping;
	}

	/**
	 * Jڐ\擾܂B
	 * @return	Jڐ\
	 */
	public NextSceneMapping getNextSceneMapping()
	{
		return _nextSceneMapping;
	}

	/**
	 * ̃V[擾܂B
	 * @return	̃V[̏ɑJڂV[̃V[
	 */
	public String getNextSceneName()
	{
		return _nextSceneMapping.getNextScene( this );
	}

	/**
	 * w肳ꂽm[h̏JnꂽƂʒm܂B
	 */
	public void pushNode( String nodeName )
	{
		if( _current == null )	{
			_current = new Node( null, nodeName.intern(), 1 );
		}
		else	{
			int	position = _current.countSibling(nodeName) + 1;
			Node	child = new Node( _current, nodeName.intern(), position );
			_current.addChildNode( child );
			_current = child;
		}
	}

	/**
	 * ݂̃m[h̏IƂʒm܂B
	 */
	public void popNode()
	{
		if( _current == null )	{
			Logger.error( "[scenario] BUG! invalid state of SceneLog." );
		}
		else	{
			_current.removeChildren();
			_current = _current.getParentNode();
		}
	}

	/**
	 * ݂̈ʒuۑ܂B
	 */
	public void saveCurrentNode()
	{
		_lastCommittedNode = _current;
	}

	/**
	 * ۑꂽŌ̈ʒu擾܂B
	 * @return	ۑꂽŌ̈ʒu
	 */
	public Node getLastCommittedNode()
	{
		return _lastCommittedNode;
	}

	/**
	 * <code>node</code> ݏ̃m[hƓł邩ǂ𔻒肵܂B
	 * @param	node	Ώۂ̃m[h
	 * @return	ł̏ꍇ <code>true</code>AȊȌꍇ <code>false</code>
	 */
	public boolean isCurrentNode( Node node )
	{
		if( node == _current )	{
			return true;
		}
		else if( _current != null )	{
			return _current.equals(node);
		}
		else {
			return false;
		}
	}

	/**
	 * ݏ̃m[h̃Rs[擾܂BRs[ɂ́Aqm[hXg͊܂܂܂B
	 * @return	ݏ̃m[h̃Rs[
	 */
	public Node getCurrentNode()
	{
		Node	node = _current;
		if( node == null )	{
			return null;
		}
		else	{
			Node	copy = new Node( null, node._nodeName, node._position );
			Node	temp = copy;
			while( (node = node.getParentNode()) != null )	{
				temp._parent = new Node( null, node.getNodeName(), node.getPosition() );
				temp = temp.getParentNode();
			}
			return copy;
		}
	}

	/**
	 * ݏ̃pX XPath Ŏ擾܂B
	 * @return	ݏ̃pX
	 */
	public String getCurrentPath()
	{
		if( _current != null )	{
			return _current.getPath();
		}
		else	{
			return "/";
		}
	}


	/**
	 * tO𗧂Ă܂B
	 * @param	flagID	tO ID
	 * @param	scope	tOXR[v
	 * @throws	IllegalArgumentException	<code>flagID</code>  <code>null</code> ̏ꍇ
	 */
	public void declareFlag( String flagID, FlagScope scope )
	{
		if( flagID == null )	{
			throw new IllegalArgumentException();
		}

		if( scope == FlagScope.SCENE )	{
			_sceneScopeFlags.add( flagID );
		}
		else if( scope == FlagScope.SESSION )	{
			_session.declareSessionFlag( flagID );
		}
		else if( scope == FlagScope.SYSTEM )	{
			_session.declareSystemFlag( flagID );
		}
	}

	/**
	 * tO낵܂B
	 * @param	flagID	tO ID
	 * @param	scope	tOXR[v
	 * @throws	IllegalArgumentException	<code>flagID</code>  <code>null</code> ̏ꍇ
	 */
	public void undeclareFlag( String flagID, FlagScope scope )
	{
		if( flagID == null )	{
			throw new IllegalArgumentException();
		}

		if( scope == FlagScope.SCENE )	{
			_sceneScopeFlags.remove( flagID );
		}
		else if( scope == FlagScope.SESSION )	{
			_session.undeclareSessionFlag( flagID );
		}
		else if( scope == FlagScope.SYSTEM )	{
			_session.undeclareSystemFlag( flagID );
		}
	}

	/**
	 * XR[v킸AtOĂ邩ǂ𔻒肵܂B
	 * @param	flagID	tO ID
	 */
	public boolean isDeclaredFlag( String flagID )
	{
		if( _sceneScopeFlags.contains(flagID) )	{
			return true;
		}
		else if( _session.isDeclaredSessionFlag(flagID) )	{
			return true;
		}
		else if( _session.isDeclaredSystemFlag(flagID) )	{
			return true;
		}
		else	{
			return false;
		}
	}

	/**
	 * w肳ꂽXR[vŃtOĂ邩ǂ𔻒肵܂B
	 * @param	flagID	tO ID
	 * @param	scope	tOXR[v
	 * @return	w肳ꂽtOXR[vŃtOĂꍇ <code>true</code>AȊȌꍇ <code>false</code>
	 */
	public boolean isDeclaredFlag( String flagID, FlagScope scope )
	{
		if( scope == FlagScope.SCENE )	{
			return _sceneScopeFlags.contains( flagID );
		}
		else if( scope == FlagScope.SESSION )	{
			return _session.isDeclaredSessionFlag( flagID );
		}
		else if( scope == FlagScope.SYSTEM )	{
			return _session.isDeclaredSystemFlag( flagID );
		}
		else	{
			return false;
		}
	}

//
//	m[h
//
	/**
	 * PSML Scene \m[hłB
	 */
	public static class Node	implements Serializable	{

		/**
		 * em[h
		 */
		protected Node	_parent = null;

		/**
		 * m[h
		 */
		protected String	_nodeName = null;

		/**
		 * position
		 */
		protected int	_position = 0;

		/**
		 * qm[hXg
		 */
		protected List	_children = null;


		/**
		 * <code>SceneContext.Node</code> ̃CX^X𐶐܂B
		 */
		public Node( Node parent, String nodeName, int position )
		{
			_parent = parent;
			_nodeName = nodeName.intern();
			_position = position;
		}

		/**
		 * em[h擾܂B
		 * @return	em[h
		 */
		public Node getParentNode()
		{
			return _parent;
		}

		/**
		 * m[h擾܂B
		 * @return	m[h
		 */
		public String getNodeName()
		{
			return _nodeName;
		}

		/**
		 * |WV擾܂B
		 * @return	|WV
		 */
		public int getPosition()
		{
			return _position;
		}


		/**
		 * qm[hǉ܂B
		 * @param	child	qm[h
		 */
		public void addChildNode( Node child )
		{
			if( _children == null )	{
				_children = new java.util.ArrayList();
			}
			_children.add( child );
		}

		/**
		 * qm[ĥȂŁAw肳ꂽÕm[h̐JEg܂B
		 * @param	nodeName	qm[h
		 * @return	m[h
		 */
		public int countSibling( String nodeName )
		{
			if( _children == null )	{
				return 0;
			}
			else	{
				String	symbol = nodeName.intern();
				List	children = _children;
				int	size = children.size();
				Node	node = null;
				int	count = 0;
				for( int i = 0; i < size; ++i )	{
					node = (Node)children.get( i );
					if( node._nodeName == symbol )	{
						count++;
					}
				}
				return count;
			}
		}

		/**
		 * ̃m[h[gƂTuc[j܂B
		 */
		public void removeChildren()
		{
			if( _children != null )	{
				List	children = _children;
				int	size = children.size();
				for( int i = 0; i < size; ++i )	{
					((Node)children.get(i)).removeChildren();
				}
				children.clear();
				_children = null;
			}
		}

		/**
		 * ̃m[h܂ł̃pX XPath `Ŏ擾܂B
		 * @return	̃m[h܂ł̃pX
		 */
		public String getPath()
		{
			StringBuffer	sink = new StringBuffer();
			Node	node = this;
			while( node != null )	{
				sink.insert( 0, node );
				node = node.getParentNode();
			}
			return new String(sink);
		}

		public boolean equals( Object obj )
		{
			if( obj instanceof Node )	{
				Node	target = (Node)obj;
				Node	node = this;
				while( (node != null) && (target != null) )	{
					if( !node._nodeName.equals(target._nodeName) || (node._position != target._position) )	{
						return false;
					}
					node = node._parent;
					target = target._parent;
				}
				return ((node == null) && (target == null));
			}
			else	{
				return false;
			}
		}

		public String toString()
		{
			return "/" + _nodeName + "[" + _position + "]";
		}
	}
}
