/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: AtOnceHandler.java,v 1.1.2.1 2003/12/11 10:15:10 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.stage;

import	org.xml.sax.Attributes;
import	org.xml.sax.SAXException;

import	tsukuba_bunko.peko.scenario.HandlerRegistry;
import	tsukuba_bunko.peko.scenario.PSMLUtil;


/**
 * <samp>at-once</samp> vf ElementHandler łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class AtOnceHandler	extends StageElementHandler	{

	/**
	 * ݎgp StageElementHandler
	 */
	private StageElementHandler	_child = null;

	/**
	 * level
	 */
	private int	_level = 0;

	/**
	 * XVɎgpGtFNg
	 */
	private String	_effect = null;


	/**
	 * <code>AtOnceHandler</code> ̃CX^X쐬܂B
	 */
	public AtOnceHandler()
	{
		super();
	}


//
//	ContentHandler ̎
//
	public void startDocument()
	{
		_child = null;
		_level = 0;
		super.startDocument();
	}

	public void endDocument()
	{
		if( _effect == null )	{
			getStageCoordinator().updateStage();
		}
		else	{
			getStageCoordinator().updateStage( _effect );
		}
		super.endDocument();
	}

	public void startElement( String namespaceURI, String localName, String qName, Attributes attrs )
		throws SAXException
	{
		if( _child != null )	{
			_level++;
			_child.startElement( namespaceURI, localName, qName, attrs );
		}
		else if( localName.equals("at-once") )	{
			_effect = PSMLUtil.getAttributeValue( attrs, "effect" );
		}
		else	{
			HandlerRegistry	registry = getSceneContext().getSceneProcessor().getHandlerRegistry();
			_child = (StageElementHandler)registry.getElementHandler( namespaceURI, localName );
			if( _child != null )	{
				_child.setParentHandler( this );
				_child.setSceneContext( getSceneContext() );
				_child.startDocument();
				_level++;
				_child.startElement( namespaceURI, localName, qName, attrs );
			}
		}
	}

	public void endElement( String namespaceURI, String localName, String qName )
		throws SAXException
	{
		if( _child != null )	{
			_level--;
			_child.endElement( namespaceURI, localName, qName );
			if( _level == 0 )	{
				_child.endDocument();
				_child.setParentHandler( null );
				_child.setSceneContext( null );
				_child = null;
			}
		}
	}
}
