/*
 * Common Library for TBAS Softwares
 *
 * All Rights Reserved.
 * (c) Copyright 2002 by Tsukuba Bunko.
 *
 * $Id: DeserializerMapping.java,v 1.1 2003/08/31 08:20:49 ppoi Exp $
 */
package tsukuba_bunko.resource;

import	java.util.Enumeration;
import	java.util.Map;
import	java.util.ResourceBundle;


/**
 * f[^^ <code>ResourceDeserializer</code> ̃}bvǗ܂B̃NX thread-safe ł͂܂̂ŁAmalti-thread
 * Ŏgpꍇ́A̐sĂB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1 $
 */
public class DeserializerMapping	{

	/**
	 * f[^^ - ResourceDeserializer }bv
	 */
	private Map	_registry = new java.util.HashMap( 89 );


	/**
	 * <code>DeserializerMapping</code> ̃CX^X쐬܂B
	 */
	public DeserializerMapping()
	{
		super();
	}


	/**
	 * f[^^ <code>dataType</code>  <code>ResourceDeserializer</code> NX
	 * <code>deserializerClass</code> ֘AÂ܂B
	 * @param	typeName	f[^^
	 * @param	deserializer	gp <code>ResourceDeserializer</code>
	 * @exception	IllegalArgumentException	<code>deserializerClass</code> Ó <code>ResourceDeserializer</code> TuNXł͂Ȃꍇ
	 */
	public void register( String typeName, ResourceDeserializer deserializer )
	{
		deserializer.setDeserializerMapping( this );
		deserializer.setTypeName( typeName );
		_registry.put( typeName, deserializer );
	}

	/**
	 * f[^^ <code>typeName</code> Ɋ֘AÂꂽ <code>ResourceDeserializer</code> NX폜܂B
	 * @param	typeName
	 */
	public void unregister( String typeName )
	{
		_registry.remove( typeName );
	}

	/**
	 * <code>dataType</code> Ɋ֘AÂꂽ <code>ResourceDeserializer</code> 擾܂B
	 * @param	dataType	f[^^
	 * @return	֘AÂĂ <code>ResourceDeserializer</code>
	 * @exception	IllegalStateException	<code>ValueDeserialzier</code> ̎擾Ɏsꍇ
	 */
	public ResourceDeserializer getResourceDeserializer( String dataType )
	{
		return (ResourceDeserializer)_registry.get( dataType );
	}

	/**
	 * w肳ꂽ reosurce bundle gp <code>DeserializerMapping</code> ̃CX^X쐬܂B
	 * @param	bundleName	ResourceBundle ̃x[XNX
	 * @return	쐬ꂽ <code>DeserializerMapping</code> ̃CX^X
	 */
	public static DeserializerMapping newInstance( String bundleName )
	{
		DeserializerMapping	mapping = new DeserializerMapping();

		ResourceBundle	source = ResourceBundle.getBundle( bundleName );
		ClassLoader	cl = DeserializerMapping.class.getClassLoader();

		Enumeration	keys = source.getKeys();
		String	key = null;
		while( keys.hasMoreElements() )	{
			key = (String)keys.nextElement();
			String	className = source.getString( key );
			try	{
				mapping.register( key, (ResourceDeserializer)cl.loadClass(className).newInstance() );
			}
			catch( Exception e )	{
				System.err.println( "[libtbas] ERROR : illegal class \"" + className + "\"" );
				e.printStackTrace();
			}
		}

		return mapping;
	}

	/**
	 * \[XŎw肳ꂽe <code>DeserializerMapping</code> ̃CX^X쐬܂B
	 * @return	쐬ꂽ <code>DeserializerMapping</code> ̃CX^X
	 */
	public static DeserializerMapping newInstance()
	{
		return newInstance( System.getProperty("libtbas.resource.mapping", "tsukuba_bunko.resource.mapping") );
	}
}
