/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shikaku;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.shikaku.Square;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int UNDECIDED_NUMBER = -1;
    private int[][] number;
    private Square[][] square;
    private List squareList;

    protected void setup() {
        super.setup();
        this.number = new int[this.rows()][this.cols()];
        this.square = new Square[this.rows()][this.cols()];
        this.squareList = new LinkedList();
    }

    public void clearBoard() {
        super.clearBoard();
        this.squareList.clear();
        ArrayUtil.initArrayObject2(this.square, null);
    }

    public void initBoard() {
        this.initSquares();
    }

    public void initSquares() {
        Iterator itr = this.squareList.iterator();
        while (itr.hasNext()) {
            this.initSquare1((Square)itr.next());
        }
    }

    public void initSquare1(Square a) {
        int n = 0;
        int r = a.r0;
        while (r <= a.r1) {
            int c = a.c0;
            while (c <= a.c1) {
                if (this.isNumber(r, c)) {
                    n = n != 0 ? -2 : this.number[r][c];
                }
                this.square[r][c] = a;
                ++c;
            }
            ++r;
        }
        a.setNumber(n);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public boolean isNumber(int r, int c) {
        return this.number[r][c] > 0 || this.number[r][c] == -1;
    }

    public Square getSquare(int r, int c) {
        return this.square[r][c];
    }

    public Iterator getSquareListIterator() {
        return this.squareList.iterator();
    }

    public int getSquareListSize() {
        return this.squareList.size();
    }

    public boolean isCovered(int r, int c) {
        return this.square[r][c] != null;
    }

    public void addSquareSpanning(Address pos0, Address pos1) {
        int ra = pos0.r < pos1.r ? pos0.r : pos1.r;
        int rb = pos0.r < pos1.r ? pos1.r : pos0.r;
        int ca = pos0.c < pos1.c ? pos0.c : pos1.c;
        int cb = pos0.c < pos1.c ? pos1.c : pos0.c;
        Square newArea = new Square(ra, ca, rb, cb);
        int r = ra;
        while (r <= rb) {
            int c = ca;
            while (c <= cb) {
                if (this.getSquare(r, c) != null) {
                    this.removeSquareA(this.getSquare(r, c));
                }
                ++c;
            }
            ++r;
        }
        this.addSquareA(newArea);
    }

    public void removeSquareIncluding(Address pos) {
        if (this.getSquare(pos.r, pos.c) != null) {
            this.removeSquareA(this.getSquare(pos.r, pos.c));
        }
    }

    public void addSquareA(Square aq) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(aq, 1)));
        this.addSquare(aq);
    }

    public void removeSquareA(Square a) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(a, 0)));
        this.removeSquare(a);
    }

    public void addSquare(Square sq) {
        this.initSquare1(sq);
        this.squareList.add(sq);
    }

    public void removeSquare(Square sq) {
        int r = sq.r0;
        while (r <= sq.r1) {
            int c = sq.c0;
            while (c <= sq.c1) {
                this.square[r][c] = null;
                ++c;
            }
            ++r;
        }
        this.squareList.remove(sq);
    }

    public int checkAnswerCode() {
        int errorCode = 0;
        int nNumber = 0;
        Iterator itr = this.squareList.iterator();
        while (itr.hasNext()) {
            Square a = (Square)itr.next();
            int n = a.getNumber();
            if (n == -2) {
                errorCode |= 1;
                continue;
            }
            if (n == 0) {
                errorCode |= 2;
                continue;
            }
            if (n == -1) continue;
            if (n < a.getSquareSize()) {
                errorCode |= 4;
                continue;
            }
            if (n <= a.getSquareSize()) continue;
            errorCode |= 8;
        }
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isNumber(r, c)) {
                    ++nNumber;
                }
                if (this.square[r][c] == null) {
                    errorCode |= 0x10;
                }
                ++c;
            }
            ++r;
        }
        if (nNumber == 0) {
            errorCode = 32;
        }
        return errorCode;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return "\u5b8c\u6210\u3067\u3059";
        }
        if (result == 32) {
            return "\u76e4\u4e0a\u306b\u6570\u5b57\u304c\u3072\u3068\u3064\u3082\u306a\u3044\n";
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append("\u8907\u6570\u306e\u6570\u5b57\u3092\u542b\u3080\u56db\u89d2\u304c\u3042\u308b\n");
        }
        if ((result & 2) == 2) {
            message.append("\u6570\u5b57\u3092\u542b\u307e\u306a\u3044\u56db\u89d2\u304c\u3042\u308b\n");
        }
        if ((result & 4) == 4) {
            message.append("\u9762\u7a4d\u304c\u6570\u5b57\u3092\u8d85\u3048\u308b\u56db\u89d2\u304c\u3042\u308b\n");
        }
        if ((result & 8) == 8) {
            message.append("\u9762\u7a4d\u304c\u6570\u5b57\u306b\u6e80\u305f\u306a\u3044\u56db\u89d2\u304c\u3042\u308b\n");
        }
        if ((result & 0x10) == 16) {
            message.append("\u56db\u89d2\u306b\u542b\u307e\u308c\u306a\u3044\u30de\u30b9\u304c\u3042\u308b\n");
        }
        return message.toString();
    }

    class Step
    extends AbstractUndoableEdit {
        static final int ADDED = 1;
        static final int REMOVED = 0;
        private Square square;
        private int operation;

        public Step(Square sq, int operation) {
            this.square = sq;
            this.operation = operation;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.operation == 1) {
                Board.this.removeSquare(this.square);
            } else if (this.operation == 0) {
                Board.this.addSquare(this.square);
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (this.operation == 1) {
                Board.this.addSquare(this.square);
            } else if (this.operation == 0) {
                Board.this.removeSquare(this.square);
            }
        }
    }
}

