/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.sudoku;

import java.awt.Color;
import java.awt.Graphics;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.HintDot;
import pencilbox.common.gui.PanelEventHandler;
import pencilbox.sudoku.Board;

public class Panel
extends PanelEventHandler {
    private Board board;
    private boolean highlightSelectedNumber = false;
    private boolean warnWrongNumber = false;
    private boolean showAllowedNumberDot = false;
    private Color inputColor = Color.BLUE;
    private Color errorColor = Color.RED;
    private int selectedNumber = 0;
    private Color selectedNumberColor = Color.GREEN;
    private Color selectedNumberColor2 = new Color(0xFFFF80);
    private HintDot hintDot = new HintDot();
    private int unit;

    public Panel() {
        this.setCursorOn(true);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.unit = this.board.getUnit();
        this.setMaxInputNumber(this.board.rows());
        if (this.unit >= 3 && this.unit <= 5) {
            this.hintDot.setDot(this, this.unit, this.getCellSize());
        }
    }

    public Color getSelectedNumberColor() {
        return this.selectedNumberColor;
    }

    public void setSelectedNumberColor(Color selectedNumberColor) {
        this.selectedNumberColor = selectedNumberColor;
    }

    public void setWarnWrongNumber(boolean warnWrongNumber) {
        this.warnWrongNumber = warnWrongNumber;
    }

    public void setHighlightSelectedNumber(boolean highlightSelectedNumber) {
        this.highlightSelectedNumber = highlightSelectedNumber;
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public void setShowAllowedNumberDot(boolean showAllowedNumberDot) {
        this.showAllowedNumberDot = showAllowedNumberDot;
    }

    protected void setDisplaySize(int cellSize) {
        super.setDisplaySize(cellSize);
        this.hintDot.setDotSize(cellSize);
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        if (this.getCellCursor() != null) {
            this.drawCursor(g);
        }
    }

    public void drawGrid(Graphics g) {
        g.setColor(this.getBorderColor());
        int r = 0;
        while (r <= this.rows()) {
            if (r % this.board.getUnit() == 0) {
                g.drawLine(this.toX(0), this.toY(r) - 1, this.toX(this.cols()), this.toY(r) - 1);
                g.drawLine(this.toX(0), this.toY(r), this.toX(this.cols()), this.toY(r));
                g.drawLine(this.toX(0), this.toY(r) + 1, this.toX(this.cols()), this.toY(r) + 1);
            } else {
                g.drawLine(this.toX(0), this.toY(r), this.toX(this.cols()), this.toY(r));
            }
            ++r;
        }
        int c = 0;
        while (c <= this.cols()) {
            if (c % this.board.getUnit() == 0) {
                g.drawLine(this.toX(c) - 1, this.toY(0), this.toX(c) - 1, this.toY(this.rows()));
                g.drawLine(this.toX(c), this.toY(0), this.toX(c), this.toY(this.rows()));
                g.drawLine(this.toX(c) + 1, this.toY(0), this.toX(c) + 1, this.toY(this.rows()));
            } else {
                g.drawLine(this.toX(c), this.toY(0), this.toX(c), this.toY(this.rows()));
            }
            ++c;
        }
    }

    void drawBoard(Graphics g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int num = this.board.getNumber(r, c);
                this.paintCell(g, r, c, num);
                if (num > 0) {
                    this.drawNumber(g, r, c, num);
                } else if (num == 0) {
                    if (this.board.isStable(r, c)) {
                        g.setColor(this.getNumberColor());
                        this.placeBoldCircle(g, r, c);
                    } else if (this.showAllowedNumberDot && this.unit >= 3 && this.unit <= 5) {
                        this.drawHintDot(g, r, c);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    void paintCell(Graphics g, int r, int c, int num) {
        if (this.highlightSelectedNumber && this.selectedNumber > 0) {
            if (this.selectedNumber == num) {
                g.setColor(this.selectedNumberColor);
                this.paintCell(g, r, c);
            } else if (this.board.canPlace(r, c, this.selectedNumber)) {
                g.setColor(this.selectedNumberColor2);
                this.paintCell(g, r, c);
            }
        }
    }

    void drawNumber(Graphics g, int r, int c, int num) {
        if (this.board.isStable(r, c)) {
            g.setColor(this.getNumberColor());
        } else if (this.warnWrongNumber && this.board.isMultipleNumber(r, c)) {
            g.setColor(this.errorColor);
        } else {
            g.setColor(this.inputColor);
        }
        this.placeNumber(g, r, c, num);
    }

    void drawHintDot(Graphics g, int r, int c) {
        int pat = this.board.getPattern(r, c);
        if (pat == 0) {
            this.hintDot.placeHintCross(g, r, c);
        } else {
            this.hintDot.placeHintDot(g, r, c, pat);
        }
    }

    void drawHintDots(Graphics g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                this.drawHintDot(g, r, c);
                ++c;
            }
            ++r;
        }
    }

    protected void leftPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos.r, pos.c))) {
            this.board.increaseNumber(pos.r, pos.c);
        }
        this.selectedNumber = this.board.getNumber(pos.r, pos.c);
    }

    protected void rightPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos.r, pos.c))) {
            this.board.decreaseNumber(pos.r, pos.c);
        }
        this.selectedNumber = this.board.getNumber(pos.r, pos.c);
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            if (num > 0) {
                this.board.changeNumber(pos.r, pos.c, num);
                this.board.setState(pos.r, pos.c, 1);
            }
        } else if (num > 0 && !this.board.isStable(pos.r, pos.c)) {
            this.board.enterNumberA(pos.r, pos.c, num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.changeNumber(pos.r, pos.c, 0);
            this.board.setState(pos.r, pos.c, 0);
        } else if (!this.board.isStable(pos.r, pos.c)) {
            this.board.enterNumberA(pos.r, pos.c, 0);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.changeNumber(pos.r, pos.c, 0);
            this.board.setState(pos.r, pos.c, 1);
        }
    }
}

