/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hitori;

import java.awt.Color;
import java.awt.Graphics;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandler;
import pencilbox.hitori.Board;
import pencilbox.hitori.Letters;
import pencilbox.util.Colors;

public class Panel
extends PanelEventHandler {
    private Board board;
    private Color paintColor = Color.blue;
    private Color circleColor = Color.magenta;
    private Color errorColor = Color.red;
    private Color singleNumberColor = new Color(0xCCCCCC);
    private boolean hideSingleMode = false;
    private boolean warnMultipleNumber = false;
    private boolean warnWrongWall = false;
    private char[] letter = new char[0];
    private int currentState = 0;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(this.board.getMaxNumber());
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setPaintColor(Color paintColor) {
        this.paintColor = paintColor;
    }

    public void setWarnWrongWall(boolean warnWrongWall) {
        this.warnWrongWall = warnWrongWall;
    }

    public void setWarnMultipleNumber(boolean warnMultilpleNumber) {
        this.warnMultipleNumber = warnMultilpleNumber;
    }

    public void setLetter(int option) {
        this.letter = Letters.getLetterSeries(option);
    }

    public void setHideSingleMode(boolean hideSingleMode) {
        this.hideSingleMode = hideSingleMode;
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        if (this.getCellCursor() != null) {
            this.drawCursor(g);
        }
    }

    void drawBoard(Graphics g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int state = this.board.getState(r, c);
                int number = this.board.getNumber(r, c);
                this.drawState(g, r, c, state);
                if (number > 0) {
                    this.drawNumber(g, r, c, number);
                } else if (number == -1) {
                    this.placeBoldCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawState(Graphics g, int r, int c, int state) {
        if (state == -2) {
            g.setColor(this.paintColor);
            if (this.warnWrongWall) {
                if (this.board.getChain(r, c) == -1) {
                    g.setColor(Colors.getError());
                } else {
                    g.setColor(this.paintColor);
                }
                if (this.board.isBlock(r, c)) {
                    g.setColor(Colors.getError());
                }
            }
            this.paintCell(g, r, c);
        } else if (state == -1) {
            g.setColor(this.circleColor);
            this.placeCircle(g, r, c);
        }
    }

    private void drawNumber(Graphics g, int r, int c, int number) {
        if (this.hideSingleMode && this.board.isSingle(r, c)) {
            g.setColor(this.singleNumberColor);
        } else if (this.warnMultipleNumber && !this.board.isBlack(r, c) && this.board.isMultipleNumber(r, c)) {
            g.setColor(this.errorColor);
        } else {
            g.setColor(this.getNumberColor());
        }
        if (number <= this.letter.length) {
            this.placeLetter(g, r, c, this.letter[number - 1]);
        } else {
            this.placeNumber(g, r, c, number);
        }
    }

    public void setColor(String target, Color color) {
        if (target.equals("paintColor")) {
            this.paintColor = color;
        } else if (target.equals("circleColor")) {
            this.circleColor = color;
        }
    }

    public Color getColor(String target) {
        if (target.equals("paintColor")) {
            return this.paintColor;
        }
        if (target.equals("circleColor")) {
            return this.circleColor;
        }
        return null;
    }

    protected void leftPressed(Address pos) {
        this.board.toggleState(pos.r, pos.c, -2);
    }

    protected void rightPressed(Address pos) {
        this.board.toggleState(pos.r, pos.c, -1);
        this.currentState = this.board.getState(pos.r, pos.c);
    }

    protected void leftDragged(Address pos) {
    }

    protected void rightDragged(Address pos) {
        int st = this.board.getState(pos.r, pos.c);
        if (st == this.currentState) {
            return;
        }
        this.board.changeStateA(pos.r, pos.c, this.currentState);
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode() && num > 0) {
            this.board.setNumber(pos.r, pos.c, num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.setNumber(pos.r, pos.c, 0);
        }
    }
}

