/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kurodoko;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.kurodoko.Number;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int HORIZ = 1;
    static final int VERT = 0;
    static final int WHITE = -1;
    static final int BLACK = -2;
    static final int UNKNOWN = 0;
    static final int OUT = -3;
    static int UNDECIDED_NUMBER = -4;
    private int[][] state;
    private int[][] chain;
    private int maxChain;
    private Number[][] number;
    private int[] adjacentChain = new int[4];
    static final String ERR_CONTINUOUS_BLACK = "\u9023\u7d9a\u3059\u308b\u9ed2\u30de\u30b9\u304c\u3042\u308b\n";
    static final String ERR_DIVIDED_BOARD = "\u9ed2\u30de\u30b9\u306b\u3088\u308a\u76e4\u9762\u304c\u5206\u65ad\u3055\u308c\u3066\u3044\u308b\n";
    static final String ERR_SMALL_SIZE = "\u767d\u30de\u30b9\u6570\u306e\u8db3\u308a\u306a\u3044\u6570\u5b57\u304c\u3042\u308b\n";
    static final String YET_LARGE_SIZE = "\u767d\u30de\u30b9\u6570\u306e\u591a\u3059\u304e\u308b\u6570\u5b57\u304c\u3042\u308b\n";

    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.chain = new int[this.rows()][this.cols()];
        this.number = new Number[this.rows()][this.cols()];
    }

    public void clearBoard() {
        super.clearBoard();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.state[r][c] == -2 || this.state[r][c] == -1) {
                    this.state[r][c] = 0;
                }
                ++c;
            }
            ++r;
        }
        this.initBoard();
    }

    int[][] getState() {
        return this.state;
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public boolean isNumber(int r, int c) {
        return this.state[r][c] > 0;
    }

    public boolean isBlack(int r, int c) {
        return this.state[r][c] == -2;
    }

    public boolean isWhiteOrNumber(int r, int c) {
        return this.state[r][c] == -1 || this.state[r][c] > 0 || this.state[r][c] == UNDECIDED_NUMBER;
    }

    public boolean isUnknown(int r, int c) {
        return this.state[r][c] == 0;
    }

    public void initBoard() {
        this.initChain();
        this.initNumber();
    }

    void initNumber() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isNumber(r, c)) {
                    this.number[r][c] = new Number(this.getState(r, c));
                    this.initNumber(r, c);
                } else {
                    this.number[r][c] = null;
                }
                ++c;
            }
            ++r;
        }
    }

    public Number getNumber(int r, int c) {
        return this.number[r][c];
    }

    public void setNumber(int r, int c, int n) {
        this.setState(r, c, n);
        this.number[r][c] = new Number(n);
        this.initNumber(r, c);
    }

    int getChain(int r, int c) {
        return this.chain[r][c];
    }

    public void changeState(int r, int c, int st) {
        int prevState = this.getState(r, c);
        this.setState(r, c, st);
        if (st == -2) {
            this.connectChain(r, c);
        } else if (prevState == -2) {
            this.cutChain(r, c);
        }
        this.updateSpace(r, c);
    }

    public void changeStateA(int r, int c, int st) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(r, c, this.state[r][c], st)));
        this.changeState(r, c, st);
    }

    public void toggleState(int r, int c, int st) {
        if (this.isNumber(r, c) || this.state[r][c] == UNDECIDED_NUMBER) {
            return;
        }
        if (this.state[r][c] == st) {
            this.changeStateA(r, c, 0);
        } else {
            this.changeStateA(r, c, st);
        }
    }

    boolean isBlock(int r, int c) {
        if (this.isBlack(r, c)) {
            if (this.isOn(r - 1, c) && this.isBlack(r - 1, c)) {
                return true;
            }
            if (this.isOn(r, c - 1) && this.isBlack(r, c - 1)) {
                return true;
            }
            if (this.isOn(r + 1, c) && this.isBlack(r + 1, c)) {
                return true;
            }
            if (this.isOn(r, c + 1) && this.isBlack(r, c + 1)) {
                return true;
            }
        }
        return false;
    }

    void initChain() {
        int c;
        this.maxChain = 1;
        ArrayUtil.initArrayInt2(this.chain, 0);
        int r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.isOnPeriphery(r, c) && this.isBlack(r, c) && this.chain[r][c] == 0 && this.initChain1(r, c, 0, 0, 1) == -1) {
                    this.setChain(r, c, -1);
                }
                ++c;
            }
            ++r;
        }
        r = 1;
        while (r < this.rows() - 1) {
            c = 1;
            while (c < this.cols() - 1) {
                if (this.isBlack(r, c) && this.chain[r][c] == 0 && this.initChain1(r, c, 0, 0, ++this.maxChain) == -1) {
                    this.setChain(r, c, -1);
                }
                ++c;
            }
            ++r;
        }
    }

    int initChain1(int r, int c, int uu, int vv, int n) {
        if (n == 1 && uu != 0 && this.isOnPeriphery(r, c)) {
            return -1;
        }
        this.chain[r][c] = n >= 0 && this.isOnPeriphery(r, c) ? 1 : n;
        int u = -1;
        while (u < 2) {
            int v = -1;
            while (v < 2) {
                if ((u != -uu || v != -vv) && this.isOn(r + u, c + v) && this.isBlack(r + u, c + v)) {
                    if (this.chain[r + u][c + v] == n) {
                        return -1;
                    }
                    if (this.initChain1(r + u, c + v, u, v, n) == -1) {
                        return -1;
                    }
                }
                v += 2;
            }
            u += 2;
        }
        return n;
    }

    void connectChain(int r, int c) {
        int[] adjacent = this.adjacentChain;
        int k = 0;
        int newChain = Integer.MAX_VALUE;
        if (this.isOnPeriphery(r, c)) {
            newChain = 1;
        }
        int u = -1;
        while (u < 2) {
            int v = -1;
            while (v < 2) {
                if (this.isOn(r + u, c + v) && this.isBlack(r + u, c + v)) {
                    if (this.isOnPeriphery(r, c) && this.chain[r + u][c + v] == 1) {
                        newChain = -1;
                    }
                    adjacent[k] = this.chain[r + u][c + v];
                    int l = 0;
                    while (l < k) {
                        if (adjacent[k] == adjacent[l]) {
                            newChain = -1;
                        }
                        ++l;
                    }
                    ++k;
                    if (this.chain[r + u][c + v] < newChain) {
                        newChain = this.chain[r + u][c + v];
                    }
                }
                v += 2;
            }
            u += 2;
        }
        if (newChain == Integer.MAX_VALUE) {
            this.chain[r][c] = ++this.maxChain;
        } else {
            this.setChain(r, c, newChain);
        }
    }

    void cutChain(int r, int c) {
        this.initChain();
    }

    void setChain(int r, int c, int n) {
        this.chain[r][c] = n;
        int u = -1;
        while (u < 2) {
            int v = -1;
            while (v < 2) {
                if (this.isOn(r + u, c + v) && this.isBlack(r + u, c + v) && this.chain[r + u][c + v] != n) {
                    this.setChain(r + u, c + v, n);
                }
                v += 2;
            }
            u += 2;
        }
    }

    int initNumber(int r0, int c0, int direction) {
        Address pos = new Address();
        int n = 0;
        pos.set(r0, c0);
        while (true) {
            pos.move(direction);
            if (!this.isOn(pos.r, pos.c) || this.isBlack(pos.r, pos.c)) break;
            ++n;
        }
        this.number[r0][c0].setNSpace(direction, n);
        pos.set(r0, c0);
        n = 0;
        while (true) {
            pos.move(direction);
            if (!this.isOn(pos.r, pos.c) || !this.isWhiteOrNumber(pos.r, pos.c)) break;
            ++n;
        }
        this.number[r0][c0].setNWhite(direction, n);
        if (this.number[r0][c0].tooSmallSpace()) {
            return -1;
        }
        if (this.number[r0][c0].tooLargeWhite()) {
            return -1;
        }
        return 0;
    }

    void initNumber(int r0, int c0) {
        this.initNumber(r0, c0, 0);
        this.initNumber(r0, c0, 2);
        this.initNumber(r0, c0, 1);
        this.initNumber(r0, c0, 3);
    }

    int updateSpace(int r0, int c0) {
        int ret = 0;
        Address pos = new Address();
        int d = 0;
        while (d < 4) {
            pos.set(r0, c0);
            while (true) {
                pos.move(d);
                if (!this.isOn(pos.r, pos.c) || this.isBlack(pos.r, pos.c)) break;
                if (!this.isNumber(pos.r, pos.c)) continue;
                ret += this.initNumber(pos.r, pos.c, d ^ 2);
            }
            ++d;
        }
        if (ret < 0) {
            return -1;
        }
        return 0;
    }

    int getSumSpace(int r, int c) {
        return this.number[r][c].getSumSpace();
    }

    int getSumWhite(int r, int c) {
        return this.number[r][c].getSumWhite();
    }

    public int checkAnswerCode() {
        int c;
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.isBlock(r, c)) {
                    result |= 1;
                }
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.chain[r][c] == -1) {
                    result |= 2;
                }
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.isNumber(r, c)) {
                    int remainder = this.number[r][c].getSumSpace() - this.number[r][c].getNumber();
                    if (remainder < 0) {
                        result |= 4;
                    } else if (remainder > 0) {
                        result |= 8;
                    }
                }
                ++c;
            }
            ++r;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return "\u5b8c\u6210\u3067\u3059";
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(ERR_CONTINUOUS_BLACK);
        }
        if ((result & 2) == 2) {
            message.append(ERR_DIVIDED_BOARD);
        }
        if ((result & 4) == 4) {
            message.append(ERR_SMALL_SIZE);
        }
        if ((result & 8) == 8) {
            message.append(YET_LARGE_SIZE);
        }
        return message.toString();
    }

    class Step
    extends AbstractUndoableEdit {
        private int row;
        private int col;
        private int before;
        private int after;

        public Step(int r, int c, int b, int a) {
            this.row = r;
            this.col = c;
            this.before = b;
            this.after = a;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            Board.this.changeState(this.row, this.col, this.before);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Board.this.changeState(this.row, this.col, this.after);
        }
    }
}

