package pencilbox.common.gui;
import java.awt.BorderLayout;
import java.awt.FlowLayout;

import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import pencilbox.common.core.Size;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilType;


/**
 * uVKv_CAO
 * [__CAOȂ̂ŁC1̃CX^X݂̂𐶐Ďg
 */

public class NewBoardDialog extends PencilBoxDialog {
	
	private static NewBoardDialog instance = new NewBoardDialog();

	/**
	 * NewBoardDialog ̃CX^X擾
	 * RXgN^͎gpsŁCCX^X͂̃\bhɂ擾
	 * @return NewBoardDialog CX^X
	 */
	public static NewBoardDialog getInstance() {
		return instance;
	}
	
	private JPanel freeSizePanel;
	private JTextField fieldRows;
	private JTextField fieldCols;

//	private boolean squareOnly = false;
	private boolean freeSize = true;
	private Size newSize;

	private NewBoardDialog() {
		super();
	}

	protected void makeDialog() {
		super.makeDialog();
		makeFreeSizePanel();
	}
	
	private void makeFreeSizePanel() {
		freeSizePanel = new JPanel();
		freeSizePanel.setLayout(new FlowLayout());
		fieldCols = new JTextField(3);
		fieldRows = new JTextField(3);
		freeSizePanel.add(new JLabel("R"));
		freeSizePanel.add(fieldCols);
		freeSizePanel.add(new JLabel("^e"));
		freeSizePanel.add(fieldRows);
		this.add(freeSizePanel, BorderLayout.CENTER); 
	}

	/**
	 * pY̎ނݒ肷
	 * @param pencilType pY̎
	 * @throws PencilBoxClassException
	 */
	public void setPencilType(PencilType pencilType) throws PencilBoxClassException {
//		PuzzleCommon puzzleCommon = (PuzzleCommon) ClassUtil.createInstance(pencilType , "Puzzle");
//		squareOnly = puzzleCommon.isSquarePuzzle();
//		if (squareOnly) {
//			fieldRows.setEditable(false);
//			fieldRows.setFocusable(false);
//		} else {
//			fieldRows.setEditable(true);
//			fieldRows.setFocusable(true);
//		}
	}
	/**
	 * ݂̔ՖʃTCY̒lC_CAO̎RݒTCỸtB[hɒlݒ肷
	 * @param s ݂̔ՖʃTCY
	 */
	public void setCurrentSize(Size s) {
		newSize = null;
		if (freeSize) {
			fieldCols.setText(Integer.toString(s.getCols()));
			fieldCols.selectAll();
			fieldRows.setText(Integer.toString(s.getRows()));
			fieldRows.selectAll();
		}
	}

	protected void setInitialFocus() {
		fieldCols.requestFocusInWindow();
	}
	
	protected void accept() {
		try {
			int rows = Integer.parseInt(fieldRows.getText());
			int cols = Integer.parseInt(fieldCols.getText());
//			if (squareOnly) {
//				rows = cols;
//			}
			newSize = new Size(rows, cols);
		} catch (NumberFormatException e) {
			showErrorMessage(e.toString());
		} finally {
			super.accept();
		}
	}
	private void showErrorMessage(String message) {
		JOptionPane.showMessageDialog(this,message,"Error",JOptionPane.ERROR_MESSAGE);
	}
	/**
	 * _CAOőIꂽTCY擾
	 * @return _CAOőIꂽTCY
	 */
	public Size getNewSize() {
		return newSize;
	}
	
}
