/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.heyawake;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pencilbox.common.core.BoardBase;
import pencilbox.heyawake.Square;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int UNKNOWN = 0;
    static final int BLACK = 1;
    static final int WHITE = 2;
    private int[][] state;
    private Square[][] square;
    private List squareList;
    int[][] chain;
    int maxChain;
    int[][] contH;
    int[][] contV;
    int[][] contWH;
    int[][] contWV;
    private int[] adjacentChain = new int[4];

    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.square = new Square[this.rows()][this.cols()];
        this.squareList = new LinkedList();
        this.contH = new int[this.rows()][this.cols()];
        this.contV = new int[this.rows()][this.cols()];
        this.contWH = new int[this.rows()][this.cols()];
        this.contWV = new int[this.rows()][this.cols()];
        this.chain = new int[this.rows()][this.cols()];
        this.maxChain = 1;
    }

    int[][] getState() {
        return this.state;
    }

    public Square getSquare(int r, int c) {
        return this.square[r][c];
    }

    public void clearBoard() {
        super.clearBoard();
        ArrayUtil.initArrayInt2(this.state, 0);
        int n = this.squareList.size() - 1;
        while (n >= 0) {
            ((Square)this.squareList.get(n)).clear();
            --n;
        }
        this.initCont();
        ArrayUtil.initArrayInt2(this.chain, 0);
    }

    public void trimAnswer() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getState(r, c) == 2) {
                    this.setState(r, c, 0);
                }
                ++c;
            }
            ++r;
        }
        this.initCont();
        this.initRoomCount();
    }

    public void initBoard() {
        this.initCont();
        this.initChain();
        this.initRoomCount();
    }

    List getSquareList() {
        return this.squareList;
    }

    public Iterator getSquareListIterator() {
        return this.squareList.iterator();
    }

    public int getSquareListSize() {
        return this.squareList.size();
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public boolean isBlack(int r, int c) {
        return this.state[r][c] == 1;
    }

    public boolean isWhite(int r, int c) {
        return this.state[r][c] == 2;
    }

    public boolean isUnknown(int r, int c) {
        return this.state[r][c] == 0;
    }

    void initCont() {
        ArrayUtil.initArrayInt2(this.contH, 0);
        ArrayUtil.initArrayInt2(this.contV, 0);
        ArrayUtil.initArrayInt2(this.contWH, 0);
        ArrayUtil.initArrayInt2(this.contWV, 0);
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getState(r, c) != 1) {
                    if (this.contH[r][c] == 0) {
                        this.countHorizontalContinuousRoom(r, c);
                    }
                    if (this.contV[r][c] == 0) {
                        this.countVerticalContinuousRoom(r, c);
                    }
                }
                if (this.getState(r, c) == 2) {
                    if (this.contWH[r][c] == 0) {
                        this.countHorizontalContinuousRoomW(r, c);
                    }
                    if (this.contWV[r][c] == 0) {
                        this.countVerticalContinuousRoomW(r, c);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    void initRoomCount() {
        Square room;
        int c;
        int r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                room = this.getSquare(r, c);
                if (room != null) {
                    room.setNBlack(0);
                    room.setNWhite(0);
                }
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                room = this.getSquare(r, c);
                if (room != null) {
                    if (this.getState(r, c) == 1) {
                        room.setNBlack(room.getNBlack() + 1);
                    } else if (this.getState(r, c) == 2) {
                        room.setNWhite(room.getNWhite() + 1);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    public void changeState(int r, int c, int st) {
        Square room;
        int prevState = this.getState(r, c);
        this.setState(r, c, st);
        if (st == 1) {
            this.contH[r][c] = 0;
            this.contV[r][c] = 0;
            if (r > 0) {
                this.countVerticalContinuousRoom(r - 1, c);
            }
            if (r < this.rows() - 1) {
                this.countVerticalContinuousRoom(r + 1, c);
            }
            if (c > 0) {
                this.countHorizontalContinuousRoom(r, c - 1);
            }
            if (c < this.cols() - 1) {
                this.countHorizontalContinuousRoom(r, c + 1);
            }
            this.connectChain(r, c);
        }
        if (prevState == 1) {
            this.countVerticalContinuousRoom(r, c);
            this.countHorizontalContinuousRoom(r, c);
            this.cutChain(r, c);
        }
        if (st == 2) {
            this.countVerticalContinuousRoomW(r, c);
            this.countHorizontalContinuousRoomW(r, c);
        }
        if (prevState == 2) {
            this.contWH[r][c] = 0;
            this.contWV[r][c] = 0;
            if (r > 0) {
                this.countVerticalContinuousRoomW(r - 1, c);
            }
            if (r < this.rows() - 1) {
                this.countVerticalContinuousRoomW(r + 1, c);
            }
            if (c > 0) {
                this.countHorizontalContinuousRoomW(r, c - 1);
            }
            if (c < this.cols() - 1) {
                this.countHorizontalContinuousRoomW(r, c + 1);
            }
        }
        if ((room = this.getSquare(r, c)) != null) {
            if (st == 1) {
                room.setNBlack(room.getNBlack() + 1);
            } else if (st == 2) {
                room.setNWhite(room.getNWhite() + 1);
            }
            if (prevState == 1) {
                room.setNBlack(room.getNBlack() - 1);
            } else if (prevState == 2) {
                room.setNWhite(room.getNWhite() - 1);
            }
        }
    }

    public void changeStateA(int r, int c, int st) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(r, c, this.state[r][c], st)));
        this.changeState(r, c, st);
    }

    public void toggleState(int r, int c, int st) {
        if (this.state[r][c] == st) {
            this.changeStateA(r, c, 0);
        } else {
            this.changeStateA(r, c, st);
        }
    }

    public void addSquareSpanning(int r0, int c0, int r1, int c1) {
        int ra = r0 < r1 ? r0 : r1;
        int rb = r0 < r1 ? r1 : r0;
        int ca = c0 < c1 ? c0 : c1;
        int cb = c0 < c1 ? c1 : c0;
        Square newSquare = new Square(ra, ca, rb, cb);
        int r = ra;
        while (r <= rb) {
            int c = ca;
            while (c <= cb) {
                if (this.square[r][c] != null) {
                    this.removeSquare(this.square[r][c]);
                }
                ++c;
            }
            ++r;
        }
        this.addSquare(newSquare);
    }

    public void removeSquareIncluding(int r, int c) {
        if (this.square[r][c] != null) {
            this.removeSquare(this.square[r][c]);
        }
    }

    public void addSquare(Square sq) {
        int r = sq.r0;
        while (r <= sq.r1) {
            int c = sq.c0;
            while (c <= sq.c1) {
                if (this.square[r][c] != null) {
                    this.removeSquare(this.square[r][c]);
                }
                this.square[r][c] = sq;
                ++c;
            }
            ++r;
        }
        this.squareList.add(sq);
    }

    public void removeSquare(Square sq) {
        int r = sq.r0;
        while (r <= sq.r1) {
            int c = sq.c0;
            while (c <= sq.c1) {
                this.square[r][c] = null;
                ++c;
            }
            ++r;
        }
        this.squareList.remove(sq);
    }

    boolean isBlock(int r, int c) {
        if (this.isBlack(r, c)) {
            if (r > 0 && this.isBlack(r - 1, c)) {
                return true;
            }
            if (r < this.rows() - 1 && this.isBlack(r + 1, c)) {
                return true;
            }
            if (c > 0 && this.isBlack(r, c - 1)) {
                return true;
            }
            if (c < this.cols() - 1 && this.isBlack(r, c + 1)) {
                return true;
            }
        }
        return false;
    }

    void countHorizontalContinuousRoom(int r, int c) {
        int count = 0;
        Square d = null;
        while (c > 0 && !this.isBlack(r, c - 1)) {
            --c;
        }
        int c0 = c;
        while (c < this.cols() && !this.isBlack(r, c)) {
            Square room = this.getSquare(r, c);
            if (room != d) {
                ++count;
                d = room;
            }
            ++c;
        }
        int c1 = c;
        c = c0;
        while (c < c1) {
            this.contH[r][c] = count;
            ++c;
        }
    }

    void countVerticalContinuousRoom(int r, int c) {
        int count = 0;
        Square d = null;
        while (r > 0 && !this.isBlack(r - 1, c)) {
            --r;
        }
        int r0 = r;
        while (r < this.rows() && !this.isBlack(r, c)) {
            Square room = this.getSquare(r, c);
            if (room != d) {
                ++count;
                d = room;
            }
            ++r;
        }
        int r1 = r;
        r = r0;
        while (r < r1) {
            this.contV[r][c] = count;
            ++r;
        }
    }

    void countHorizontalContinuousRoomW(int r, int c) {
        int count = 0;
        Square d = null;
        while (c > 0 && this.isWhite(r, c - 1)) {
            --c;
        }
        int c0 = c;
        while (c < this.cols() && this.isWhite(r, c)) {
            Square room = this.getSquare(r, c);
            if (room != d) {
                ++count;
                d = room;
            }
            ++c;
        }
        int c1 = c;
        c = c0;
        while (c < c1) {
            this.contWH[r][c] = count;
            ++c;
        }
    }

    void countVerticalContinuousRoomW(int r, int c) {
        int count = 0;
        Square d = null;
        while (r > 0 && this.isWhite(r - 1, c)) {
            --r;
        }
        int r0 = r;
        while (r < this.rows() && this.isWhite(r, c)) {
            Square room = this.getSquare(r, c);
            if (room != d) {
                ++count;
                d = room;
            }
            ++r;
        }
        int r1 = r;
        r = r0;
        while (r < r1) {
            this.contWV[r][c] = count;
            ++r;
        }
    }

    void initChain() {
        int c;
        this.maxChain = 1;
        ArrayUtil.initArrayInt2(this.chain, 0);
        int r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.isBlack(r, c) && this.chain[r][c] == 0 && this.initChain1(r, c, 0, 0, 1) == -1) {
                    this.setChain(r, c, -1);
                }
                ++c;
            }
            r = r + this.rows() - 1;
        }
        r = 1;
        while (r < this.rows() - 1) {
            c = 0;
            while (c < this.cols()) {
                if (this.isBlack(r, c) && this.chain[r][c] == 0 && this.initChain1(r, c, 0, 0, 1) == -1) {
                    this.setChain(r, c, -1);
                }
                c = c + this.cols() - 1;
            }
            ++r;
        }
        r = 1;
        while (r < this.rows() - 1) {
            c = 1;
            while (c < this.cols() - 1) {
                if (this.isBlack(r, c) && this.chain[r][c] == 0 && this.initChain1(r, c, 0, 0, ++this.maxChain) == -1) {
                    this.setChain(r, c, -1);
                }
                ++c;
            }
            ++r;
        }
    }

    int initChain1(int r, int c, int uu, int vv, int n) {
        if (n == 1 && uu != 0 && this.isOnPeriphery(r, c)) {
            return -1;
        }
        this.chain[r][c] = n >= 0 && this.isOnPeriphery(r, c) ? 1 : n;
        int u = -1;
        while (u < 2) {
            int v = -1;
            while (v < 2) {
                if ((u != -uu || v != -vv) && this.isOn(r + u, c + v) && this.isBlack(r + u, c + v)) {
                    if (this.chain[r + u][c + v] == n) {
                        return -1;
                    }
                    if (this.initChain1(r + u, c + v, u, v, n) == -1) {
                        return -1;
                    }
                }
                v += 2;
            }
            u += 2;
        }
        return n;
    }

    void connectChain(int r, int c) {
        int[] adjacent = this.adjacentChain;
        int k = 0;
        int newChain = Integer.MAX_VALUE;
        if (this.isOnPeriphery(r, c)) {
            newChain = 1;
        }
        int u = -1;
        while (u <= 1) {
            int v = -1;
            while (v <= 1) {
                if (this.isOn(r + u, c + v) && this.getState(r + u, c + v) == 1) {
                    if (this.isOnPeriphery(r, c) && this.chain[r + u][c + v] == 1) {
                        newChain = -1;
                    }
                    adjacent[k] = this.chain[r + u][c + v];
                    int l = 0;
                    while (l < k) {
                        if (adjacent[k] == adjacent[l]) {
                            newChain = -1;
                        }
                        ++l;
                    }
                    ++k;
                    if (this.chain[r + u][c + v] < newChain) {
                        newChain = this.chain[r + u][c + v];
                    }
                }
                v += 2;
            }
            u += 2;
        }
        if (newChain == Integer.MAX_VALUE) {
            this.chain[r][c] = ++this.maxChain;
        } else {
            this.setChain(r, c, newChain);
        }
    }

    void cutChain(int r, int c) {
        this.initChain();
    }

    void setChain(int r, int c, int n) {
        this.chain[r][c] = n;
        int u = -1;
        while (u < 2) {
            int v = -1;
            while (v < 2) {
                if (this.isOn(r + u, c + v) && this.isBlack(r + u, c + v) && this.chain[r + u][c + v] != n) {
                    this.setChain(r + u, c + v, n);
                }
                v += 2;
            }
            u += 2;
        }
    }

    public boolean checkContinuousBlack() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isBlock(r, c)) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    public int checkAnswerCode() {
        int c;
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.isBlock(r, c)) {
                    result |= 1;
                }
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.chain[r][c] == -1) {
                    result |= 2;
                }
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.contH[r][c] >= 3 || this.contV[r][c] >= 3) {
                    result |= 8;
                }
                ++c;
            }
            ++r;
        }
        Square room = null;
        Iterator itr = this.getSquareListIterator();
        while (itr.hasNext()) {
            room = (Square)itr.next();
            if (room.getNumber() < 0 || room.getNumber() == room.getNBlack()) continue;
            result |= 4;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return "\u5b8c\u6210\u3067\u3059";
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append("\u9023\u7d9a\u3059\u308b\u9ed2\u30de\u30b9\u304c\u3042\u308b\n");
        }
        if ((result & 2) == 2) {
            message.append("\u9ed2\u30de\u30b9\u306b\u3088\u308a\u76e4\u9762\u304c\u5206\u65ad\u3055\u308c\u3066\u3044\u308b\n");
        }
        if ((result & 4) == 4) {
            message.append("\u6570\u5b57\u3068\u9ed2\u30de\u30b9\u6570\u306e\u4e00\u81f4\u3057\u3066\u3044\u306a\u3044\u90e8\u5c4b\u304c\u3042\u308b\n");
        }
        if ((result & 8) == 8) {
            message.append("\u767d\u30de\u30b9\u304c\uff13\u90e8\u5c4b\u4ee5\u4e0a\u7d9a\u3044\u3066\u3044\u308b\u7b87\u6240\u304c\u3042\u308b\n");
        }
        return message.toString();
    }

    class Step
    extends AbstractUndoableEdit {
        private int row;
        private int col;
        private int before;
        private int after;

        public Step(int r, int c, int b, int a) {
            this.row = r;
            this.col = c;
            this.before = b;
            this.after = a;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            Board.this.changeState(this.row, this.col, this.before);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Board.this.changeState(this.row, this.col, this.after);
        }
    }
}

