/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.bijutsukan;

import pencilbox.bijutsukan.Board;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = -1;

    public PanelEventHandler() {
        this.setMaxInputNumber(5);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftPressed(Address pos) {
        this.board.toggleState(pos.r(), pos.c(), -2);
    }

    protected void rightPressed(Address pos) {
        this.board.toggleState(pos.r(), pos.c(), -3);
        this.currentState = this.board.isWall(pos.r(), pos.c()) ? -1 : this.board.getState(pos.r(), pos.c());
    }

    protected void leftDragged(Address pos) {
    }

    protected void rightDragged(Address pos) {
        if (this.board.isWall(pos.r(), pos.c())) {
            return;
        }
        if (this.board.getState(pos.r(), pos.c()) == this.currentState) {
            return;
        }
        this.board.changeStateA(pos.r(), pos.c(), this.currentState);
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos.r(), pos.c(), num);
            if (this.isSymmetricPlacementMode() && !this.board.isWall((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.changeState(posS.r(), posS.c(), 5);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos.r(), pos.c(), -1);
            if (this.isSymmetricPlacementMode() && this.board.isWall((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.changeState(posS.r(), posS.c(), -1);
            }
        }
    }

    protected void minusEntered(Address pos) {
        Address posS;
        if (this.isProblemEditMode()) {
            this.board.changeState(pos.r(), pos.c(), 5);
        }
        if (this.isSymmetricPlacementMode() && !this.board.isWall((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
            this.board.changeState(posS.r(), posS.c(), 5);
        }
    }
}

