/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.nurikabe;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.nurikabe.Panel;

public class Menu
extends MenuBase {
    private JMenuItem paintColorItem;
    private JMenuItem circleColorItem;
    private JMenuItem showWrongWallItem;
    private JMenuItem showShimaSizeItem;
    private JMenuItem colorForEachWallItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    protected void buildIndividualMenu() {
        this.paintColorItem = this.addColorMenuItem("\u9ed2\u30de\u30b9");
        this.circleColorItem = this.addColorMenuItem("\u767d\u30de\u30b9");
        this.showWrongWallItem = this.makeCheckBoxCommandMenuItem("\u8aa4\u308a\u3092\u8d64\u3067\u8868\u793a(W)", 'W', false);
        this.addToViewMenu(this.showWrongWallItem);
        this.colorForEachWallItem = this.makeCheckBoxCommandMenuItem("\u58c1\u306e\u8272\u5206\u3051(D)", 'D', false);
        this.addToViewMenu(this.colorForEachWallItem);
        this.showShimaSizeItem = this.makeCheckBoxCommandMenuItem("\u30b7\u30de\u306e\u6570\u3092\u6570\u3048\u308b(H)", 'H', false);
        this.addToViewMenu(this.showShimaSizeItem);
        this.addRenewColorMenu();
        this.addSymmetricPlacementMenuItem();
        this.addTrimAnswerMenuItem();
    }

    public void executeCommand2(JMenuItem target) {
        if (target == this.showWrongWallItem) {
            this.getPanel().setShowWrongWall(target.isSelected());
        } else if (target == this.showShimaSizeItem) {
            this.getPanel().setShowShimaSize(target.isSelected());
        } else if (target == this.colorForEachWallItem) {
            this.getPanel().setColorForEachWall(target.isSelected());
        }
    }

    public Color getColor(JMenuItem target) {
        if (target == this.paintColorItem) {
            return this.getPanel().getPaintColor();
        }
        if (target == this.circleColorItem) {
            return this.getPanel().getCircleColor();
        }
        return null;
    }

    public void setColor(JMenuItem target, Color color) {
        if (target == this.paintColorItem) {
            this.getPanel().setPaintColor(color);
        } else if (target == this.circleColorItem) {
            this.getPanel().setCircleColor(color);
        }
    }

    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.showWrongWallItem.setSelected(this.getPanel().isShowWrongWall());
        this.colorForEachWallItem.setSelected(this.getPanel().isColorForEachWall());
        this.showShimaSizeItem.setSelected(this.getPanel().isShowShimaSize());
    }
}

