/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shikaku;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.shikaku.Board;
import pencilbox.shikaku.Square;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private Color areaBorderColor = Color.BLUE;
    private Color errorColor = new Color(0xFF0000);
    private Color smallSizeColor = new Color(0xFFFF80);
    private Color areaPaintColor = new Color(0x80FFFF);
    private Square draggingArea;
    private boolean colorfulMode = false;
    private boolean showAreaHint = false;

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getAreaPaintColor() {
        return this.areaPaintColor;
    }

    public void setAreaPaintColor(Color areaPaintColor) {
        this.areaPaintColor = areaPaintColor;
    }

    public boolean isColorfulMode() {
        return this.colorfulMode;
    }

    public void setColorfulMode(boolean colorfulMode) {
        this.colorfulMode = colorfulMode;
    }

    public boolean isShowAreaHint() {
        return this.showAreaHint;
    }

    public void setShowAreaHint(boolean showAreaHint) {
        this.showAreaHint = showAreaHint;
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawDragging(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    void drawBoard(Graphics g) {
        g.setColor(this.smallSizeColor);
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                Square domain = this.board.getSquare(r, c);
                if (domain != null) {
                    if (this.isShowAreaHint()) {
                        int number = domain.getNumber();
                        if (number == -2) {
                            g.setColor(this.errorColor);
                        } else if (number == 0) {
                            g.setColor(this.smallSizeColor);
                        } else if (number == -1) {
                            g.setColor(this.areaPaintColor);
                        } else if (number < domain.getSquareSize()) {
                            g.setColor(this.errorColor);
                        } else if (number == domain.getSquareSize()) {
                            g.setColor(this.areaPaintColor);
                        } else if (number > domain.getSquareSize()) {
                            g.setColor(this.smallSizeColor);
                        }
                    } else if (this.isColorfulMode()) {
                        g.setColor(Colors.getBrightColor(this.board.getSquare(r, c).getId()));
                    } else {
                        g.setColor(this.areaPaintColor);
                    }
                    this.paintCell(g, r, c);
                }
                ++c;
            }
            ++r;
        }
        g.setFont(this.getNumberFont());
        g.setColor(this.getNumberColor());
        int r2 = 0;
        while (r2 < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int num = this.board.getNumber(r2, c);
                if (num > 0) {
                    this.placeNumber(g, r2, c, num);
                } else if (num == -1) {
                    this.placeNumber(g, r2, c, num);
                }
                ++c;
            }
            ++r2;
        }
        g.setColor(this.areaBorderColor);
        Iterator itr = this.board.getSquareListIterator();
        while (itr.hasNext()) {
            Square area = (Square)itr.next();
            this.placeSquare(g, area.r0, area.c0, area.r1, area.c1);
        }
    }

    public void placeNumber(Graphics g, int r, int c, int num) {
        g.setColor(Color.BLACK);
        super.placeFilledCircle(g, r, c, (int)((double)this.getCellSize() * 0.85));
        g.setColor(Color.WHITE);
        if (num > 0) {
            super.placeNumber(g, r, c, num);
        }
    }

    private void drawDragging(Graphics g) {
        Square area = this.getDraggingArea();
        if (area == null) {
            return;
        }
        this.placeSquare(g, area.r0, area.c0, area.r1, area.c1);
    }

    void setDraggingArea(Square draggingArea) {
        this.draggingArea = draggingArea;
    }

    Square getDraggingArea() {
        return this.draggingArea;
    }
}

