/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.masyu;

import java.awt.Color;
import java.awt.Graphics;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.masyu.Board;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private boolean colorForEachLink = false;
    private boolean warnBranchedLink = false;
    private Color lineColor = Color.BLUE;
    private Color crossColor = Color.MAGENTA;
    private Color pearlColor = Color.BLACK;
    private Color grayPearlColor = Color.GRAY;
    private Color errorColor = Color.RED;

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Color getCrossColor() {
        return this.crossColor;
    }

    public void setCrossColor(Color crossColor) {
        this.crossColor = crossColor;
    }

    public Color getPearlColor() {
        return this.pearlColor;
    }

    public void setPearlColor(Color pearlColor) {
        this.pearlColor = pearlColor;
    }

    public boolean isColorForEachLink() {
        return this.colorForEachLink;
    }

    public void setColorForEachLink(boolean colorForEachLink) {
        this.colorForEachLink = colorForEachLink;
    }

    public boolean isWarnBranchedLink() {
        return this.warnBranchedLink;
    }

    public void setWarnBranchedLink(boolean warnBranchedLink) {
        this.warnBranchedLink = warnBranchedLink;
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    void drawBoard(Graphics g) {
        int state;
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                state = this.board.getNumber(r, c);
                if (state == 1) {
                    this.placeWhitePearl(g, r, c);
                } else if (state == 2) {
                    this.placeBlackPearl(g, r, c);
                } else if (state == 3) {
                    this.placeGrayPearl(g, r, c);
                }
                ++c;
            }
            ++r;
        }
        int d = 0;
        while (d <= 1) {
            int r2 = 0;
            while (r2 < this.board.rows()) {
                int c = 0;
                while (c < this.board.cols()) {
                    state = this.board.getState(d, r2, c);
                    if (state == 1) {
                        g.setColor(this.lineColor);
                        if (this.isColorForEachLink()) {
                            g.setColor(Colors.getColor(this.board.getLink(d, r2, c).getID()));
                        }
                        if (this.isWarnBranchedLink() && this.board.isBranchedLink(d, r2, c)) {
                            g.setColor(this.errorColor);
                        }
                        this.placeTraversalLine(g, d, r2, c);
                    } else if (state == -1) {
                        g.setColor(this.crossColor);
                        this.placeSideCross(g, d, r2, c);
                    }
                    ++c;
                }
                ++r2;
            }
            ++d;
        }
    }

    private void placeBlackPearl(Graphics g, int r, int c) {
        g.setColor(this.pearlColor);
        if (this.isWarnBranchedLink()) {
            int p = this.board.checkBlackPearl(r, c);
            if (p == -1) {
                g.setColor(this.errorColor);
            } else {
                g.setColor(this.pearlColor);
            }
        }
        this.placeFilledCircle(g, r, c);
    }

    private void placeWhitePearl(Graphics g, int r, int c) {
        g.setColor(this.pearlColor);
        if (this.isWarnBranchedLink()) {
            int p = this.board.checkWhitePearl(r, c);
            if (p == -1) {
                g.setColor(this.errorColor);
            } else {
                g.setColor(this.pearlColor);
            }
        }
        this.placeBoldCircle(g, r, c);
    }

    private void placeGrayPearl(Graphics g, int r, int c) {
        g.setColor(this.grayPearlColor);
        this.placeFilledCircle(g, r, c);
    }
}

