/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Problem;
import pencilbox.common.core.Property;
import pencilbox.common.core.Rotator;
import pencilbox.common.core.Size;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;

public class ProblemCopierBase {
    public Problem duplicateProblem(Problem src) throws PencilBoxClassException {
        Problem dst = new Problem();
        dst.setBoard(this.duplicateBoard(src.getBoard()));
        dst.setProperty(new Property(src.getProperty()));
        dst.setFile(src.getFile());
        return dst;
    }

    public BoardBase duplicateBoard(BoardBase src) throws PencilBoxClassException {
        return this.duplicateBoard(src, 0);
    }

    public BoardBase duplicateBoard(BoardBase src, int n) throws PencilBoxClassException {
        BoardBase dst = (BoardBase)ClassUtil.createInstance(this.getClass(), "Board");
        if (Rotator.isTransposed(n)) {
            dst.setSize(new Size(src.cols(), src.rows()));
        } else {
            dst.setSize(new Size(src.rows(), src.cols()));
        }
        this.copyBoardStates(src, dst, n);
        return dst;
    }

    protected void copyBoardStates(BoardBase src, BoardBase dst, int n) {
    }
}

