/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.fillomino;

import java.awt.Color;
import java.awt.Graphics;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.fillomino.Board;

public class Panel
extends PanelBase {
    private Board board;
    private boolean showAreaBorder = true;
    private boolean showAreaHint = false;
    private Color inputColor = Color.BLUE;
    private Color areaBorderColor = Color.BLUE;
    private Color errorColor = Color.RED;
    private Color successColor = new Color(0x80FFFF);

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public boolean isShowAreaBorder() {
        return this.showAreaBorder;
    }

    public void setShowAreaBorder(boolean showAreaBorder) {
        this.showAreaBorder = showAreaBorder;
    }

    public boolean isShowAreaHint() {
        return this.showAreaHint;
    }

    public void setShowAreaHint(boolean showAreaHint) {
        this.showAreaHint = showAreaHint;
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    void drawBoard(Graphics g) {
        this.drawNumbers(g);
        if (this.isShowAreaBorder()) {
            this.drawBorders(g);
        }
    }

    private void drawNumbers(Graphics g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int number = this.board.getNumber(r, c);
                if (number > 0 && this.isShowAreaHint()) {
                    int status = this.board.getArea(r, c).getStatus();
                    if (status == -1) {
                        g.setColor(this.errorColor);
                        this.paintCell(g, r, c);
                    } else if (status == 1) {
                        g.setColor(this.successColor);
                        this.paintCell(g, r, c);
                    }
                }
                if (number > 0) {
                    if (this.board.isStable(r, c)) {
                        g.setColor(this.getNumberColor());
                    } else {
                        g.setColor(this.inputColor);
                    }
                    this.placeNumber(g, r, c, this.board.getNumber(r, c));
                } else if (number == 0 && this.board.isStable(r, c)) {
                    g.setColor(this.getNumberColor());
                    this.placeBoldCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawBorders(Graphics g) {
        g.setColor(this.areaBorderColor);
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols() - 1) {
                if (this.board.getNumber(r, c) != this.board.getNumber(r, c + 1)) {
                    this.placeSideLine(g, 0, r, c);
                }
                ++c;
            }
            if (this.board.getArea(r, 0) != null) {
                this.placeSideLine(g, 0, r, -1);
            }
            if (this.board.getArea(r, this.board.cols() - 1) != null) {
                this.placeSideLine(g, 0, r, this.board.cols() - 1);
            }
            ++r;
        }
        int c = 0;
        while (c < this.board.cols()) {
            int r2 = 0;
            while (r2 < this.board.rows() - 1) {
                if (this.board.getNumber(r2, c) != this.board.getNumber(r2 + 1, c)) {
                    this.placeSideLine(g, 1, r2, c);
                }
                ++r2;
            }
            if (this.board.getArea(0, c) != null) {
                this.placeSideLine(g, 1, -1, c);
            }
            if (this.board.getArea(this.board.rows() - 1, c) != null) {
                this.placeSideLine(g, 1, this.board.rows() - 1, c);
            }
            ++c;
        }
    }
}

