/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.sudoku;

import pencilbox.sudoku.Board;

public class DigitPatternHint {
    private int allDigitPattern = 1022;
    private Board board;
    private int[][] pattern;

    int getPattern(int r, int c) {
        return this.pattern[r][c];
    }

    void setupHint(Board board) {
        this.board = board;
        this.pattern = new int[board.rows()][board.cols()];
        int maxNumber = board.rows();
        this.allDigitPattern = ~((-1 << maxNumber + 1) + 1);
    }

    void initHint() {
        int c;
        int rows = this.board.rows();
        int cols = this.board.cols();
        int r = 0;
        while (r < rows) {
            c = 0;
            while (c < cols) {
                this.pattern[r][c] = this.allDigitPattern;
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < rows) {
            c = 0;
            while (c < cols) {
                int n = this.board.getNumber(r, c);
                if (n > 0) {
                    this.checkUsedNumber(r, c, n);
                }
                ++c;
            }
            ++r;
        }
    }

    boolean canPlace(int r, int c, int n) {
        return (this.pattern[r][c] & 1 << n) > 0;
    }

    void checkUsedNumber(int r0, int c0, int n) {
        int rows = this.board.rows();
        int cols = this.board.cols();
        int unit = this.board.getUnit();
        int pat = ~(1 << n);
        int cc = 0;
        while (cc < cols) {
            int[] nArray = this.pattern[r0];
            int n2 = cc++;
            nArray[n2] = nArray[n2] & pat;
        }
        int rr = 0;
        while (rr < rows) {
            int[] nArray = this.pattern[rr];
            int n3 = c0;
            nArray[n3] = nArray[n3] & pat;
            ++rr;
        }
        int boxR = r0 / unit * unit;
        int boxC = c0 / unit * unit;
        int rr2 = 0;
        while (rr2 < unit) {
            int cc2 = 0;
            while (cc2 < unit) {
                int[] nArray = this.pattern[boxR + rr2];
                int n4 = boxC + cc2;
                nArray[n4] = nArray[n4] & pat;
                ++cc2;
            }
            ++rr2;
        }
    }

    void updateHint(int r0, int c0, int n) {
        int prevNum = this.board.getNumber(r0, c0);
        if (prevNum > 0) {
            this.deleteHint(r0, c0, prevNum);
        }
        if (n > 0) {
            this.checkUsedNumber(r0, c0, n);
        }
    }

    void deleteHint(int r0, int c0, int n0) {
        int c;
        int pat = 1 << n0;
        int rows = this.board.rows();
        int cols = this.board.cols();
        int r = 0;
        while (r < rows) {
            c = 0;
            while (c < cols) {
                int[] nArray = this.pattern[r];
                int n = c++;
                nArray[n] = nArray[n] | pat;
            }
            ++r;
        }
        r = 0;
        while (r < rows) {
            c = 0;
            while (c < cols) {
                int n = this.board.getNumber(r, c);
                if (n == n0 && (r != r0 || c != c0)) {
                    this.checkUsedNumber(r, c, n);
                }
                ++c;
            }
            ++r;
        }
    }
}

