/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slitherlink;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.slitherlink.Board;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private boolean warnBranchedLink = false;
    private boolean colorForEachLink = false;
    private Color lineColor = Color.BLUE;
    private Color crossColor = Color.MAGENTA;
    private Color errorColor = Color.RED;

    public Panel() {
        this.setGridColor(Color.BLACK);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getCrossColor() {
        return this.crossColor;
    }

    public void setCrossColor(Color crossColor) {
        this.crossColor = crossColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public boolean isColorForEachLink() {
        return this.colorForEachLink;
    }

    public void setColorForEachLink(boolean colorForEachLink) {
        this.colorForEachLink = colorForEachLink;
    }

    public boolean isWarnBranchedLink() {
        return this.warnBranchedLink;
    }

    public void setWarnBranchedLink(boolean warnBranchedLink) {
        this.warnBranchedLink = warnBranchedLink;
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    public void drawGrid(Graphics g) {
        g.setColor(this.getGridColor());
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                g.fillRect(this.toX(c) + this.getHalfCellSize() - 1, this.toY(r) + this.getHalfCellSize() - 1, 3, 3);
                ++c;
            }
            ++r;
        }
    }

    void drawBoard(Graphics g) {
        int number;
        g.setFont(this.getNumberFont());
        g.setColor(this.getNumberColor());
        int r = 0;
        while (r < this.board.rows() - 1) {
            int c = 0;
            while (c < this.board.cols() - 1) {
                number = this.board.getNumber(r, c);
                if (number >= 0 && number <= 4) {
                    if (this.isWarnBranchedLink()) {
                        int nline = this.board.lineAround(r, c);
                        if (nline > number) {
                            g.setColor(this.errorColor);
                        } else {
                            g.setColor(this.getNumberColor());
                        }
                    }
                    this.placeNumber2(g, r, c, number);
                } else if (number == 5) {
                    this.placeCircle2(g, r, c);
                }
                ++c;
            }
            ++r;
        }
        int d = 0;
        while (d <= 1) {
            int r2 = 0;
            while (r2 < this.board.rows()) {
                int c = 0;
                while (c < this.board.cols()) {
                    number = this.board.getState(d, r2, c);
                    if (number == 1) {
                        g.setColor(this.lineColor);
                        if (this.isColorForEachLink()) {
                            g.setColor(Colors.getColor(this.board.getLink(d, r2, c).getID()));
                        }
                        if (this.warnBranchedLink && this.board.isBranchedLink(d, r2, c)) {
                            g.setColor(this.errorColor);
                        }
                        this.placeTraversalLine(g, d, r2, c);
                    } else if (number == -1) {
                        g.setColor(this.crossColor);
                        this.placeSideCross(g, d, r2, c);
                    }
                    ++c;
                }
                ++r2;
            }
            ++d;
        }
    }

    void placeNumber2(Graphics g, int r, int c, int num) {
        FontMetrics metrics = g.getFontMetrics();
        String numS = Integer.toString(num);
        g.drawString(numS, this.toX(c) + (this.getCellSize() - 1 - metrics.stringWidth(numS)) / 2 + 1 + this.getHalfCellSize(), this.toY(r) + (this.getCellSize() - 1 - metrics.getHeight()) / 2 + metrics.getAscent() + 1 + this.getHalfCellSize());
    }

    protected void placeCircle2(Graphics g, int r, int c) {
        int x = this.toX(c) + (this.getCellSize() - this.getCircleSize()) / 2 + this.getHalfCellSize();
        int y = this.toY(r) + (this.getCellSize() - this.getCircleSize()) / 2 + this.getHalfCellSize();
        g.drawOval(x, y, this.getCircleSize(), this.getCircleSize());
        g.drawOval(x + 1, y + 1, this.getCircleSize() - 2, this.getCircleSize() - 2);
    }

    public void drawCursor(Graphics g) {
        if (this.isProblemEditMode()) {
            g.setColor(this.getCursorColor());
            g.drawRect(this.toX(this.getCellCursor().c()) + this.getHalfCellSize(), this.toY(this.getCellCursor().r()) + this.getHalfCellSize(), this.getCellSize(), this.getCellSize());
            g.drawRect(this.toX(this.getCellCursor().c()) + this.getHalfCellSize() + 1, this.toY(this.getCellCursor().r()) + this.getHalfCellSize() + 1, this.getCellSize() - 2, this.getCellSize() - 2);
        }
    }
}

