/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slitherlink;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.slitherlink.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;

    public PanelEventHandler() {
        this.setMaxInputNumber(3);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public boolean isCursorOnBoard(Address pos) {
        return this.board.isNumberOn(pos.r(), pos.c());
    }

    protected void leftClickedEdge(SideAddress pos) {
        this.board.toggleState(pos.d(), pos.r(), pos.c(), 1);
    }

    protected void rightClickedEdge(SideAddress pos) {
        this.board.toggleState(pos.d(), pos.r(), pos.c(), -1);
    }

    protected void leftDragged(Address dragStart, Address dragEnd) {
        if (dragStart.r() == dragEnd.r() || dragStart.c() == dragEnd.c()) {
            this.board.determineInlineState(dragStart, dragEnd, 1);
        }
    }

    protected void rightDragged(Address dragStart, Address dragEnd) {
        if (dragStart.r() == dragEnd.r() || dragStart.c() == dragEnd.c()) {
            this.board.determineInlineState(dragStart, dragEnd, 0);
        }
    }

    protected void moveCursor(Address pos) {
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos.r(), pos.c(), num);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setNumber(posS.r(), posS.c(), 5);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos.r(), pos.c(), -1);
            if (this.isSymmetricPlacementMode() && this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setNumber(posS.r(), posS.c(), -1);
            }
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos.r(), pos.c(), 5);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setNumber(posS.r(), posS.c(), 5);
            }
        }
    }

    public Address getSymmetricPosition(Address pos) {
        return new Address(this.board.rows() - 2 - pos.r(), this.board.cols() - 2 - pos.c());
    }
}

