package pencilbox.hakyukoka;

import java.awt.Color;

import javax.swing.JMenuItem;

import pencilbox.common.gui.MenuBase;

/**
 * ugyʁvj[NX
 */
public class Menu extends MenuBase {

	private JMenuItem inputColorItem;
	private JMenuItem warnWrongNumberItem;
	private JMenuItem hilightSelectedNumberItem;
	private JMenuItem showArrowedNumberDotItem;
	
	public Panel getPanel() {
		return (Panel)getPanelBase();
	}

	protected void buildIndividualMenu(){
		super.buildIndividualMenu();
		inputColorItem = addColorMenuItem("͐");
		addCursorMenu();
		addToViewMenu(warnWrongNumberItem = makeCheckBoxCommandMenuItem("Ԃŕ\(W)", 'W', false));
		addToViewMenu(hilightSelectedNumberItem = makeCheckBoxCommandMenuItem("I𐔎nCCg(H)", 'H', false));
		addToViewMenu(showArrowedNumberDotItem = makeCheckBoxCommandMenuItem("\Ȑhbg\(D)", 'D', false));
		addSymmetricPlacementMenuItem();
	}

	public void executeCommand2(JMenuItem target) {
		if (target == warnWrongNumberItem)
			getPanel().setWarnWrongNumber(target.isSelected());
		else if (target == hilightSelectedNumberItem)
			getPanel().setHighlightSelectedNumber(target.isSelected());
		else if (target == showArrowedNumberDotItem)
			getPanel().setShowAllowedNumberDot(target.isSelected());
	}

	public void setColor(JMenuItem target, Color color) {
		if (target == inputColorItem)
			getPanel().setInputColor(color);
	}
	
	public Color getColor(JMenuItem target) {
		if (target == inputColorItem)
			getPanel().getInputColor();
		return null;
	}

	public void updateCurrentMenuSelection() {
		super.updateCurrentMenuSelection();
		warnWrongNumberItem.setSelected(getPanel().isWarnWrongNumber());
		hilightSelectedNumberItem.setSelected(getPanel().isHighlightSelectedNumber());
		showArrowedNumberDotItem.setSelected(getPanel().isShowAllowedNumberDot());
	}

}
