package pencilbox.nurikabe;

import java.util.LinkedList;
import java.util.List;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.util.ArrayUtil;


/**
 *  uʂ肩ׁvՖʃNX
 */
public class Board extends BoardBase {

	public static final int SPACE = -1;
	public static final int WALL = -2;
	public static final int UNKNOWN = 0;
	public static final int UNDECIDED_NUMBER = -3;
	
	private int[][] state;

	private Area[][] area; // }X܂͊m蔒}Ẍp
	private Area[][] whiteArea; // 󔒃}X܂ޔ}Ẍ搳𔻒p
	private List<Area> wallAreaList;
	private List<Area> spaceAreaList;
	private Area initializingArea;

	protected void setup(){
		super.setup();
		state = new int[rows()][cols()];
		area = new Area[rows()][cols()];
		whiteArea = new Area[rows()][cols()];
		wallAreaList = new LinkedList<Area>();
		spaceAreaList = new LinkedList<Area>();
	}

	public void clearBoard() {
		super.clearBoard();
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (!isNumber(r,c))
					state[r][c] = UNKNOWN;
				}
		}
		initBoard();
	}

	public void trimAnswer() {
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (state[r][c] == SPACE)
					state[r][c] = UNKNOWN;
				}
		}
		initBoard();
	}

	/**
	 * @return Returns the state.
	 */
	int[][] getState() {
		return state;
	}
	/**
	 * @param r row coordinate of the cell
	 * @param c column coordinate of the cell
	 * @return Returns the state of the cell.
	 */
	public int getState(int r, int c) {
		return state[r][c];
	}

	public int getState(Address pos) {
		return getState(pos.r(), pos.c());
	}
	/**
	 * @param r row coordinate of the cell
	 * @param c column coordinate of the cell
	 * @param st state to set
	 */
	public void setState(int r, int c, int st) {
		state[r][c] = st;
	}

	public void setState(Address pos, int st) {
		setState(pos.r(), pos.c(), st);
	}

	public boolean isNumber(int r, int c) {
		return isOn(r,c) && (state[r][c] > 0 || state[r][c] == UNDECIDED_NUMBER);
	}
	
	public boolean isNumber(Address pos) {
		return isNumber(pos.r(), pos.c());
	}
	
	public boolean isWall(int r, int c) {
		return isOn(r,c) && (state[r][c] == WALL);
	}
	public boolean isUnknown(int r, int c) {
		return (state[r][c] == UNKNOWN);
	}
	public int getSpaceOrWall(int r, int c) {
		if (state[r][c] > 0)
			return SPACE;
		else if (state[r][c] == UNDECIDED_NUMBER)
			return SPACE;
		else
			return state[r][c];
	}
	public boolean isSpaceOrNumber(int r, int c) {
		return isOn(r,c) && (state[r][c] > 0 || state[r][c] == SPACE || state[r][c] == UNDECIDED_NUMBER);
	}

	public void initBoard() {
		initAreas();
	}
	/**
	 * ݂̔ՖʏԂɊÂāC̈̐ݒs
	 */
	public void initAreas() {
		ArrayUtil.initArrayObject2(area, null);
		wallAreaList.clear();
		spaceAreaList.clear();
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (getState(r, c) != UNKNOWN && area[r][c] == null) {
					initArea(r,c);
				}
			}
		}
	}
	/**
	 * w肵}XN_Ƃă}X̂Ȃ𒲂ׂArea쐬
	 * @param r
	 * @param c
	 */
	void initArea(int r, int c) {
		initializingArea = makeNewArea(r, c);
		initArea1(r, c);
	}

	private void initArea1(int r, int c) {
		if (!isOn(r, c))
			return;
		if (getArea(r, c) == initializingArea)
			return;
		if (getSpaceOrWall(r, c) != initializingArea.getAreaType())
			return;
		initializingArea.add(r, c);
		if (isNumber(r, c))
			initializingArea.addNumber(getState(r, c));
		setArea(r, c, initializingArea);
		initArea1(r - 1, c);
		initArea1(r, c - 1);
		initArea1(r + 1, c);
		initArea1(r, c + 1);
	}
	/**
	 * ̃}X̏̈擾
	 * ̃}ẌɑĂȂꍇ null Ԃ
	 * @param r Row coordinate of the cell.
	 * @param c Colmun coordinate of the cell.
	 * @return Returns the area.
	 */
	public Area getArea(int r, int c) {
		// mergeArea Ȃǂgpꍇ̂߂ɁC`FbNs
		if (!isOn(r, c))
			return null;
		return area[r][c];
	}
	/**
	 * Տ̃}XɁC̃}X̏̈ݒ肷
	 * @param r Row coordinate of the cell.
	 * @param c Colmun coordinate of the cell.
	 * @param a The area to set.
	 */
	public void setArea(int r, int c, Area a) {
		area[r][c] = a;
	}

	public void changeState(int r, int c, int st) {
		int prevSt = getSpaceOrWall(r, c);
		setState(r, c, st);
		int type;
		if (st > 0)
			type = SPACE;
		else
			type = st;
		if (prevSt != UNKNOWN) {
			splitArea(r, c, prevSt);
		}
		if (st != UNKNOWN) {
			mergeArea(r, c, type);
		}
	}
	
	public void changeState(Address pos, int st) {
		changeState(pos.r(), pos.c(), st);
	}
	/**
	 * }X̏Ԃw肵ԂɕύXCύXAhDXi[ɒʒm
	 * @param pos }XW
	 * @param st ύX̏
	 */
	public void changeStateA(Address pos, int st) {
		fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(pos.r(), pos.c(), getState(pos), st)));
		changeState(pos, st);
	}

	/**
	 * }X̏ԂύXƂ Area s
	 * @param r ύX}X̍sW
	 * @param c ύX}X̗W
	 * @param type ύẌ̗̎
	 */
	void mergeArea(int r, int c, int type) {
		Area mergedArea = null;
		mergedArea = mergeArea1(getArea(r-1, c), mergedArea, type);
		mergedArea = mergeArea1(getArea(r, c-1), mergedArea, type);
		mergedArea = mergeArea1(getArea(r+1, c), mergedArea, type);
		mergedArea = mergeArea1(getArea(r, c+1), mergedArea, type);
		if (mergedArea == null) {
			mergedArea = makeNewArea(r,c);
		}
		mergedArea.add(r,c);
		if (isNumber(r,c))
			mergedArea.addNumber(getState(r,c));
		setArea(r, c, mergedArea);
	}

	private Area mergeArea1(Area a, Area mergedArea, int type) {
		if (a != null && a.getAreaType() == type) {
			if (mergedArea == null){
				mergedArea = a;
			} else if (mergedArea != a) {
				mergedArea.addAll(a);
				for (Address pos : a) {
					setArea(pos.r(), pos.c(), mergedArea);
					if (isNumber(pos.r(),pos.c()))
						mergedArea.addNumber(getState(pos.r(),pos.c()));
				}
				removeAreaFromList(a);
			}
		}
		return mergedArea;
	}
	/**
	 * }X̏ԂύXCƂ Area̕s
	 * @param r ύX}X̍sW
	 * @param c ύX}X̗W
	 * @param type ύẌ̗̎
	 */
	void splitArea(int r, int c, int type) {
		Area oldArea = getArea(r, c);
		Area largerArea = null;
		removeAreaFromList(oldArea);
		for (Address pos : oldArea) {
			setArea(pos.r(), pos.c(), null);
		}
		if (isOn(r-1,c) && getSpaceOrWall(r-1,c)==type && getArea(r-1,c) == null) {
			initArea(r-1,c);
			if (largerArea == null || initializingArea.size() > largerArea.size())
				largerArea = initializingArea;
		}
		if (isOn(r,c-1) && getSpaceOrWall(r,c-1)==type && getArea(r,c-1) == null) {
			initArea(r,c-1);
			if (largerArea == null || initializingArea.size() > largerArea.size())
				largerArea = initializingArea;
		}
		if (isOn(r+1,c) && getSpaceOrWall(r+1,c)==type && getArea(r+1,c) == null) {
			initArea(r+1,c);
			if (largerArea == null || initializingArea.size() > largerArea.size())
				largerArea = initializingArea;
		}
		if (isOn(r,c+1) && getSpaceOrWall(r,c+1)==type && getArea(r,c+1) == null) {
			initArea(r,c+1);
			if (largerArea == null || initializingArea.size() > largerArea.size())
				largerArea = initializingArea;
		}
		if (largerArea != null) {
			largerArea.setId(oldArea.getId());
		}
	}
	/**
	 * ɍW^}X܂ Area V쐬
	 * @param r }X̍sW
	 * @param c }X̗W
	 * @return 쐬̈
	 */
	private Area makeNewArea(int r, int c) {
		if (isWall(r,c)) {
			Area a = new Area(WALL);
			wallAreaList.add(a);
			return a;
		} else if (isSpaceOrNumber(r,c)) {
			Area a = new Area(SPACE);
			spaceAreaList.add(a);
			return a;
		} else {
			return null;
		}
	}

	private void removeAreaFromList(Area a) {
		int type = a.getAreaType();
		if (type == WALL)
			wallAreaList.remove(a);
		else if (type == SPACE) {
			spaceAreaList.remove(a);
		}
	}

	/**
	 * ̃}X22̍}XubN̈pǂ𒲂ׂ
	 * @param r
	 * @param c
	 * @return 2x2ubNȂ true
	 */
	boolean is2x2Block(int r, int c) {
		if (isWall(r,c)) {
			if (isWall(r-1,c)) {
				if (isWall(r,c-1)) {
					if (isWall(r-1,c-1)) {
						return true;
					}
				}
				if (isWall(r,c+1)) {
					if (isWall(r-1,c+1)) {
						return true;
					}
				}
			}
			if (isWall(r+1,c)) {
				if (isWall(r,c-1)) {
					if (isWall(r+1,c-1)) {
						return true;
					}
				}
				if (isWall(r,c+1)) {
					if (isWall(r+1,c+1)) {
						return true;
					}
				}
			}
		}
		return false;
	}

	public int checkAnswerCode() {
		int result = 0;
		for (int r=rows()-1; r>=0; r--) {
			for (int c=cols()-1; c>=0; c--) {
//				if (isUnknown(r,c)) {
//					result |= 1;
//				}
				if (is2x2Block(r,c)) {
					result |= 64;
				}
			}
		}
		if (wallAreaList.size() > 1) {
			result |= 32;
		}
//		result |= checkSpaceAreas();
		result |= checkWhiteAreas();
		return result;
	}

//	/**
//	 * m蔒}X݂̂𔒃}XƂ݂ȂāC}ẌɊւĐ𔻒肷B
//	 */
//	private int checkSpaceAreas() {
//		int ret = 0;
//		for (Area a : spaceAreaList) {
//			ret |= checkSpaceArea(a);
//		}
//		return ret;
//	}

	/**
	 * 󔒃}XƊm蔒}XƂƂʂ}XƂ݂ȂāC}ẌɊւĐ𔻒肷B
	 */
	private int checkWhiteAreas() {
		ArrayUtil.initArrayObject2(whiteArea, null);
		int ret = 0;
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				if (getState(r, c) != WALL && whiteArea[r][c] == null) {
					initializingArea = new Area(SPACE);
					initWhiteArea1(r, c);
					ret |= checkSpaceArea(initializingArea);
				}
			}
		}
		return ret;
	}

	private int checkSpaceArea(Area a) {
		int ret = 0;
		int number = a.getNumber();
		if (number == 0) {
			ret |= 16;
		} else if (number == Area.MULTIPLE_NUMBER) {
			ret |= 8;
		} else if (number == UNDECIDED_NUMBER) {
			;
		} else if (number > 0) {
			if (a.size() < number) {
				ret |= 4;
			} else if (a.size() > number) {
				ret |= 2;
			}
		}
		return ret;
	}

	private void initWhiteArea1(int r, int c) {
		if (!isOn(r, c))
			return;
		if (whiteArea[r][c] == initializingArea)
			return;
		if (getState(r, c) == WALL)
			return;
		initializingArea.add(r, c);
		if (isNumber(r, c))
			initializingArea.addNumber(getState(r, c));
		whiteArea[r][c] = initializingArea;
		initWhiteArea1(r - 1, c);
		initWhiteArea1(r, c - 1);
		initWhiteArea1(r + 1, c);
		initWhiteArea1(r, c + 1);
	}

	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result==0)
			return COMPLETE_MESSAGE;
		if (result==1)
			return Messages.getString("Board.AnswerCheckMessage1"); //$NON-NLS-1$
		StringBuffer message = new StringBuffer();
//		if ((result & 2) == 2)
//			message.append("ʐς̑傫V}\n"); 
//		if ((result & 4) == 4)
//			message.append("ʐς̏V}\n"); 
		if ((result & 2) == 2 || (result & 4) == 4)
			message.append(Messages.getString("Board.AnswerCheckMessage2"));  //$NON-NLS-1$
		if ((result & 8) == 8)
			message.append(Messages.getString("Board.AnswerCheckMessage4"));  //$NON-NLS-1$
		if ((result & 16) == 16)
			message.append(Messages.getString("Board.AnswerCheckMessage5"));  //$NON-NLS-1$
		if ((result & 32) == 32)
			message.append(Messages.getString("Board.AnswerCheckMessage6"));  //$NON-NLS-1$
		if ((result & 64) == 64)
			message.append(Messages.getString("Board.AnswerCheckMessage7"));  //$NON-NLS-1$
		return message.toString();
	}

	/**
	 * P̑\NX
	 * UNDO, REDO ł̕ҏW̒PʂƂȂ
	 */
	 class Step extends AbstractUndoableEdit {
	
		private int row;
		private int col;
		private int before;
		private int after;
		/**
		 * RXgN^
		 * @param r ύXꂽ}X̍sW
		 * @param c ύXꂽ}X̗W
		 * @param b ύXȌ
		 * @param a ύX̏
		 */
		public Step(int r, int c, int b, int a) {
			super();
			row = r;
			col = c;
			before = b;
			after = a;
		}

		public void undo() throws CannotUndoException {
			super.undo();
			changeState(row, col, before);
		}

		public void redo() throws CannotRedoException {
			super.redo();
			changeState(row, col, after);
		}
	}

}
