package pencilbox.tentaisho;

import java.awt.Color;
import java.awt.Graphics2D;

import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.gui.PanelBase;


/**
 * uṼV[vplNX
 */
public class Panel extends PanelBase {

	private Board board;

	private boolean hideStarMode = false;
	private boolean showAreaBorderMode = true;
	private boolean indicateErrorMode = false;
	private boolean separateAreaColorMode = false;

	private Color areaBorderColor = new Color(0x000099);
	private Color noStarAreaColor = new Color(0xFFFF99);
	private Color whiteAreaColor = new Color(0xAAFFFF);
	private Color blackAreaColor = new Color(0xFFAAFF);
	private Color draggingAreaColor = new Color(0xCCFFFF);
	private Color starColor = Color.BLACK;

	private int halfStarSize = 3;

	private Area draggingArea;

	/**
	 * 
	 */
	public Panel() {
		setGridColor(Color.GRAY);
	}

	protected void setBoard(BoardBase aBoard) {
		board = (Board) aBoard; 
	}

	/**
	 * @return the draggingArea
	 */
	Area getDraggingArea() {
		return draggingArea;
	}
	/**
	 * @param draggingArea The draggingArea to set.
	 */
	void setDraggingArea(Area draggingArea) {
		this.draggingArea = draggingArea;
	}

	/**
	 * @return the halfStarSize
	 */
	public int getHalfStarSize() {
		return halfStarSize;
	}

	/**
	 * @param halfStarSize the halfStarSize to set
	 */
	public void setHalfStarSize(int halfStarSize) {
		this.halfStarSize = halfStarSize;
	}

	/**
	 * @return Returns the areaBorderColor.
	 */
	public Color getAreaBorderColor() {
		return areaBorderColor;
	}

	/**
	 * @param areaBorderColor The areaBorderColor to set.
	 */
	public void setAreaBorderColor(Color areaBorderColor) {
		this.areaBorderColor = areaBorderColor;
	}

	/**
	 * @return Returns the blackAreaColor.
	 */
	public Color getBlackAreaColor() {
		return blackAreaColor;
	}

	/**
	 * @param blackAreaColor The blackAreaColor to set.
	 */
	public void setBlackAreaColor(Color blackAreaColor) {
		this.blackAreaColor = blackAreaColor;
	}

	/**
	 * @return Returns the whiteAreaColor.
	 */
	public Color getWhiteAreaColor() {
		return whiteAreaColor;
	}

	/**
	 * @param whiteAreaColor The whiteAreaColor to set.
	 */
	public void setWhiteAreaColor(Color whiteAreaColor) {
		this.whiteAreaColor = whiteAreaColor;
	}

	/**
	 * @return the showAreaBorderMode
	 */
	public boolean isShowAreaBorderMode() {
		return showAreaBorderMode;
	}

	/**
	 * @param showAreaBorderMode The showAreaBorderMode to set.
	 */
	public void setShowAreaBorderMode(boolean showAreaBorderMode) {
		this.showAreaBorderMode = showAreaBorderMode;
	}

	/**
	 * @return the hideStarMode
	 */
	public boolean isHideStarMode() {
		return hideStarMode;
	}

	/**
	 * @param hideStarMode The hideStarMode to set.
	 */
	public void setHideStarMode(boolean hideStarMode) {
		this.hideStarMode = hideStarMode;
	}

	/**
	 * @return the indicateErrorMode
	 */
	public boolean isIndicateErrorMode() {
		return indicateErrorMode;
	}

	/**
	 * @param indicateErrorMode the indicateErrorMode to set.
	 */
	public void setIndicateErrorMode(boolean indicateErrorMode) {
		this.indicateErrorMode = indicateErrorMode;
	}

	/**
	 * @return Returns the separateAreaColorMode.
	 */
	public boolean isSeparateAreaColorMode() {
		return separateAreaColorMode;
	}

	/**
	 * @param separateAreaColorMode The separateAreaColorMode to set.
	 */
	public void setSeparateAreaColorMode(boolean separateAreaColorMode) {
		this.separateAreaColorMode = separateAreaColorMode;
	}

	public void setDisplaySize(int cellSize) {
		halfStarSize = (int) (cellSize * 0.15);
		super.setDisplaySize(cellSize);
	}
	
	public void drawBoard(Graphics2D g) {
		paintAreas(g);
		drawGrid(g);
		if (!isHideStarMode()) {
			drawStars(g);
		}
		if (isShowAreaBorderMode()) {
			drawAreaBorders(g);
		}
		drawBoardBorder(g);
	}

	private void paintAreas(Graphics2D g) {
		for (int r = 0; r < board.rows(); r++) {
			for (int c = 0; c < board.cols(); c++) {
				if (board.isCovered(r, c)) {
					if (board.getArea(r,c) == draggingArea) {
						g.setColor(draggingAreaColor);
					} else {
						int starType = board.getArea(r, c).getStarType();
						g.setColor(whiteAreaColor);
						if (isSeparateAreaColorMode()) {
							if (starType == -1) {
								g.setColor(getErrorColor());
							} else if (starType == Board.WHITESTAR) {
								g.setColor(whiteAreaColor);
							} else if (starType == Board.BLACKSTAR) {
								g.setColor(blackAreaColor);
							} else {
								g.setColor(noStarAreaColor);
							} 
						}
						if (isIndicateErrorMode()) {
							if (starType == -1) {
								g.setColor(getErrorColor());
							} else if (starType == 0) {
								g.setColor(noStarAreaColor);
							} else if (!board.getArea(r, c).isPointSymmetry()) {
								g.setColor(getErrorColor());
							}
						}
					}
					paintCell(g, r, c);
				}
			}
		}
	}
	
	private void drawStars(Graphics2D g) {
		for (int r = 0; r < board.rows() * 2 - 1; r++) {
			for (int c = 0; c < board.cols() * 2 - 1; c++) {
				if (board.hasStar(r, c))
					placeStar(g, r, c, board.getStar(r, c));
			}
		}
	}

	private void drawAreaBorders(Graphics2D g) {
		g.setColor(areaBorderColor);
		for (int r = 0; r < board.rows(); r++) {
			for (int c = 0; c < board.cols() - 1; c++) {
				if (board.getArea(r, c) != board.getArea(r, c + 1)) {
					placeSideLine(g, Direction.VERT, r, c);
				}
			}
		}
		for (int r = 0; r < board.rows() - 1; r++) {
			for (int c = 0; c < board.cols(); c++) {
				if (board.getArea(r, c) != board.getArea(r + 1, c)) {
					placeSideLine(g, Direction.HORIZ, r, c);
				}
			}
		}
	}

	/**
	 * zu
	 * @param g
	 * @param r
	 * @param c
	 * @param star
	 */
	public void placeStar(Graphics2D g, int r, int c, int star) {
		if (star == Board.WHITESTAR) {
			if (isSeparateAreaColorMode()) {
				g.setColor(getWhiteAreaColor());
			} else {
				g.setColor(getBackgroundColor());
			}
		} else if (star == Board.BLACKSTAR) {
			if (isSeparateAreaColorMode()) {
				g.setColor(getBlackAreaColor());
			} else {
				g.setColor(starColor);
			}
		}
		fillCircle(g, getOffsetx() + getCellSize()*(c+1)/2, getOffsety() + getCellSize()*(r+1)/2, getHalfStarSize());
		g.setColor(starColor);
		drawCircle(g, getOffsetx() + getCellSize()*(c+1)/2, getOffsety() + getCellSize()*(r+1)/2, getHalfStarSize());
	}
	/**
	 * ṼV[pJ[\`
	 * @param g
	 */
	public void drawCursor(Graphics2D g) {
		if (isProblemEditMode()) {
			g.setColor(getCursorColor());
			g.drawRect(
				getOffsetx() + (getCellSize() * getCellCursor().c() + getHalfCellSize()) / 2,
				getOffsety() + (getCellSize() * getCellCursor().r() + getHalfCellSize()) / 2,
				getHalfCellSize(),
				getHalfCellSize());
		}
	}

}
