package pencilbox.common.gui;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import javax.swing.JOptionPane;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.SideAddress;

/**
 * plɑ΂}EXCL[{[h̃CxgsNX
 */
public class PanelEventHandlerBase implements KeyListener, MouseListener, MouseMotionListener {

	private PanelBase panel;
	private BoardBase board;

	private int maxInputNumber = 99;
	private int previousInput = 0;
	private int symmetricPlacementMode = 0;
	private int immediateAnswerCheckMode = -1; // -1:OFF, 0:ON, 1:ALREADY_CHECKED

	private Address oldPos = new Address(-1, -1);
	private Address newPos = new Address(-1, -1);
	private SideAddress sidePos = new SideAddress();

	/**
	 * PanelEventHandler𐶐
	 */
	public PanelEventHandlerBase() {
	}

	public void setup(PanelBase panel, BoardBase board) {
		this.panel = panel;
		this.board = board;
		setBoard(board);
		resetPreviousInput();
		resetImmediateAnswerCheckMode();
	}

	/**
	 * ʃNX̃plɌʃNX̔Ֆʂݒ肷邽߂̃\bh
	 * eʃNXŃI[o[Ch
	 * @param board Ֆ
	 */
	protected void setBoard(BoardBase board) {
	}

	public PanelBase getPanel() {
		return panel;
	}

	/**
	 * @return the symmetricPlacementMode
	 */
	public boolean isSymmetricPlacementMode() {
		return symmetricPlacementMode == 1 ? true : false;
	}
	/**
	 * @param b the symmetricPlacementMode to set
	 */
	public void setSymmetricPlacementMode(boolean b) {
		this.symmetricPlacementMode = b ? 1 : 0;
	}

	/**
	 * @return the immediateAnswerCheckMode
	 */
	public boolean isImmediateAnswerCheckMode() {
		return this.immediateAnswerCheckMode >= 0 ? true : false;
	}
	/**
	 * @param b the immediateAnswerCheckMode to set
	 */
	public void setImmediateAnswerCheckMode(boolean b) {
		this.immediateAnswerCheckMode = b ? 0 : -1;
	}
	/**
	 * 𔻒胂[h̏ꍇɁCςݏԂ疢Ԃɖ߂B
	 */
	public void resetImmediateAnswerCheckMode() {
		if (immediateAnswerCheckMode == 1)
			immediateAnswerCheckMode = 0;
	}
	/**
	 * ͉\ȍő吔擾B
	 */
	protected int getMaxInputNumber() {
		return maxInputNumber;
	}
	/**
	 * ͉\ȍő吔ݒ肷
	 * @param number ݒ肷鐔l
	 */
	protected void setMaxInputNumber(int number) {
		maxInputNumber = number;
	}
	/**
	 * ͐̈ꎞLNA
	 */
	public void resetPreviousInput() {
		previousInput = 0;
	}

	public boolean isProblemEditMode() {
		return panel.getEditMode() == PanelBase.PROBLEM_INPUT_MODE;
	}

	public CellCursor getCellCursor() {
		return panel.getCellCursor();
	}

	public boolean isCursorOn() {
		return panel.isCursorMode();
	}

	public void repaint() {
		panel.repaint();
	}

	public boolean isOn(Address position) {
		return board.isOn(position);
	}

	public boolean isSideOn(SideAddress position) {
		return board.isSideOn(position);
	}

	/**
	 * J[\WՖʏɂ邩B
	 * ʏ #isOn(Address) ƓʂԂB
	 * SL, TS J[\̍WnقȂ^Cvł́CTuNXōĒ`B
	 * @param position J[\W
	 * @return J[\WՖʏɂ true
	 */
	public boolean isCursorOnBoard(Address position) {
		return board.isOn(position);
	}

	/**
	 * _Ώ̈ʒu̍W擾B
	 * @param pos@W
	 * @return posƓ_Ώ̂Ȉʒu̍W
	 */
	public Address getSymmetricPosition(Address pos) {
		return new Address(board.rows()-1-pos.r(), board.cols()-1-pos.c());
	}

	/*
	 * L[Xi[
	 */
	public void keyPressed(KeyEvent e) {
		int keyCode = e.getKeyCode();
		switch (keyCode) {
		case KeyEvent.VK_SLASH:
		case KeyEvent.VK_DIVIDE:
			slashKeyEntered();
			break;
		case KeyEvent.VK_LEFT: // 0x25
			arrowKeyEntered(Direction.LT);
			break;
		case KeyEvent.VK_UP: // 0x26
			arrowKeyEntered(Direction.UP);
			break;
		case KeyEvent.VK_RIGHT: // 0x27
			arrowKeyEntered(Direction.RT);
			break;
		case KeyEvent.VK_DOWN: // 0x28
			arrowKeyEntered(Direction.DN);
			break;
		case KeyEvent.VK_SPACE:
		case KeyEvent.VK_PERIOD:
		case KeyEvent.VK_DECIMAL:
			spaceKeyEntered();
			break;
		case KeyEvent.VK_MINUS:
		case KeyEvent.VK_SUBTRACT:
			minusKeyEntered();
			break;
		case KeyEvent.VK_SEMICOLON:
		case KeyEvent.VK_ADD:
			plusKeyEntered();
			break;
		case KeyEvent.VK_COLON:
		case KeyEvent.VK_MULTIPLY:
			starKeyEntered();
			break;
		case KeyEvent.VK_0:
		case KeyEvent.VK_NUMPAD0:
			numberKeyEntered(0);
			break;
		case KeyEvent.VK_1:
		case KeyEvent.VK_NUMPAD1:
			numberKeyEntered(1);
			break;
		case KeyEvent.VK_2:
		case KeyEvent.VK_NUMPAD2:
			numberKeyEntered(2);
			break;
		case KeyEvent.VK_3:
		case KeyEvent.VK_NUMPAD3:
			numberKeyEntered(3);
			break;
		case KeyEvent.VK_4:
		case KeyEvent.VK_NUMPAD4:
			numberKeyEntered(4);
			break;
		case KeyEvent.VK_5:
		case KeyEvent.VK_NUMPAD5:
			numberKeyEntered(5);
			break;
		case KeyEvent.VK_6:
		case KeyEvent.VK_NUMPAD6:
			numberKeyEntered(6);
			break;
		case KeyEvent.VK_7:
		case KeyEvent.VK_NUMPAD7:
			numberKeyEntered(7);
			break;
		case KeyEvent.VK_8:
		case KeyEvent.VK_NUMPAD8:
			numberKeyEntered(8);
			break;
		case KeyEvent.VK_9:
		case KeyEvent.VK_NUMPAD9:
			numberKeyEntered(9);
			break;
		}
		repaint();
	}

	public void keyTyped(KeyEvent e) {
	}

	public void keyReleased(KeyEvent e) {
		checkAnswer();
	}

	/**
	 * L[͂B ̕ɃJ[\ړB
	 */
	protected void arrowKeyEntered(int direction) {
		if (!isProblemEditMode() && !isCursorOn())
			return;
		Address pos = getCellCursor().getPosition();
		pos.move(direction);
		if (isCursorOnBoard(pos)) {
			getCellCursor().setPosition(pos);
			resetPreviousInput();
		}
	}
	/**
	 * L[͂B 
	 * 0-9 ̐L[͂ꂽƂɁC󋵂ɉ2̐ɂ numberEntered\bhɓn
	 */
	protected void numberKeyEntered(int number) {
		int maxInput = getMaxInputNumber();
		if (previousInput * 10 + number <= maxInput) {
			number = previousInput * 10 + number;
		}
		if (number <= maxInput) {
			Address pos = getCellCursor().getPosition();
			numberEntered(pos, number);
			previousInput = number;
		}
	}
	/**
	 * ͂B
	 * eTuNXŎB
	 * @param pos ͂}X̍W
	 * @param num ͂
	 */
	protected void numberEntered(Address pos, int num) {
	}
	/**
	 * sIhL[̓͂B
	 * eTuNXŎB
	 * @param pos ̓}X̍W
	 */
	protected void spaceEntered(Address pos) {
	}

	protected void spaceKeyEntered() {
		Address pos = getCellCursor().getPosition();
		spaceEntered(pos);
		resetPreviousInput();
	}

	/**
	 * }CiXL[̓͂B
	 * eTuNXŎB
	 * @param pos ̓}X̍W
	 */
	protected void minusEntered(Address pos) {
	}

	protected void minusKeyEntered() {
		Address pos = getCellCursor().getPosition();
		minusEntered(pos);
	}

	/**
	 * vXL[̓͂B
	 * eTuNXŎB
	 * @param pos ̓}X̍W
	 */
	protected void plusEntered(Address pos) {
	}

	protected void plusKeyEntered() {
		Address pos = getCellCursor().getPosition();
		plusEntered(pos);
	}

	/**
	 * AX^XNL[̓͂B
	 * eTuNXŎB
	 * @param pos ̓}X̍W
	 */
	protected void starEntered(Address pos) {
	}

	protected void starKeyEntered() {
		Address pos = getCellCursor().getPosition();
		starEntered(pos);
	}

	/**
	 * XbVL[̓͂B
	 * u̓[hvƁu𓚃[hv؂ւ
	 */
	protected void slashKeyEntered() {
		if (isProblemEditMode()) {
			board.initBoard();
			panel.setEditMode(PanelBase.ANSWER_INPUT_MODE);
		} else {
			panel.setEditMode(PanelBase.PROBLEM_INPUT_MODE);
		}
		resetPreviousInput();
		resetImmediateAnswerCheckMode();
	}

	/**
	 * }EXCxg牟ꂽ{^̔ԍ擾⏕\bh
	 * VtgL[ōẼ{^ւ
	 * @param e
	 * @return {^Ȃ 1 E{^Ȃ 3 {^Ȃ 2 ȊO -1
	 */
	public int getMouseButton(MouseEvent e) {
		int modifier = e.getModifiers();
		if ((modifier & InputEvent.BUTTON1_MASK) == InputEvent.BUTTON1_MASK) {
			if (e.isShiftDown())
				return 3;
			else
				return 1;
		} else if ((modifier & InputEvent.BUTTON3_MASK) == InputEvent.BUTTON3_MASK) {
			if (e.isShiftDown())
				return 1;
			else
				return 3;
		} else if ((modifier & InputEvent.BUTTON2_MASK) == InputEvent.BUTTON2_MASK) {
			return 2;
		} else {
			return -1;
		}
	}
	/*
	 * }EXXi[
	 */
	public void mousePressed(MouseEvent e) {
		mousePressed2(e); // ӂ̑
		newPos.set(panel.pointToAddress(e.getX(), e.getY()));
		if (!isOn(newPos))
			return;
		int button = getMouseButton(e);
		if (button == 1) {
			leftPressed(newPos);
		} else if (button == 3) {
			rightPressed(newPos);
		}
		moveCursor(newPos);
		oldPos.set(newPos); // ݈ʒuXV
		repaint();
	}

	/*
	 * ӂ̑pB SL, MS Ŏgp
	 */
	private void mousePressed2(MouseEvent e) {
		sidePos.set(panel.pointToSideAddress(e.getX(), e.getY()));
		if (!isSideOn(sidePos))
			return;
		int button = getMouseButton(e);
		if (button == 1) {
			leftPressedEdge(sidePos);
		} else if (button == 3) {
			rightPressedEdge(sidePos);
		}
	}

	public void mouseDragged(MouseEvent e) {
		newPos.set(panel.pointToAddress(e.getX(), e.getY()));
		if (!isOn(newPos)) {
			oldPos.setNowhere();
			return;
		}
		if (newPos.equals(oldPos))
			return; // }XɎ~܂Cxg͖
		// if (!newPos.isNextTo(oldPos)) return; // אڃ}XȊÕCxg͖
		// if (dragIneffective(oldPos, newPos)) return; // אڃ}XȊÕCxg͖
		int button = getMouseButton(e);
		if (button == 1) {
			leftDragged(oldPos, newPos);
		} else if (button == 3) {
			rightDragged(oldPos, newPos);
		}
		moveCursor(newPos);
		oldPos.set(newPos); // ݈ʒuXV
		repaint();
	}

	public void mouseReleased(MouseEvent e) {
		int button = getMouseButton(e);
		if (button == 1) {
			leftReleased(oldPos);
		} else if (button == 3) {
			rightReleased(oldPos);
		}
		repaint();
		checkAnswer();
	}

	public void mouseExited(MouseEvent e) {
	}

	public void mouseEntered(MouseEvent e) {
	}

	public void mouseClicked(MouseEvent e) {
		mouseClicked1(e);
//		mouseClicked2(e);
		repaint();
		checkAnswer();
	}

	public void mouseClicked1(MouseEvent e) {
		if (!isOn(newPos))
			return;
		int button = getMouseButton(e);
		if (button == 1) {
			leftClicked(newPos);
		} else if (button == 3) {
			rightClicked(newPos);
//		} else if (button == 2) {
//			slashKeyEntered();
		}
	}
	/**
	 * ӂ̈ʒũNbNB
	 * @param e
	 */
//	public void mouseClicked2(MouseEvent e) {
//		sidePos.set(panel.pointToSideAddress(e.getX(), e.getY()));
//		if (!isSideOn(sidePos))
//			return;
//		int modifier = e.getModifiers();
//		if ((modifier & InputEvent.BUTTON1_MASK) != 0) {
//			if (e.isShiftDown())
//				rightClickedEdge(sidePos);
//			else
//				leftClickedEdge(sidePos);
//		} else if ((modifier & InputEvent.BUTTON3_MASK) != 0) {
//			if (e.isShiftDown())
//				leftClickedEdge(sidePos);
//			else
//				rightClickedEdge(sidePos);
//		}
//	}

	public void mouseMoved(MouseEvent e) {
		// movePos.set(panel.pointToAddress(e));
		// if (!isOn(movePos))
		// return;
		// mouseMovedTo(movePos);
		// repaint();
	}

	/**
	 * {^ꂽƂɌĂ΂B
	 * TuNXőI[o[ChD
	 * @param position
	 */
	protected void leftPressed(Address position) {
	}

	protected void leftClicked(Address position) {
	}

	/**
	 * hbO܂܂V}XɈړƂɌĂ΂D
	 * KvɉăTuNXőI[o[ChD
	 * @param position
	 */
	protected void leftDragged(Address position) {
		// leftPressed(position);
	}

	protected void leftDragged(Address oldPos, Address position) {
		leftDragged(position);
	}

	/**
	 * }EX{^𗣂ƂɌĂ΂B
	 * TuNXŃI[o[ChB
	 * @param position
	 */
	protected void leftReleased(Address position) {
	}
	/**
	 * E{^ꂽƂCEhbO܂܂V}XɈړƂɌĂ΂B
	 * TuNXőI[o[ChB
	 * @param position
	 */
	protected void rightPressed(Address position) {
	}

	protected void rightClicked(Address position) {
	}
	/**
	 * EhbO܂܂V}XɈړƂɌĂ΂B 
	 * TuNXőI[o[ChD
	 * @param position
	 */
	protected void rightDragged(Address position) {
		// rightPressed(position);
	}

	protected void rightDragged(Address oldPos, Address position) {
		rightDragged(position);
	}
	/**
	 * E}EX{^𗣂ƂɌĂ΂B
	 * TuNXŃI[o[ChB
	 * @param position
	 */
	protected void rightReleased(Address position) {
	}

	/**
	 * }EXŃJ[\ړB
	 * @param position
	 */
	protected void moveCursor(Address position) {
		getCellCursor().setPosition(position);
		resetPreviousInput();
	}
//
//	/**
//	 * ӂ̈ʒuNbNƂ̓߂B
//	 * @param position
//	 */
//	protected void leftClickedEdge(SideAddress position) {
//	}
//
//	/**
//	 * ӂ̈ʒuENbNƂ̓߂B
//	 * @param position
//	 */
//	protected void rightClickedEdge(SideAddress position) {
//	}

	/**
	 * ӂ̈ʒuNbNƂ̓߂B
	 * @param position
	 */
	protected void leftPressedEdge(SideAddress position) {
	}

	/**
	 * ӂ̈ʒuENbNƂ̓߂B
	 * @param position
	 */
	protected void rightPressedEdge(SideAddress position) {
	}

	/**
	 * 	𔻒
	 */
	public void checkAnswer() {
		if (isProblemEditMode())
			return;
		if (immediateAnswerCheckMode == 0) {
			if (board.checkAnswerCode() == 0) {
				JOptionPane.showMessageDialog(panel, BoardBase.COMPLETE_MESSAGE,
						Messages.getString("PanelEventHandlerBase.checkAnswerDialog"), JOptionPane.INFORMATION_MESSAGE); //$NON-NLS-1$
				immediateAnswerCheckMode = 1;
			}
		}
	}

}
