/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slalom;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.slalom.Board;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private boolean indicateErrorMode = false;
    private boolean separateLinkColorMode = false;
    private Color gateColor = new Color(0x808080);
    private Color circleColor = Color.BLACK;
    private Color lineColor = new Color(153);
    private Color crossColor = new Color(0xFF0099);
    private Color wallColor = Color.BLACK;
    private int gateLineWidth = 3;

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setNumberColor(Color.WHITE);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public boolean isSeparateLinkColorMode() {
        return this.separateLinkColorMode;
    }

    public void setSeparateLinkColorMode(boolean separateLinkColorMode) {
        this.separateLinkColorMode = separateLinkColorMode;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public Color getCrossColor() {
        return this.crossColor;
    }

    public void setCrossColor(Color crossColor) {
        this.crossColor = crossColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getGateColor() {
        return this.gateColor;
    }

    public void setGateColor(Color gateColor) {
        this.gateColor = gateColor;
    }

    public void setWallColor(Color wallColor) {
        this.wallColor = wallColor;
    }

    public Color getWallColor() {
        return this.wallColor;
    }

    public void drawBoard(Graphics2D g) {
        this.drawGrid(g);
        this.drawGates(g);
        this.drawLinks(g);
        this.drawNumbers(g);
        this.drawBoardBorder(g);
    }

    private void drawGates(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int state = this.board.getNumber(r, c);
                if (state >= 0) {
                    this.placeNumber(g, r, c, this.board.getNGate());
                } else if (state == -4) {
                    g.setColor(this.getGateColor());
                    this.placeGateLine(g, r, c, 1);
                } else if (state == -5) {
                    g.setColor(this.getGateColor());
                    this.placeGateLine(g, r, c, 0);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int state = this.board.getNumber(r, c);
                if (state >= 0) {
                    g.setColor(this.getWallColor());
                    this.paintCell(g, r, c);
                    if (state > 0) {
                        g.setColor(this.getNumberColor());
                        this.placeNumber(g, r, c, state);
                    }
                } else if (state == -1) {
                    g.setColor(this.getBackgroundColor());
                    this.placeFilledCircle(g, r, c, this.getCellSize() - 2);
                    g.setColor(this.getCircleColor());
                    this.placeCircle(g, r, c, this.getCellSize() - 2);
                    this.placeNumber(g, r, c, this.board.getNGate());
                }
                ++c;
            }
            ++r;
        }
    }

    private void placeGateLine(Graphics2D g, int r, int c, int dir) {
        if (dir == 1) {
            this.drawLineSegment(g, this.toX(c), this.toY(r) + this.getHalfCellSize(), dir, this.gateLineWidth);
        } else if (dir == 0) {
            this.drawLineSegment(g, this.toX(c) + this.getHalfCellSize(), this.toY(r), dir, this.gateLineWidth);
        }
    }

    private void drawLinks(Graphics2D g) {
        int d = 0;
        while (d <= 1) {
            int r = 0;
            while (r < this.board.rows()) {
                int c = 0;
                while (c < this.board.cols()) {
                    int state = this.board.getState(d, r, c);
                    if (state == 1) {
                        g.setColor(this.getLineColor());
                        if (this.isSeparateLinkColorMode()) {
                            g.setColor(Colors.getColor(this.board.getLink(d, r, c).getId()));
                        }
                        this.placeLink(g, d, r, c);
                    } else if (state == -1) {
                        g.setColor(this.getCrossColor());
                        this.placeSideCross(g, d, r, c);
                    }
                    ++c;
                }
                ++r;
            }
            ++d;
        }
    }
}

