/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.lits;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.lits.Area;
import pencilbox.lits.Board;

public class Panel
extends PanelBase {
    private Board board;
    private Color paintColor = new Color(39423);
    private Color circleColor = new Color(0xFF9999);
    private Color areaBorderColor = Color.BLACK;
    private Color noAreaColor = new Color(0xC0C0C0);
    private Color tetrominoLColor = new Color(0xCCCC00);
    private Color tetrominoIColor = new Color(0xCC00CC);
    private Color tetrominoTColor = new Color(52428);
    private Color tetrominoSColor = new Color(52224);
    private Color draggingAreaColor = new Color(0xCCFFFF);
    private boolean separateTetrominoColorMode = false;
    private Area draggingArea;

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setMarkStyle(3);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    Area getDraggingArea() {
        return this.draggingArea;
    }

    void setDraggingArea(Area draggingArea) {
        this.draggingArea = draggingArea;
    }

    public void setPaintColor(Color paintColor) {
        this.paintColor = paintColor;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public boolean isSeparateTetrominoColorMode() {
        return this.separateTetrominoColorMode;
    }

    public void setSeparateTetrominoColorMode(boolean separateTetrominoColorMode) {
        this.separateTetrominoColorMode = separateTetrominoColorMode;
    }

    public void drawBoard(Graphics2D g) {
        this.paintAreas(g);
        this.drawCells(g);
        this.drawGrid(g);
        this.drawAreaBorders(g);
        this.drawBoardBorder(g);
    }

    private void paintAreas(Graphics2D g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                if (this.board.getArea(r, c) == null) {
                    g.setColor(this.noAreaColor);
                    this.paintCell(g, r, c);
                } else if (this.board.getArea(r, c) == this.draggingArea) {
                    g.setColor(this.draggingAreaColor);
                    this.paintCell(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    protected void drawCells(Graphics2D g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int st = this.board.getState(r, c);
                if (st == -2) {
                    g.setColor(this.getPaintColor());
                    if (this.isSeparateTetrominoColorMode() && this.board.getArea(r, c) != null) {
                        int t = this.board.getArea(r, c).getTetrominoType();
                        g.setColor(this.getTetrominoColor(t));
                    }
                    this.paintCell(g, r, c);
                } else if (st == -1) {
                    g.setColor(this.getCircleColor());
                    this.placeMark(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private Color getTetrominoColor(int type) {
        switch (type) {
            case 1: {
                return this.tetrominoLColor;
            }
            case 2: {
                return this.tetrominoIColor;
            }
            case 3: {
                return this.tetrominoTColor;
            }
            case 4: {
                return this.tetrominoSColor;
            }
            case 5: {
                return this.getErrorColor();
            }
        }
        return this.getPaintColor();
    }

    private void drawAreaBorders(Graphics2D g) {
        g.setColor(this.getAreaBorderColor());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols() - 1) {
                if (this.board.getArea(r, c) != this.board.getArea(r, c + 1)) {
                    this.placeSideLine(g, 0, r, c);
                }
                ++c;
            }
            if (this.board.getArea(r, 0) != null) {
                this.placeSideLine(g, 0, r, -1);
            }
            if (this.board.getArea(r, this.board.cols() - 1) != null) {
                this.placeSideLine(g, 0, r, this.board.cols() - 1);
            }
            ++r;
        }
        int c = 0;
        while (c < this.board.cols()) {
            int r2 = 0;
            while (r2 < this.board.rows() - 1) {
                if (this.board.getArea(r2, c) != this.board.getArea(r2 + 1, c)) {
                    this.placeSideLine(g, 1, r2, c);
                }
                ++r2;
            }
            if (this.board.getArea(0, c) != null) {
                this.placeSideLine(g, 1, -1, c);
            }
            if (this.board.getArea(this.board.rows() - 1, c) != null) {
                this.placeSideLine(g, 1, this.board.rows() - 1, c);
            }
            ++c;
        }
    }
}

