/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.bijutsukan;

import pencilbox.bijutsukan.Board;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = -1;

    public PanelEventHandler() {
        this.setMaxInputNumber(5);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftPressed(Address pos) {
        this.toggleState(pos, -2);
    }

    protected void rightPressed(Address pos) {
        this.toggleState(pos, -3);
        this.currentState = this.board.isWall(pos) ? -1 : this.board.getState(pos);
    }

    protected void leftDragged(Address pos) {
    }

    protected void rightDragged(Address pos) {
        this.sweepState(pos);
    }

    private void toggleState(Address pos, int st) {
        if (this.board.isWall(pos)) {
            return;
        }
        if (st == this.board.getState(pos)) {
            st = -1;
        }
        this.board.changeStateA(pos, st);
    }

    private void sweepState(Address pos) {
        if (this.board.isWall(pos)) {
            return;
        }
        if (this.currentState == this.board.getState(pos)) {
            return;
        }
        this.board.changeStateA(pos, this.currentState);
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos, num);
            if (this.isSymmetricPlacementMode() && !this.board.isWall(posS = this.getSymmetricPosition(pos))) {
                this.board.changeState(posS, 5);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos, -1);
            if (this.isSymmetricPlacementMode() && this.board.isWall(posS = this.getSymmetricPosition(pos))) {
                this.board.changeState(posS, -1);
            }
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos, 5);
            if (this.isSymmetricPlacementMode() && !this.board.isWall(posS = this.getSymmetricPosition(pos))) {
                this.board.changeState(posS, 5);
            }
        }
    }
}

