/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.tentaisho;

import pencilbox.common.core.Address;
import pencilbox.common.io.PzprWriterBase;
import pencilbox.tentaisho.Board;

public class PzprWriter
extends PzprWriterBase {
    private Board bd;

    protected String getPzprName() {
        return "tentaisho";
    }

    protected void pzlexport() {
        this.bd = (Board)this.boardBase;
        this.outSize(this.bd.rows(), this.bd.cols());
        this.encodeStar();
    }

    private void encodeStar() {
        int count = 0;
        String cm = "";
        int s = 0;
        while (s < (2 * this.cols - 1) * (2 * this.rows - 1)) {
            String pstr = "";
            if (this.getStar(s) > 0) {
                int i = 0;
                while (i <= 6) {
                    if (this.getStar(s + i + 1) > 0) {
                        pstr = PzprWriter.toString(2 * i + (this.getStar(s) - 1), 16);
                        s += i;
                        break;
                    }
                    ++i;
                }
                if (pstr == "") {
                    pstr = PzprWriter.toString(13 + this.getStar(s), 16);
                    s += 7;
                }
            } else {
                pstr = " ";
                ++count;
            }
            if (count == 0) {
                cm = String.valueOf(cm) + pstr;
            } else if (pstr != " ") {
                cm = String.valueOf(cm) + PzprWriter.toString(count + 15, 36) + pstr;
                count = 0;
            } else if (count == 20) {
                cm = String.valueOf(cm) + "z";
                count = 0;
            }
            ++s;
        }
        if (count > 0) {
            cm = String.valueOf(cm) + PzprWriter.toString(count + 15, 36);
        }
        this.outbstr(cm);
    }

    protected int getStar(int id) {
        if (id < 0 || (2 * this.cols - 1) * (2 * this.rows - 1) <= id) {
            return -1;
        }
        return this.bd.getStar(Address.address(id / (this.cols * 2 - 1), id % (this.cols * 2 - 1)));
    }
}

