/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.masyu;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BorderEditStep;
import pencilbox.common.core.SideAddress;
import pencilbox.masyu.Link;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int HORIZ = 1;
    static final int VERT = 0;
    static final int UP = 0;
    static final int DN = 2;
    static final int LT = 1;
    static final int RT = 3;
    static final int UNKNOWN = 0;
    static final int LINE = 1;
    static final int NOLINE = -1;
    static final int OUTER = -9;
    static final int NO_PEARL = 0;
    static final int WHITE_PEARL = 1;
    static final int BLACK_PEARL = 2;
    static final int GRAY_PEARL = 3;
    private int[][] number;
    private int[][][] state;
    private List<Link> linkList;
    private Link[][][] link;
    private Link initializingLink;

    protected void setup() {
        super.setup();
        this.number = new int[this.rows()][this.cols()];
        this.state = new int[2][][];
        this.state[0] = new int[this.rows()][this.cols() - 1];
        this.state[1] = new int[this.rows() - 1][this.cols()];
        this.linkList = new LinkedList<Link>();
        this.link = new Link[2][][];
        this.link[0] = new Link[this.rows()][this.cols() - 1];
        this.link[1] = new Link[this.rows() - 1][this.cols()];
    }

    public void clearBoard() {
        super.clearBoard();
        ArrayUtil.initArrayInt3(this.state, 0);
        this.initBoard();
    }

    public void trimAnswer() {
        int d = 0;
        while (d <= 1) {
            int r = 0;
            while (r < this.rows()) {
                int c = 0;
                while (c < this.cols()) {
                    if (this.getState(d, r, c) == -1) {
                        this.setState(d, r, c, 0);
                    }
                    ++c;
                }
                ++r;
            }
            ++d;
        }
    }

    int[][][] getState() {
        return this.state;
    }

    int[][] getNumber() {
        return this.number;
    }

    public void setNumber(int r, int c, int st) {
        this.number[r][c] = st;
    }

    public void setNumber(Address pos, int st) {
        this.setNumber(pos.r(), pos.c(), st);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public boolean isNumber(int r, int c) {
        return this.number[r][c] >= 1 && this.number[r][c] <= 3;
    }

    public boolean isNumber(Address pos) {
        return this.isNumber(pos.r(), pos.c());
    }

    public int getState(int d, int r, int c) {
        if (this.isSideOn(d, r, c)) {
            return this.state[d][r][c];
        }
        return -9;
    }

    public int getState(SideAddress pos) {
        return this.getState(pos.d(), pos.r(), pos.c());
    }

    public void setState(int d, int r, int c, int st) {
        this.state[d][r][c] = st;
    }

    public void setState(SideAddress pos, int st) {
        this.setState(pos.d(), pos.r(), pos.c(), st);
    }

    public int getStateJ(Address pos, int d) {
        return this.getState(SideAddress.get(pos, d));
    }

    public void setStateJ(Address pos, int d, int st) {
        this.setState(SideAddress.get(pos, d), st);
    }

    public boolean isLine(int d, int r, int c) {
        if (!this.isSideOn(d, r, c)) {
            return false;
        }
        return this.state[d][r][c] == 1;
    }

    public boolean isNoLine(int d, int r, int c) {
        if (!this.isSideOn(d, r, c)) {
            return true;
        }
        return this.state[d][r][c] == -1;
    }

    public int getStateJ(int r, int c, int direction) {
        switch (direction) {
            case 0: {
                return this.getState(1, r - 1, c);
            }
            case 1: {
                return this.getState(0, r, c - 1);
            }
            case 2: {
                return this.getState(1, r, c);
            }
            case 3: {
                return this.getState(0, r, c);
            }
        }
        return -2;
    }

    public boolean isLineJ(int r, int c, int direction) {
        switch (direction) {
            case 0: {
                return this.isLine(1, r - 1, c);
            }
            case 1: {
                return this.isLine(0, r, c - 1);
            }
            case 2: {
                return this.isLine(1, r, c);
            }
            case 3: {
                return this.isLine(0, r, c);
            }
        }
        return false;
    }

    public boolean isNoLineJ(int r, int c, int direction) {
        switch (direction) {
            case 0: {
                return this.isNoLine(1, r - 1, c);
            }
            case 1: {
                return this.isNoLine(0, r, c - 1);
            }
            case 2: {
                return this.isNoLine(1, r, c);
            }
            case 3: {
                return this.isNoLine(0, r, c);
            }
        }
        return false;
    }

    public Link getLink(int d, int r, int c) {
        if (this.isSideOn(d, r, c)) {
            return this.link[d][r][c];
        }
        return null;
    }

    public Link getLink(SideAddress pos) {
        return this.link[pos.d()][pos.r()][pos.c()];
    }

    public Link getLink(int r, int c) {
        Link link = this.getLink(0, r, c - 1);
        if (link != null) {
            return link;
        }
        link = this.getLink(0, r, c);
        if (link != null) {
            return link;
        }
        link = this.getLink(1, r - 1, c);
        if (link != null) {
            return link;
        }
        link = this.getLink(1, r, c);
        if (link != null) {
            return link;
        }
        return null;
    }

    public void setLink(int d, int r, int c, Link l) {
        this.link[d][r][c] = l;
    }

    public void setLink(SideAddress pos, Link l) {
        this.link[pos.d()][pos.r()][pos.c()] = l;
    }

    public boolean hasMultipleLinks() {
        return this.linkList.size() > 1;
    }

    public void changeState(int d, int r, int c, int st) {
        int previousState = this.getState(d, r, c);
        this.setState(d, r, c, st);
        if (previousState == 1) {
            this.cutLink(d, r, c);
        }
        if (st == 1) {
            this.connectLink(d, r, c);
        }
    }

    public void changeState(SideAddress p, int st) {
        this.changeState(p.d(), p.r(), p.c(), st);
    }

    public void changeStateA(SideAddress pos, int st) {
        this.fireUndoableEditUpdate(new BorderEditStep(pos, this.getState(pos), st));
        this.changeState(pos, st);
    }

    public void undo(AbstractStep step) {
        BorderEditStep s = (BorderEditStep)step;
        this.changeState(s.getPos(), s.getBefore());
    }

    public void redo(AbstractStep step) {
        BorderEditStep s = (BorderEditStep)step;
        this.changeState(s.getPos(), s.getAfter());
    }

    public void initBoard() {
        this.initLinks();
    }

    void initLinks() {
        Link.resetId();
        this.linkList.clear();
        ArrayUtil.initArrayObject2(this.link[0], null);
        ArrayUtil.initArrayObject2(this.link[1], null);
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                this.initLink(r, c);
                ++c;
            }
            ++r;
        }
    }

    void initLink(int r, int c) {
        this.initializingLink = new Link();
        this.initLink1(0, r, c - 1);
        this.initLink1(0, r, c);
        this.initLink1(1, r - 1, c);
        this.initLink1(1, r, c);
        if (!this.initializingLink.isEmpty()) {
            this.linkList.add(this.initializingLink);
        }
    }

    private void initLink1(int d, int r, int c) {
        if (!this.isSideOn(d, r, c)) {
            return;
        }
        if (!this.isLine(d, r, c)) {
            return;
        }
        if (this.getLink(d, r, c) != null) {
            return;
        }
        this.initializingLink.add(d, r, c);
        this.setLink(d, r, c, this.initializingLink);
        if (d == 0) {
            this.initLink1(0, r, c - 1);
            this.initLink1(0, r, c + 1);
            this.initLink1(1, r - 1, c);
            this.initLink1(1, r - 1, c + 1);
            this.initLink1(1, r, c);
            this.initLink1(1, r, c + 1);
        }
        if (d == 1) {
            this.initLink1(1, r - 1, c);
            this.initLink1(1, r + 1, c);
            this.initLink1(0, r, c - 1);
            this.initLink1(0, r + 1, c - 1);
            this.initLink1(0, r, c);
            this.initLink1(0, r + 1, c);
        }
    }

    void connectLink(int d, int r, int c) {
        Link newLink = null;
        Link link1 = null;
        Link link2 = null;
        if (d == 0) {
            link1 = this.getLink(r, c);
            link2 = this.getLink(r, c + 1);
        } else if (d == 1) {
            link1 = this.getLink(r, c);
            link2 = this.getLink(r + 1, c);
        }
        if (link1 == null && link2 == null) {
            newLink = new Link();
            this.linkList.add(newLink);
        } else if (link1 == null && link2 != null) {
            newLink = link2;
        } else if (link1 != null && link2 == null) {
            newLink = link1;
        } else if (link1 == link2) {
            newLink = link1;
        } else if (link1.size() >= link2.size()) {
            newLink = link1;
            newLink.addAll(link2);
            for (SideAddress joint : link2) {
                this.setLink(joint, newLink);
            }
            this.linkList.remove(link2);
        } else {
            newLink = link2;
            newLink.addAll(link1);
            for (SideAddress joint : link1) {
                this.setLink(joint, newLink);
            }
            this.linkList.remove(link1);
        }
        newLink.add(d, r, c);
        this.setLink(d, r, c, newLink);
    }

    void cutLink(int d, int r, int c) {
        Link oldLink = this.getLink(d, r, c);
        Link longerLink = null;
        for (SideAddress joint : oldLink) {
            this.setLink(joint, null);
        }
        this.linkList.remove(oldLink);
        if (d == 0) {
            this.initLink(r, c);
            longerLink = this.initializingLink;
            this.initLink(r, c + 1);
            if (this.initializingLink.size() > longerLink.size()) {
                longerLink = this.initializingLink;
            }
        } else if (d == 1) {
            this.initLink(r, c);
            longerLink = this.initializingLink;
            this.initLink(r + 1, c);
            if (this.initializingLink.size() > longerLink.size()) {
                longerLink = this.initializingLink;
            }
        }
        longerLink.setId(oldLink.getId());
    }

    public int countLine(int r, int c) {
        int no = 0;
        if (this.isLineJ(r, c, 0)) {
            ++no;
        }
        if (this.isLineJ(r, c, 1)) {
            ++no;
        }
        if (this.isLineJ(r, c, 2)) {
            ++no;
        }
        if (this.isLineJ(r, c, 3)) {
            ++no;
        }
        return no;
    }

    int checkWhitePearl(int r, int c) {
        int l = this.countLine(r, c);
        if (l > 2) {
            return -1;
        }
        if (l < 2) {
            return 0;
        }
        if (this.isLineJ(r, c, 0) && this.isLineJ(r, c, 3)) {
            return -1;
        }
        if (this.isLineJ(r, c, 0) && this.isLineJ(r, c, 1)) {
            return -1;
        }
        if (this.isLineJ(r, c, 2) && this.isLineJ(r, c, 3)) {
            return -1;
        }
        if (this.isLineJ(r, c, 2) && this.isLineJ(r, c, 1)) {
            return -1;
        }
        if (this.isLineJ(r, c, 0) && this.isLineJ(r, c, 2)) {
            if (this.isLineJ(r - 1, c, 0) && this.isLineJ(r + 1, c, 2)) {
                return -1;
            }
            if (this.isLineJ(r - 1, c, 3)) {
                return 2;
            }
            if (this.isLineJ(r - 1, c, 1)) {
                return 2;
            }
            if (this.isLineJ(r + 1, c, 3)) {
                return 2;
            }
            if (this.isLineJ(r + 1, c, 1)) {
                return 2;
            }
            return 1;
        }
        if (this.isLineJ(r, c, 1) && this.isLineJ(r, c, 3)) {
            if (this.isLineJ(r, c - 1, 1) && this.isLineJ(r, c + 1, 3)) {
                return -1;
            }
            if (this.isLineJ(r, c - 1, 0)) {
                return 2;
            }
            if (this.isLineJ(r, c - 1, 2)) {
                return 2;
            }
            if (this.isLineJ(r, c + 1, 0)) {
                return 2;
            }
            if (this.isLineJ(r, c + 1, 2)) {
                return 2;
            }
            return 1;
        }
        return -9;
    }

    int checkBlackPearl(int r, int c) {
        int success = 0;
        int l = this.countLine(r, c);
        if (l > 2) {
            return -1;
        }
        if (l < 2) {
            return 0;
        }
        if (this.isLineJ(r, c, 0) && this.isLineJ(r, c, 2)) {
            return -1;
        }
        if (this.isLineJ(r, c, 3) && this.isLineJ(r, c, 1)) {
            return -1;
        }
        if (this.isLineJ(r, c, 0)) {
            if (this.isLineJ(r - 1, c, 1)) {
                return -1;
            }
            if (this.isLineJ(r - 1, c, 3)) {
                return -1;
            }
            success = this.isLineJ(r - 1, c, 0) ? (success |= 2) : (success |= 1);
        }
        if (this.isLineJ(r, c, 2)) {
            if (this.isLineJ(r + 1, c, 1)) {
                return -1;
            }
            if (this.isLineJ(r + 1, c, 3)) {
                return -1;
            }
            success = this.isLineJ(r + 1, c, 2) ? (success |= 2) : (success |= 1);
        }
        if (this.isLineJ(r, c, 1)) {
            if (this.isLineJ(r, c - 1, 0)) {
                return -1;
            }
            if (this.isLineJ(r, c - 1, 2)) {
                return -1;
            }
            success = this.isLineJ(r, c - 1, 1) ? (success |= 8) : (success |= 4);
        }
        if (this.isLineJ(r, c, 3)) {
            if (this.isLineJ(r, c + 1, 0)) {
                return -1;
            }
            if (this.isLineJ(r, c + 1, 2)) {
                return -1;
            }
            success = this.isLineJ(r, c + 1, 3) ? (success |= 8) : (success |= 4);
        }
        if (success == 10) {
            return 2;
        }
        if (success > 0) {
            return 1;
        }
        return -9;
    }

    public int checkAnswerCode() {
        int result = 0;
        int p = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                int l = this.countLine(r, c);
                if (l > 2) {
                    result |= 1;
                } else if (l == 1) {
                    result |= 2;
                }
                int pearl = this.getNumber(r, c);
                if (pearl == 1) {
                    p = this.checkWhitePearl(r, c);
                    if (p == -1) {
                        result |= 4;
                    } else if (p == 0) {
                        result |= 0x20;
                    }
                }
                if (pearl == 2) {
                    p = this.checkBlackPearl(r, c);
                    if (p == -1) {
                        result |= 8;
                    } else if (p == 0) {
                        result |= 0x40;
                    }
                }
                ++c;
            }
            ++r;
        }
        if (this.linkList.size() > 1) {
            result |= 0x10;
        } else if (this.linkList.size() == 0) {
            result |= 0x80;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return BoardBase.COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("masyu.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            message.append(Messages.getString("masyu.AnswerCheckMessage2"));
        }
        if ((result & 0x10) == 16) {
            message.append(Messages.getString("masyu.AnswerCheckMessage5"));
        }
        if ((result & 0x80) == 128) {
            message.append(Messages.getString("masyu.AnswerCheckMessage8"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("masyu.AnswerCheckMessage3"));
        } else if ((result & 0x20) == 32) {
            message.append(Messages.getString("masyu.AnswerCheckMessage6"));
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("masyu.AnswerCheckMessage4"));
        } else if ((result & 0x40) == 64) {
            message.append(Messages.getString("masyu.AnswerCheckMessage7"));
        }
        return message.toString();
    }
}

