/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.goishi;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.goishi.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftPressed(Address pos) {
        if (this.isOn(pos) && this.board.canPick(pos)) {
            this.board.pickUp(pos);
        }
    }

    protected void rightPressed(Address pos) {
        if (this.board.pickedList.size() > 0) {
            this.board.placeBack();
        }
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            if (num == 0) {
                this.board.removeStone(pos);
            } else if (num == 1) {
                this.board.addStone(pos);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.removeStone(pos);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.addStone(pos);
        }
    }
}

