package pencilbox.common.core;

import pencilbox.resource.Messages;



/**
 * eՖʃNX̐eNX
 */
public class BoardBase {

	private UndoManager undoManager;
	private Size size;

	private Address[] cellAddrs; // ՖʑŜ̃}XWXg
	private SideAddress[] borderAddrs; // Ֆʓ̕ӍWXg

	/**
	 * ՖʃTCYāCBoard ̏s
	 * @param size Ֆʂ̍sTCY
	 */
	public void setSize(Size size){
		Address.createAddressInstances(size);
		SideAddress.createSideAddressInstances(size);
		this.size = size;
		prepareAddresse();
		setup();
	}

	public void setSize(int r, int c){
		this.setSize(new Size(r, c));
	}
	/**
	 * Board ̏
	 * z񐶐Ȃǂ̏s
	 * eTuNXŃI[o[Ch
	 */
	protected void setup(){
	}	

	protected void prepareAddresse() {
		this.cellAddrs = new Address[rows()*cols()];
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				cellAddrs[r*cols()+c] = Address.address(r, c);
			}
		}
		this.borderAddrs = new SideAddress[rows()*(cols()-1)+(rows()-1)*cols()];
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols()-1; c++) {
				int p = r*(cols()-1)+c;
				borderAddrs[p] = SideAddress.sideAddress(Direction.VERT, r, c);
			}
		}
		for (int r=0; r<rows()-1; r++) {
			for (int c=0; c<cols(); c++) {
				int p = rows()*(cols()-1)+r*cols()+c;
				borderAddrs[p] = SideAddress.sideAddress(Direction.HORIZ, r, c);
			}
		}
	}

	/**
	 * UndoManager ݒ肷
	 * @param u UndoManager
	 */
	public void setUndoManager(UndoManager u) {
		undoManager = u;
	}

	public UndoManager getUndoManager() {
		return undoManager;
	}
	/**
	 * Ֆ Size 擾
	 * @return ՖʂSize
	 */
	public Size getSize() {
		return size;
	}
	/**
	 * Ֆʂ̍s擾
	 * @return s
	 */
	public final int rows() {
		return size.getRows();
	}

	public boolean isRecordUndo() {
		if (getUndoManager() != null)
			return getUndoManager().isRecordUndo();
		return false;
	}

	public void setRecordUndo(boolean b) {
		if (getUndoManager() != null)
			getUndoManager().setRecordUndo(b);
	}

	/**
	 * ȍ~̃AhDɂ܂Ƃ߂
	 */
	protected void startCompoundUndo() {
		getUndoManager().startCompoundUndo();
	}
	/**
	 * ܂ł̃AhDɂ܂Ƃ߂
	 */
	protected void stopCompoundUndo() {
		getUndoManager().stopCompoundUndo();
	}

	/**
	 * Ֆʂ̗񐔂擾
	 * @return 
	 */
	public final int cols() {
		return size.getCols();
	}
	/**
	 * ōW^ꂽ}XՏɂ邩ǂ
	 * @param r sW
	 * @param c W
	 * @return Տɂ true
	 */
	public boolean isOn(int r, int c) {
		return (r >= 0 && r < rows() && c >= 0 && c < cols());
	}
	/**
	 * ōW^ꂽ}XՏɂ邩ǂ
	 * ՖʃTCY adjustRow, adjustCol ̒l̕␳
	 * 0 <= r < rows()+adjustRow, 0 <= c < col()+adjustCol ̂Ƃ true Ԃ
	 * @param r sW
	 * @param c W
	 * @param adjustRow s̕␳l
	 * @param adjustCol ̕␳l
	 * @return Տɂ true
	 */
	public boolean isOn(int r, int c, int adjustRow, int adjustCol) {
		return (r >= 0 && r < rows()+adjustRow && c >= 0 && c < cols()+adjustCol);
	}
	/**
	 * ōW^ꂽ}XՏɂ邩ǂ
	 * @param position ׂW
	 * @return Տɂ true
	 */
	public boolean isOn(Address position) {
		return isOn(position.r(), position.c());
	}
	/**
	 * ōW^ꂽ}XՏɂ邩ǂ
	 * @param position ׂW
	 * @return Տɂ true
	 */
	public boolean isOnAll(Address... positions) {
		for (Address p : positions)
			if (! isOn(p))
				return false;
		return true;
	}
	/**
	 * ōW^ꂽӂՏɂ邩ǂ
	 * @param d c
	 * @param r sW
	 * @param c W
	 * @return Տɂ true
	 */
	public boolean isSideOn(int d, int r, int c) {
		if (d==Direction.VERT)
			return (r >= 0 && r < rows() && c >= 0 && c < cols()-1);
		else if (d==Direction.HORIZ)
			return (r >= 0 && r < rows()-1 && c >= 0 && c < cols());
		else
			return false;
	}
	/**
	 * ōW^ꂽӂՏɂ邩ǂ
	 * @param position
	 * @return Տɂ true
	 */
	public boolean isSideOn(SideAddress position) {
		return isSideOn(position.d(), position.r(), position.c());
	}

	/**
	 * ōW^ꂽӂՏɂ邩ǂ
	 * @param position
	 * @return Տɂ true
	 */
	public boolean isSideOn(Address pos, int dir) {
		switch (dir) {
		case Direction.UP :
			return isSideOn(Direction.HORIZ, pos.r()-1, pos.c());
		case Direction.LT :
			return isSideOn(Direction.VERT, pos.r(), pos.c()-1);
		case Direction.DN :
			return isSideOn(Direction.HORIZ, pos.r(), pos.c());
		case Direction.RT :
			return isSideOn(Direction.VERT, pos.r(), pos.c());
		default :
			return false;
		}
	}
	/**
	 * ŗ^ꂽ̈ŜՓɂ邩
	 * @param area ̈
	 * @return ̈ŜՓɂ true, łȂ false ԂB
	 */
	public boolean isAreaOn(AreaBase area) {
		for (Address pos : area) {
			if (!isOn(pos))
				return false;
		}
		return true;
	}

	/**
	 * ՖʑŜ܂ޗ̈쐬ĕԂB
	 * @return ՖʑŜ܂ޗ̈B
	 */
	public AreaBase getWholeBoardArea() {
		AreaBase area = new AreaBase();
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				area.add(Address.address(r, c));
			}
		}
		return area;
	}

	/**
	 * @return the cellAddrs
	 */
	public Address[] cellAddrs() {
		return cellAddrs;
	}

	/**
	 * @return the borderAddrs
	 */
	public SideAddress[] borderAddrs() {
		return borderAddrs;
	}

	/**
	 * 𓚂C̏Ֆʂɖ߂
	 * eTuNXŎ
	 */
	public void clearBoard() {
	}
	/**
	 * 𓚂Ֆʂ甒}X~Ȃǂ̕⏕I͂
	 * eTuNXŎ
	 */
	public void trimAnswer() {
	}
	/**
	 * 𓚂Ֆʂ甒}X~Ȃǂ̕⏕I͂
	 * AhD͈ɂ܂Ƃ߂
	 */
	public void trimAnswer1() {
		startCompoundUndo();
		trimAnswer();
		stopCompoundUndo();
	}
	/**
	 * Ֆʐݒ肵ƂɌĂсCՖʏԂ
	 * eTuNXŕKvȏLq
	 */
	public void initBoard() {
	}
	/**
	 * ōW^ꂽ}XՏ̍ŊO}Xł邩ǂ
	 * @param r sW
	 * @param c W
	 * @return ŊO}XȂ true
	 */
	public boolean isOnPeriphery(int r, int c) {
		return (r == 0 || r == rows() - 1 || c == 0 || c == cols() - 1);
	}

	public boolean isOnPeriphery(Address p) {
		return isOnPeriphery(p.r(), p.c());
	}
	/**
	 * AhDCxgXi[ɃCxg̔ʒm
	 * AhDΏۂ̑삪ƂɌĂ
	 * @param e the event AhDΏۂ̑ƂȂCxg
	 */
	protected void fireUndoableEditUpdate(AbstractStep e) {
//		if (isRecordUndo())
		undoManager.addEdit(e);
	}
	/**
	 * AhD
	 * ̓Iȑ͊eTuNXŎ
	 * @param step
	 */
	public void undo(AbstractStep step) {
	}
	/**
	 * hD
	 * ̓Iȑ͊eTuNXŎ
	 * @param step
	 */
	public void redo(AbstractStep step) {
	}
	/**
	 * `FbNŊ̏ꍇ̃Rg
	 */
	public static final String COMPLETE_MESSAGE = Messages.getString("BoardBase.MessageComplete"); //$NON-NLS-1$
	
	/**
	 * `FbNCʂ𕶎ŕԂ
	 * @return ʂ\
	 */
	public String checkAnswerString() {
		return Messages.getString("BoardBase.MessageUnavailable"); //$NON-NLS-1$
	}
	/**
	 * `FbNCʂ𐔒lŕԂ
	 * @return Ȃ 0
	 */
	public int checkAnswerCode() {
		return 0;
	}

}
