package pencilbox.common.core;

import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;


/**
 * ՖʕNX̐eNX
 */
public class BoardCopierBase {
	
	/**
	 * Ֆʂ𕡐B
	 * @param src ̔Ֆ
	 * @return Ֆ
	 */
	public BoardBase duplicateBoard(BoardBase src) throws PencilBoxClassException {
		return duplicateBoard(src, 0);
	}
	/**
	 * Ֆʂ]ĕB
	 * @param src ̔Ֆ
	 * @return Ֆ
	 */
	public BoardBase duplicateBoard(BoardBase src, int n) throws PencilBoxClassException {
		BoardBase dst = (BoardBase) ClassUtil.createInstance(this.getClass(), ClassUtil.BOARD_CLASS);
		if (Rotator2.isTransposed(n)){
			dst.setSize(new Size(src.cols(), src.rows()));
		} else {
			dst.setSize(new Size(src.rows(), src.cols()));
		}
		copyBoardStates(src, dst, n);
		return dst;
	}
	
	/**
	 * ՖʂTCYύXĕB
	 * @param src ̔Ֆ
	 * @param size ύX̃TCY
	 * @return Ֆ
	 * @throws PencilBoxClassException
	 */
	public BoardBase duplicateBoard(BoardBase src, Size size) throws PencilBoxClassException {
		BoardBase dst = (BoardBase) ClassUtil.createInstance(this.getClass(), ClassUtil.BOARD_CLASS);
		dst.setSize(size);
		copyBoardStates(src, dst, 0);
		return dst;
	}
	
	/**
	 * ՖʏԂ]ĕB
	 * ՖʑS̈ΏۂƂʂsB
	 * ̂悤ɈȂȏꍇiJbNȂǁjɂẮCeTuNXŎB
	 * @param src ̔Ֆ
	 * @param dst ̔Ֆ
	 * @param n ]ԍ
	 */
	public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
		Address from = Address.address(0, 0);
		Address to = this.rotateCornerAddress(src.rows(), src.cols(), n);
		AreaBase region = src.getWholeBoardArea();
		copyRegion(src, dst, region, from, to, n);
	}

	/**
	 * Ֆʉ]̍pW̍s̍W߂
	 * @param rows Ֆʂ̍s
	 * @param cols Ֆʂ̗
	 * @param rotation ]ԍ
	 * @return
	 */
	private Address rotateCornerAddress(int rows, int cols, int rotation) {
		int R = 0;
		int C = 0;
		switch (rotation) {
			case 0 :
				R = 0;
				C = 0;
				break;
			case 1 :
				R = cols - 1;
				C = 0;
				break;
			case 2 :
				R = rows - 1;
				C = cols - 1;
				break;
			case 3 :
				R = 0;
				C = rows - 1;
				break;
			case 4 :
				R = 0;
				C = 0;
				break;
			case 5 :
				R = 0;
				C = cols - 1;
				break;
			case 6 :
				R = cols - 1;
				C = rows - 1;
				break;
			case 7 :
				R = rows - 1;
				C = 0;
				break;
		}
		return Address.address(R, C);
	}
	/**
	 * ̈B
	 * ̓Iȏ̓TuNXŋLqB
	 * @param board ҏWՖ
	 * @param region ̈
	 */
	public void eraseRegion(BoardBase board, AreaBase region) {
	}
	/**
	 * ̈敡ʁB
	 * ̓Iȏ̓TuNXŋLqB
	 * @param srcBoard ʌՖ
	 * @param board ʐՖ
	 * @param region ʌ̈
	 * @param from ʌ̈挴_
	 * @param to _̕ʐ
	 * @param rotation ]
	 */
	public void copyRegion(BoardBase srcBoard, BoardBase board, AreaBase region, Address from, Address to, int rotation) {
	}
	/**
	 * ̈B
	 * @param board ҏWՖ
	 * @param region ̈
	 */
	public void eraseRegion2(BoardBase board, AreaBase region) {
		board.startCompoundUndo();
		eraseRegion(board, region);
		board.stopCompoundUndo();
		board.initBoard();
	}
	/**
	 * ̈敡ʁB
	 * ߂ɔՖʑŜ𕡐Ă畡ʏsB
	 * @param board ҏWՖ
	 * @param region ʌ̈
	 * @param from ʌ̈挴_
	 * @param to _̕ʐ
	 * @param rotation ]
	 */
	public void copyRegion2(BoardBase board, AreaBase region, Address from, Address to, int rotation) {
		try {
			BoardBase srcBoard = duplicateBoard(board);
			board.startCompoundUndo();
			copyRegion(srcBoard, board, region, from, to, rotation);
			board.stopCompoundUndo();
			board.initBoard();
		} catch (PencilBoxClassException e) {
			e.printStackTrace();
		}
	}
	/**
	 * ̈ړB
	 * ߂ɔՖʑŜ𕡐Ă畡ʏsCړ̗̈B
	 * @param board ҏWՖ
	 * @param region ړ̈
	 * @param from ړ̈挴_
	 * @param to _̈ړ
	 * @param rotation ]
	 */
	public void moveRegion(BoardBase board, AreaBase region, Address from, Address to, int rotation) {
		try {
			BoardBase srcBoard = duplicateBoard(board);
			board.startCompoundUndo();
			eraseRegion(board, region);
			copyRegion(srcBoard, board, region, from, to, rotation);
			board.stopCompoundUndo();
			board.initBoard();
		} catch (PencilBoxClassException e) {
			e.printStackTrace();
		}
	}

	protected Address translateAndRotateAddress(Address pos, Address from, Address to, int rotation) {
		return Rotator2.translateAndRotateAddress(pos, from, to, rotation);
	}

}
