/**
 * 
 */
package pencilbox.common.core;


/**
 * W]vZp⏕NX
 */
public class Rotator2 {

    private Rotator2() {}

	/**
	 * ŗ^]ԍ́CՖʃTCY̏cɊY邩ۂ𓚂
	 * @param n@]ԍ
	 * @return cȂ true, ȂȂ false
	 */
	public static boolean isTransposed(int n) {
		switch (n) {
		case 0 :
		case 2 :
		case 5 :
		case 7 :
			return false;
		case 1 :
		case 3 :
		case 4 :
		case 6 :
			return true;
		default :
			return false;
		}
	}

	/**
	 * ]ϊ̌
	 * @param a@1߂̉]ԍ
	 * @param b@2߂̉]ԍ
	 * @return@]ԍ̐
	 */
	public static int combine(int a, int b) {
		int r = a;
		if (a >= 0 && a <= 3) {
			r = (b / 4) * 4  + (a + b) % 4;
		} else if (a >= 4 && a <= 7) {
			r = ((7-b) / 4) * 4  + (a + (8-b)) % 4;
		}
		return r;
	}

	/**
	 * ^ꂽWposɁC
	 * WfromWtoւ̈ړƓsړ̂ɁC
	 * to𒆐SƂ]ԍrotation̉]{WԂ
	 * @param pos ϊW
	 * @param from sړ̋N_
	 * @param to sړ̏I_
	 * @param rotation ]ԍ
	 * @return ϊ̍W
	 */
	public static Address translateAndRotateAddress(Address pos, Address from, Address to, int rotation) {
		int a = to.r();
		int b = to.c();
		int r = pos.r() - from.r() + to.r();
		int c = pos.c() - from.c() + to.c();
		int R = r;
		int C = c;
		switch (rotation) {
			case 0 :
				R = +r;
				C = +c;
				break;
			case 1 :
				R = -c +b +a;
				C = +r -a +b;
				break;
			case 2 :
				R = -r +a +a;
				C = -c +b +b;
				break;
			case 3 :
				R = +c -b +a;
				C = -r +a +b;
				break;
			case 4 :
				R = +c -b +a;
				C = +r -a +b;
				break;
			case 5 :
				R = +r      ;
				C = -c +b +b;
				break;
			case 6 :
				R = -c +b +a;
				C = -r +a +b;
				break;
			case 7 :
				R = -r +a +a;
				C = +c      ;
				break;
		}
		return Address.address(R, C);
	}

	/**
	 * ^ꂽӍWposɁC
	 * WfromWtoւ̈ړƓsړ̂ɁC
	 * to𒆐SƂ]ԍrotation̉]{ӍWԂ
	 * @param pos ϊ̕ӍW
	 * @param from sړ̋N_
	 * @param to sړ̏I_
	 * @param rotation ]ԍ
	 * @return ϊ̕ӍW
	 */
	public static SideAddress translateAndRotateSideAddress(SideAddress pos, Address from, Address to, int rotation) {
		int a = to.r();
		int b = to.c();
		int r = pos.r() - from.r() + to.r();
		int c = pos.c() - from.c() + to.c();
		int d = pos.d();
		int R = r;
		int C = c;
		int D = d;
		if (d == Direction.VERT){
			switch (rotation) {
				case 0 :
					D = d;
					R = +r;
					C = +c;
					break;
				case 1 :
					D = d^1;
					R = -c +b +a -1;
					C = +r -a +b;
					break;
				case 2 :
					D = d;
					R = -r +a +a;
					C = -c +b +b -1;
					break;
				case 3 :
					D = d^1;
					R = +c -b +a;
					C = -r +a +b;
					break;
				case 4 :
					D = d^1;
					R = +c -b +a;
					C = +r -a +b;
					break;
				case 5 :
					D = d;
					R = +r      ;
					C = -c +b +b -1;
					break;
				case 6 :
					D = d^1;
					R = -c +b +a -1;
					C = -r +a +b;
					break;
				case 7 :
					D = d;
					R = -r +a +a;
					C = +c      ;
					break;
			}
		} else {
			switch (rotation) {
				case 0 :
					D = d;
					R = +r;
					C = +c;
					break;
				case 1 :
					D = d^1;
					R = -c +b +a;
					C = +r -a +b;
					break;
				case 2 :
					D = d;
					R = -r +a +a -1;
					C = -c +b +b;
					break;
				case 3 :
					D = d^1;
					R = +c -b +a;
					C = -r +a +b -1;
					break;
				case 4 :
					D = d^1;
					R = +c -b +a;
					C = +r -a +b;
					break;
				case 5 :
					D = d;
					R = +r      ;
					C = -c +b +b;
					break;
				case 6 :
					D = d^1;
					R = -c +b +a;
					C = -r +a +b -1;
					break;
				case 7 :
					D = d;
					R = -r +a +a -1;
					C = +c      ;
					break;
			}
		}
		return SideAddress.sideAddress(D, R, C);
	}

	/**
	 * Տ̕pl̕ɕϊ
	 * @param direction ϊ̕\l
	 * @return ϊ̕\l
	 */
	public static int rotateDirection(int direction, int rotation) {
		switch (rotation) {
			case 0 :
			case 1 :
			case 2 :
			case 3 :
				direction = (direction + rotation) % 4;
				break;
			case 4 :
			case 5 :
			case 6 :
			case 7 :
				direction = (direction + rotation) % 4;
				direction = direction ^ 1;
				break;
		}
		return direction;
	}

}
