package pencilbox.common.core;

import java.util.Set;
import java.util.TreeSet;

/**
 * ʎlpNX
 */
public class SquareBase {

	private int r0;
	private int c0;
	private int r1;
	private int c1;

	/**
	 * RXgN^
	 * @param ra ̊p̍sW
	 * @param ca ̊p̗W
	 * @param rb ̊p̍sW
	 * @param cb ̊p̗W
	 */
	public SquareBase(int ra, int ca, int rb, int cb) {
		this.r0 = ra<rb?ra:rb;
		this.c0 = ca<cb?ca:cb;
		this.r1 = ra<rb?rb:ra;
		this.c1 = ca<cb?cb:ca;
	}
	/**
	 * RXgN^
	 * @param posA ̊p̍W
	 * @param posB ̊p̍W
	 */
	public SquareBase(Address posA, Address posB) {
		this(posA.r(), posA.c(), posB.r(), posB.c());
	}
	/**
	 * RXgN^
	 * ̎lpƓW̎lp쐬B
	 * @param s lp
	 */
	public SquareBase(SquareBase s) {
		this(s.r0, s.c0, s.r1, s.c1);
	}

	/**
	 * @return the r0
	 */
	public int r0() {
		return r0;
	}
	/**
	 * @return the c0
	 */
	public int c0() {
		return c0;
	}
	/**
	 * @return the r1
	 */
	public int r1() {
		return r1;
	}
	/**
	 * @return the c1
	 */
	public int c1() {
		return c1;
	}
	/**
	 * W̐ݒ
	 * @param ra ̊p̍sW
	 * @param ca ̊p̗W
	 * @param rb ̊p̍sW
	 * @param cb ̊p̗W
	 */
	public void set(int ra, int ca, int rb, int cb) {
		this.r0 = ra<rb?ra:rb;
		this.c0 = ca<cb?ca:cb;
		this.r1 = ra<rb?rb:ra;
		this.c1 = ca<cb?cb:ca;
	}

	/**
	 * lp̂S̃}XWCECCȄ̒4̔zɓĕԂB
	 * @return
	 */
	public Address[] getCorners() {
		return new Address[] {Address.address(r0, c0), Address.address(r0, c1), Address.address(r1, c0), Address.address(r1, c1)};
	}

	public Address p0() {
		return Address.address(r0, c0);
	}

	public Address p1() {
		return Address.address(r1, c1);
	}

	public void set(Address p0, Address p1) {
		set(p0.r(), p0.c(), p1.r(), p1.c());
	}

	public void set(SquareBase a) {
		set(a.r0(), a.c0(), a.r1(), a.c1());
	}

	/**
	 * lp1̒_Œ肵܂܁CΊpʒu̒_̍WύXB
	 * @param rOld ύXO̒_̍sW
	 * @param cOld ύXO̒_̍sW
	 * @param rNew ύX̒_̍sW
	 * @param cNew ύX̒_̍sW
	 */
	public void changeCorner(int rOld, int cOld, int rNew, int cNew) {
		int ra = this.r0;
		int ca = this.c0;
		int rb = this.r1;
		int cb = this.c1;
		if (ra == rOld) {
			ra = rNew;
		} else if (rb == rOld) {
			rb = rNew;
		}
		if (ca == cOld) {
			ca = cNew;
		} else if (cb == cOld) {
			cb = cNew;
		}
		this.set(ra, ca, rb, cb);
	}

	/**
	 * @return ̗TCY
	 */
	public int sizeC() {
		return c1 - c0 +1;
	}
	/**
	 * @return ̍sTCY
	 */
	public int sizeR() {
		return r1 - r0 + 1;
	}

	/**
	 * `̖̈ʐςԂ
	 * @return ̖̈ʐ
	 */
	public int getSquareSize() {
		return (r1-r0+1) * (c1-c0+1);
	}

	/**
	 * lp̌`󂪓
	 * @param o rΏۂ̎lp
	 * @return lp̊p̍Wv true
	 */
	public boolean equals(SquareBase o) {
		if (this == o) 
			return true;
		if (this.r0 == o.r0 && this.c0 == o.c0 && this.r1 == o.r1 && this.c1 == o.c1)
			return true;
		return false;
	}

	/**
	 * `̈Ɋ܂܂}XW̏W
	 * @return }XW̏W
	 */
	public Set<Address> cellSet() {
		Set<Address> s = new TreeSet<Address>();
		for (int r = r0; r <= r1; r++) {
			for (int c = c0; c <= c1; c++) {
				s.add(Address.address(r, c));
			}
		}
		return s;
	}

	public String toString() {
		return "["+r0+","+c0+","+r1+","+c1+"]";
	}

}
