package pencilbox.common.gui;
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import pencilbox.resource.Messages;

/**
 * JX^_CAOp̋ʃX[p[NXB
 * JDialogł͂ȂJPanel̃TuNXłB
 * Ɂuvuv{^zuCuv{^ftHg{^ƂB
 * JDialog쐬Ă̒ɓĕ\CꂽƂɑIꂽʂԂB
 */
public class PencilBoxDialog extends JPanel {

    /** Return value from class method if CANCEL is chosen. */
    public static final int         CANCEL_OPTION = 2;
    /** Return value form class method if OK is chosen. */
    public static final int         OK_OPTION = 0;
    /** Return value from class method if user closes window without selecting
     * anything, more than likely this should be treated as
     * <code>CANCEL_OPTION</code>. */
    public static final int         CLOSED_OPTION = -1;

    /** []{^_CAOĈƂȂ */
    public static final int OK_ONLY = 0;
    /** [][]{^_CAO */
	public static final int OK_CANCEL = 1;

	private int dialogType = OK_CANCEL;
	private JPanel buttonPanel;
	private JButton	buttonOk;
	private JButton buttonCancel;
	private JDialog dialog;
	private int ret = CLOSED_OPTION; // _CAO̕Ԃl

	/**
	 * _CAO쐬
	 * @throws HeadlessException
	 */
	public PencilBoxDialog() {
		super();
		makeDialog();
	}

	protected void makeDialog() {
		this.setLayout(new BorderLayout());
		makeButtonPanel();
		assignKeys();
	}

	private void makeButtonPanel() {
		buttonPanel = new JPanel();
		buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
		buttonOk = new JButton(Messages.getString("PencilBoxDialog.buttonOK")); //$NON-NLS-1$
		buttonCancel = new JButton(Messages.getString("PencilBoxDialog.buttonCancel")); //$NON-NLS-1$
		ActionListener buttonAction = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Object source = e.getSource();
				if (source == buttonOk) {
					accept();
				} else if (source == buttonCancel) {
					cancel();
				}
			}
		};
		buttonOk.addActionListener(buttonAction);
		buttonCancel.addActionListener(buttonAction);
		buttonPanel.setLayout(new FlowLayout());
		buttonPanel.add(buttonOk);
		if (dialogType == OK_CANCEL) {
			buttonPanel.add(buttonCancel);
		}
		this.add(buttonPanel, BorderLayout.SOUTH);
	}

	/**
	 * _CAO^Cvݒ肷B
	 * @param dialogType The dialogType to set.
	 */
	public void setDialogType(int dialogType) {
		this.dialogType = dialogType;
	}

	/**
	 * ESC L[Ń_CAO
	 */
	private void assignKeys() {
		InputMap imap = this.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
		imap.put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), "close");
		ActionMap amap = this.getActionMap();
		amap.put("close", new AbstractAction() {	
			public void actionPerformed(ActionEvent e) {
				if (dialog != null) { // Ô
					ret = CLOSED_OPTION;
					dialog.setVisible(false);	
				}
			}
		});
	}

	protected void accept() {
		ret = OK_OPTION;
		dialog.setVisible(false);
	}

	protected void cancel() {
		ret = CANCEL_OPTION;
		dialog.setVisible(false);
	}

	/**
	 * _CAO\B
	 * JDialog蒼āC̃NXPanelJDialog̒ɓĕ\B
	 * @param parent et[
	 * @param title ^Cg
	 * @return [U[̑I
	 */
//	Ql Core JAVA Vol.1 list 9-18
	public int showDialog(Component parent, String title) {
		Frame owner = null;
		if (parent instanceof Frame)
			owner = (Frame)parent;
		else
			owner = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
		if (dialog == null || dialog.getOwner() != owner) {
			dialog = new JDialog(owner, true);
			dialog.getContentPane().add(this);
			dialog.pack();
			dialog.getRootPane().setDefaultButton(buttonOk);
			dialog.setTitle(title);
			dialog.setLocationRelativeTo(owner);
		}
		setInitialFocus();
		dialog.setVisible(true);
		return ret;
	}

	/**
	 * eDialogނƂɁCtH[JXݒ肷B
	 */
	protected void setInitialFocus() {
	}
}

