package pencilbox.common.gui;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import pencilbox.common.core.Address;
import pencilbox.common.core.AreaBase;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator2;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;

/**
 * ̈ҏW[hł̃plɑ΂}EXCL[{[h̃CxgsNX
 */
public class RegionEditHandler implements KeyListener, MouseListener, MouseMotionListener {

	private PanelBase panel;
	private BoardBase board;
	private BoardCopierBase boardCopier;

	private EventHandlerManager eventHandlerManager;

	private Address oldPos = Address.address(-1, -1);

	private AreaBase copyRegion;
	private AreaBase pasteRegion;
	private Address copyRegionOrigin;
	private Address pasteRegionOrigin;
	private Address pivot = Address.address();
	private int pasteRotation;

	/**
	 * RegionEditHandler𐶐
	 */
	public RegionEditHandler() {
	}

	public void setup(PanelBase panel, BoardBase board, EventHandlerManager eventHandlerManager) {
		this.eventHandlerManager = eventHandlerManager;
		this.panel = panel;
		this.board = board;
		try {
			boardCopier = (BoardCopierBase) ClassUtil.createInstance(board.getClass(), ClassUtil.BOARD_COPIER_CLASS);
		} catch (PencilBoxClassException e) {
			boardCopier = new BoardCopierBase();
		}
		this.copyRegion = panel.getCopyRegion();
		this.pasteRegion = panel.getPasteRegion();
//		this.copyRegionOrigin = panel.getCopyRegionOrigin();
//		this.pasteRegionOrigin = panel.getPasteRegionOrigin();
		this.pasteRotation = 0;
//		init();
	}

	public void init() {
		copyRegion.clear();
		pasteRegion.clear();
		copyRegionOrigin = Address.nowhere();
		pasteRegionOrigin = Address.nowhere();
	}

	/**
	 * hbOɂ̈ړŒǂB
	 * @return
	 */
	private boolean isMovingRegion() {
		return ! pasteRegionOrigin.isNowhere();
	}

	public void repaint() {
		panel.repaint();
	}

	public boolean isOn(Address position) {
		return board.isOn(position);
	}

	/*
	 * L[Xi[
	 */
	public void keyPressed(KeyEvent e) {
		int keyCode = e.getKeyCode();
		switch (keyCode) {
		case KeyEvent.VK_SLASH:
		case KeyEvent.VK_DIVIDE:
			slashKeyEntered();
			break;
//		case KeyEvent.VK_LEFT: // 0x25
//			arrowKeyEntered(Direction.LT);
//			break;
//		case KeyEvent.VK_UP: // 0x26
//			arrowKeyEntered(Direction.UP);
//			break;
//		case KeyEvent.VK_RIGHT: // 0x27
//			arrowKeyEntered(Direction.RT);
//			break;
//		case KeyEvent.VK_DOWN: // 0x28
//			arrowKeyEntered(Direction.DN);
//			break;
		case KeyEvent.VK_SPACE:
		case KeyEvent.VK_PERIOD:
		case KeyEvent.VK_DECIMAL:
			spaceKeyEntered();
			break;
//		case KeyEvent.VK_MINUS:
//		case KeyEvent.VK_SUBTRACT:
//			minusKeyEntered();
//			break;
//		case KeyEvent.VK_SEMICOLON:
//		case KeyEvent.VK_ADD:
//			break;
//		case KeyEvent.VK_COLON:
//		case KeyEvent.VK_MULTIPLY:
//			break;
		case KeyEvent.VK_0:
		case KeyEvent.VK_NUMPAD0:
			numberKeyEntered(0);
			break;
		case KeyEvent.VK_1:
		case KeyEvent.VK_NUMPAD1:
			numberKeyEntered(1);
			break;
		case KeyEvent.VK_2:
		case KeyEvent.VK_NUMPAD2:
			numberKeyEntered(2);
			break;
		case KeyEvent.VK_3:
		case KeyEvent.VK_NUMPAD3:
			numberKeyEntered(3);
			break;
		case KeyEvent.VK_4:
		case KeyEvent.VK_NUMPAD4:
			numberKeyEntered(4);
			break;
		case KeyEvent.VK_5:
		case KeyEvent.VK_NUMPAD5:
			numberKeyEntered(5);
			break;
		case KeyEvent.VK_6:
		case KeyEvent.VK_NUMPAD6:
			numberKeyEntered(6);
			break;
		case KeyEvent.VK_7:
		case KeyEvent.VK_NUMPAD7:
			numberKeyEntered(7);
			break;
//		case KeyEvent.VK_8:
//		case KeyEvent.VK_NUMPAD8:
//			numberKeyEntered(8);
//			break;
//		case KeyEvent.VK_9:
//		case KeyEvent.VK_NUMPAD9:
//			numberKeyEntered(9);
//			break;
		}
		repaint();
	}

	public void keyTyped(KeyEvent e) {
	}

	public void keyReleased(KeyEvent e) {
	}

//	/**
//	 * L[͂B 
//	 */
//	protected void arrowKeyEntered(int direction) {
//	}

	/**
	 * L[͂B 
	 * Ï]B
	 */
	protected void numberKeyEntered(int number) {
		if (number >= 8)
			return;
		if (isMovingRegion()) {
			pasteRotation = Rotator2.combine(pasteRotation, number);
			updatePasteRegion();
		}
	}

	/**
	 * sIhL[̓͂B
	 */
	protected void spaceKeyEntered() {
		boardCopier.eraseRegion2(board, copyRegion);
		board.initBoard();
	}

//	/**
//	 * }CiXL[̓͂B
//	 */
//	protected void minusKeyEntered() {
//	}

	/**
	 * XbVL[̓͂B 
	 * u̓[hvɐ؂ւ
	 */
	protected void slashKeyEntered() {
		eventHandlerManager.setEditMode(PanelBase.PROBLEM_INPUT_MODE);
	}

	/*
	 * }EXXi[
	 */
	public void mousePressed(MouseEvent e) {
		Address newPos = panel.pointToAddress(e.getX(), e.getY());
		if (!isOn(newPos))
			return;
		boolean shift = (e.getModifiersEx() & InputEvent.SHIFT_DOWN_MASK) != 0;
		boolean ctrl = (e.getModifiersEx() & InputEvent.CTRL_DOWN_MASK) != 0;
		if ((e.getButton() == MouseEvent.BUTTON1)) {
			leftPressed(newPos, shift, ctrl);
		} else if ((e.getButton() == MouseEvent.BUTTON3)) {
			rightPressed(newPos, shift, ctrl);
		}
		oldPos = newPos; // ݈ʒuXV
		repaint();
	}

	public void mouseDragged(MouseEvent e) {
		Address newPos = panel.pointToAddress(e.getX(), e.getY());
		if (!isOn(newPos)) {
			return;
		}
		if (newPos.equals(oldPos))
			return; // }XɎ~܂Cxg͖
		boolean shift = e.isShiftDown();
//		boolean ctrl = e.isControlDown();
		if ((e.getModifiers() & InputEvent.BUTTON1_MASK) != 0) {
			leftDragged(newPos, shift);
		} else if ((e.getModifiers() & InputEvent.BUTTON3_MASK) != 0) {
			rightDragged(newPos);
		}
		oldPos = newPos; // ݈ʒuXV
		repaint();
	}

	public void mouseReleased(MouseEvent e) {
		boolean shift = e.isShiftDown();
		boolean ctrl = e.isControlDown();
		if ((e.getButton() == MouseEvent.BUTTON1)) {
			leftReleased(shift, ctrl);
		}
		repaint();
	}

	public void mouseExited(MouseEvent e) {
	}

	public void mouseEntered(MouseEvent e) {
	}

	public void mouseClicked(MouseEvent e) {
	}

	public void mouseMoved(MouseEvent e) {
	}

	/**
	 * {^ꂽƂɌĂ΂B
	 * Iςݗ̈Iꍇ́C̗̈ړΏۂƂB
	 * ȊȌꍇ͗̈I̎n_ƂB
	 * @param position
	 * @param shift
	 * @param ctrl
	 */
	protected void leftPressed(Address position, boolean shift, boolean ctrl) {
		if (copyRegion.contains(position)) {
			copyArea(copyRegion, pasteRegion);
			copyRegionOrigin = position;
			pasteRegionOrigin = position;
		} else {
			if (! ctrl) {
				copyRegion.clear();
			}
			copyRegion.add(position);
			pivot = position;
		}
	}

	/**
	 * hbO܂܂V}XɈړƂɌĂ΂D
	 * ̈ړ́CړB
	 * ̈I𒆂́C}ẌɉB
	 * @param position
	 * @param shift
	 */
	protected void leftDragged(Address position, boolean shift) {
		if (isMovingRegion()) {
			pasteRegionOrigin = position;
			updatePasteRegion();
		} else {
			if (shift) {
				selectRectangularArea(position);
			} else {
				copyRegion.add(position);
				pivot = position;
			}
		}
	}

	/**
	 * `I
	 * @param position
	 */
	private void selectRectangularArea(Address position) {
		int r0 = (pivot.r() < position.r()) ? pivot.r() : position.r();
		int r1 = (pivot.r() < position.r()) ? position.r() : pivot.r();
		int c0 = (pivot.c() < position.c()) ? pivot.c() : position.c();
		int c1 = (pivot.c() < position.c()) ? position.c() : pivot.c();
		for (int r = r0; r <= r1; r++) {
			for (int c = c0; c <= c1; c++) {
				copyRegion.add(Address.address(r, c));
			}
		}
	}

	/**
	 * }EX{^𗣂čhbOm肵ƂɌĂ΂B 
	 * ̈ړ́Cړm肷B
	 * CTRLL[Ȃ{^𗣂ƃRs[ɁCȊO͈ړɂȂB
	 * @param shift
	 * @param ctrl
	 */
	protected void leftReleased(boolean shift, boolean ctrl) {
		if (isMovingRegion()) {
			if (ctrl) {
				boardCopier.copyRegion2(board, copyRegion, copyRegionOrigin, pasteRegionOrigin, pasteRotation);
			} else {
				boardCopier.moveRegion(board, copyRegion, copyRegionOrigin, pasteRegionOrigin, pasteRotation);
			}
			board.initBoard();
			copyArea(pasteRegion, copyRegion);
			pasteRegion.clear();
			copyRegionOrigin = Address.nowhere();
			pasteRegionOrigin = Address.nowhere();
			pasteRotation = 0;
		}
	}

	/**
	 * E{^ꂽƂɌĂ΂B 
	 * ÏŜB
	 * CTRLȂ̏ꍇ́C̃}X̂ݗ̈悩珜B
	 * @param position
	 * @param shift
	 * @param ctrl
	 */
	protected void rightPressed(Address position, boolean shift, boolean ctrl) {
		if (ctrl) {
			copyRegion.remove(position);
		} else {
			copyRegion.clear();
			pasteRegion.clear();
			copyRegionOrigin = Address.nowhere();
			pasteRegionOrigin = Address.nowhere();
			pasteRotation = 0;
		}
	}

	/**
	 * EhbO܂܂V}XɈړƂɌĂ΂B
	 * @param position
	 */
	protected void rightDragged(Address position) {
		copyRegion.remove(position);
	}

	/**
	 * ̈𕡎ʂB
	 */
	private void copyArea(AreaBase src, AreaBase dst) {
		dst.clear();
		for (Address p : src) {
			if (isOn(p)) {
				dst.add(p);
			}
		}
	}

	/**
	 * _̕ʐ̈쐬
	 */
	private void updatePasteRegion() {
		pasteRegion.clear();
		for (Address p : copyRegion) {
			pasteRegion.add(Rotator2.translateAndRotateAddress(p, copyRegionOrigin, pasteRegionOrigin, pasteRotation));
		}
	}

}
