package pencilbox.kurodoko;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.Direction;
import pencilbox.resource.Messages;

/**
 * u}X͂ǂvՖʃNX
 */
public class Board extends BoardBase {

	static final int HORIZ = Direction.HORIZ;
	static final int VERT = Direction.VERT;

	static final int WHITE = -1;
	static final int BLACK = -2;
	static final int UNKNOWN = 0;
	static final int OUT = -3;
	static int UNDECIDED_NUMBER = -4;

	private int[][] state;
	private int[][] chain; // }X̎΂߂ȂL^
	private int maxChain;
	private Number[][] number;

	protected void setup() {
		super.setup();
		state = new int[rows()][cols()];
		chain = new int[rows()][cols()];
		number = new Number[rows()][cols()];
	}

	public void clearBoard() {
		super.clearBoard();
		for (Address p : cellAddrs()) {
			if (!isNumber(p))
				setState(p,UNKNOWN);
		}
		initBoard();
	}

	public void trimAnswer() {
		for (Address p : cellAddrs()) {
			if (getState(p) == WHITE) {
				changeState(p, UNKNOWN);
			}
		}
		initNumber();
	}

	/**
	 * @return Returns the state.
	 */
	int[][] getState() {
		return state;
	}

	public int getState(int r, int c) {
		return state[r][c];
	}

	public int getState(Address pos) {
		return getState(pos.r(), pos.c());
	}

	public void setState(int r, int c, int st ) {
		state[r][c] = st;
	}

	public void setState(Address pos, int st) {
		setState(pos.r(), pos.c(), st);
	}
	/**
	 * ̃}Xǂ
	 */
	public boolean isNumber(Address pos) {
		int n = getState(pos);
		return n > 0 || n == Board.UNDECIDED_NUMBER;
	}
	/**
	 * ̍W}XǂB
	 * @param p W
	 * @return }XȂ true ԂB
	 */
	public boolean isBlack(Address p) {
		return isOn(p) && getState(p) == BLACK;
	}

	public boolean isWhiteOrNumber(Address p) {
		int n = getState(p);
		return n == WHITE || n>0 || n == UNDECIDED_NUMBER;
	}

	public void initBoard() {
		initChain();
		initNumber();
	}

	void initNumber() {
		for (Address p : cellAddrs()) {
			if (isNumber(p)) {
				setNumber(p, new Number(getState(p)));
				initNumber(p);
			} else {
				setNumber(p, null);
			}
		}
	}

	/**
	 * }X p0  d ɌƂ̔}X̐𒲂ׂ
	 * @param p0
	 */
	void initNumber(Address p0) {
		int n=1;
		for (int d=0; d<4; d++) {
			Address p = p0;
			while(isOn(p) && !isBlack(p)) {
				p = p.nextCell(d);
				if (!isOn(p))
					break;
				if (isBlack(p))
					break;
				n++;
			};
		}
		getNumber(p0).setNSpace(n);
		n=1;
		for (int d=0; d<4; d++) {
			Address p = p0;
			while(true) {
				p = p.nextCell(d);
				if (!isOn(p))
					break;
				if (!isWhiteOrNumber(p))
					break;
				n++;
			};
		}
		getNumber(p0).setNWhite(n);
	}

	public Number getNumber(Address p) {
		return number[p.r()][p.c()];
	}

	public void setNumber(Address p, Number n) {
		number[p.r()][p.c()] = n;
	}
	/**
	 * }X̎΂߂ȂԍԂ
	 * @param p cell coordinate
	 * @return Returns the chain.
	 */
	int getChain(Address p) {
		return chain[p.r()][p.c()];
	}

	void setChain(Address p, int n) {
		chain[p.r()][p.c()] = n;
	}

	/**
	 * }X̏Ԃw肵ԂɕύXCύXAhDXi[ɒʒm
	 * @param p }XW
	 * @param st ύX̏
	 */
	public void changeState(Address p, int st) {
		int prev = getState(p);
		if (st == prev)
			return;
		if (isRecordUndo())
			fireUndoableEditUpdate(new CellEditStep(p, prev, st));
		setState(p, st);
		if (st == BLACK) {
			connectChain(p);
		} else if (prev == BLACK) {
			cutChain(p);
		}
		if (st > 0 || st == Board.UNDECIDED_NUMBER) {
			setNumber(p, new Number(st));
			initNumber(p);
		} else if (prev > 0 || prev == Board.UNDECIDED_NUMBER) {
			setNumber(p, null);
		}
		if (st == BLACK || prev == BLACK)
			updateSpace(p);
	}

	public void undo(AbstractStep step) {
		if (step instanceof CellEditStep) {
			CellEditStep s = (CellEditStep) step;
			changeState(s.getPos(), s.getBefore());
		}
	}

	public void redo(AbstractStep step) {
		if (step instanceof CellEditStep) {
			CellEditStep s = (CellEditStep) step;
			changeState(s.getPos(), s.getAfter());
		}
	}

	/**
	 * ̃}X̏㉺E̗אڂS}Xɍ}X邩ǂ𒲂ׂ
	 * @param p
	 * @return ㉺Eɍ}XЂƂł true
	 */
	boolean isBlock(Address p) {
		for (int d=0; d<4; d++) {
			if (isBlack(Address.nextCell(p, d)))
				return true;
		}
		return false;
	}
	/**
	 * 	chainz
	 */
	void initChain() {
		maxChain = 1;
		for (Address p : cellAddrs()) {
			setChain(p, 0);
		}
		for (Address p : cellAddrs()) {
			if (isOnPeriphery(p)) {
				if (isBlack(p) && getChain(p) == 0) {
					if (initChain1(p, -1, 1) == -1) {
						updateChain(p, -1);
					}
				}
			}
		}
		for (Address p : cellAddrs()) {
			if (!isOnPeriphery(p)) {
				if (isBlack(p) && getChain(p) == 0) {
					if (initChain1(p, -1, ++maxChain) == -1) {
						updateChain(p, -1);
					}
				}
			}
		}
	}
	/**
	 * ΂߂ɂȂ鍕}XǂCchain ɔԍ n ݒ肷
	 * f𔭌C̎_ -1 ԂĖ߂
	 * @param p ̃}X
	 * @param d Ăяõ}X獡̃}XC̃}X߂Ȃ -1
	 * @param n ݒ肷l
	 * @return Ֆʂ̕f𔭌 -1 , łȂ n Ɠl
	 */
	int initChain1(Address p, int d, int n) {
		if (n == 1 && d != -1 && isOnPeriphery(p)) { // ւOɒB
			return -1;
		}
		if (n >= 0 && isOnPeriphery(p)) {
			setChain(p, 1);
		} else {
			setChain(p, n);
		}
		for (int dd : Direction.DIAGONAL4) {
			Address pp = Address.nextCell(p, dd);
			if (dd == (d^2))
				continue; // Ƃ͂Ƃ΂
			if (!isBlack(pp))
				continue; // }XȊO͂Ƃ΂
			if (getChain(pp) == n) // ւ
				return -1;
			if (initChain1(pp, dd, n) == -1)
				return -1;
		}
		return n;
	}
	private int[] adjacentChain = new int[4];
	/**
	 * 	Ŋm肵ƂɁC̃}X_ƂchainXVD
	 * 	̃}Xm肵ƂɂCVKɕf邩𒲂ׁC
	 * 	Ȃ chain Ŝ -1 ōXVD
	 * 	ȂȂC΂ߗא4}X̍ŏlɂ킹D
	 * 	΂ߗׂɍ}XȂ΁CVԍD
	 * @param p }X̍W
	 */
	void connectChain(Address p) {
		int[] adjacent = adjacentChain;
		int k = 0;
		int newChain = Integer.MAX_VALUE;
		if (isOnPeriphery(p))
			newChain = 1;
		for (int dd : Direction.DIAGONAL4) {
			Address pp = Address.nextCell(p, dd);
			if (!isBlack(pp))
				continue; // }XȊO͂Ƃ΂
			int c1 = getChain(pp);
			if (isOnPeriphery(p) && c1 == 1) {
				newChain = -1; // [̃}XɂƂԍ1番fꂽ
			} 
			adjacent[k] = c1;
			for (int l = 0; l < k; l++) {
				if (adjacent[k] == adjacent[l]) // ԍ番fꂽ
					newChain = -1;
			}
			k++;
			if (c1 < newChain)
				newChain = c1;
		}
		if (newChain == Integer.MAX_VALUE)
			setChain(p, ++maxChain); // ͂ɍ}XȂƂCVԍ
		else
			updateChain(p, newChain); // ͂ɍ}XƂC̍ŏԍ
	}
	/**
	 * }XƂɁCchainXV
	 * SvZȂƂɂ
	 * @param p
	 */
	void cutChain(Address p) {
		initChain();
	}
	/**
	 * 	}X chainԍݒ肷
	 * 	΂ߗׂɍ}XΓԍݒ肷
	 * @param p }X̍W
	 * @param n ݒ肷l
	 */
	void updateChain(Address p, int n) {
		setChain(p, n);
		for (int dd : Direction.DIAGONAL4) {
			Address pp = Address.nextCell(p, dd);
			if (!isBlack(pp))
				continue; // }XȊO͂Ƃ΂
			if (getChain(pp) == n)
				continue; // ԍ炻̂܂
			updateChain(pp, n);
		}
	}
	/**
	 * }X̏ԂύXƂɁC̃}X̏㉺E̐}XTĔ}X𐔂
	 */
	void updateSpace(Address p0) {
		for (int d=0; d<4; d++) {
			Address p = p0;
			while(true) {
				p = Address.nextCell(p, d);
				if (!isOn(p))
					break;
				if (isBlack(p))
					break;
				if (isNumber(p)) {
					initNumber(p);
				}
			}
		}
	}

	public int checkAnswerCode() {
		int result = 0;
		for (Address p : cellAddrs()) {
			if (isBlack(p)) {
				if (isBlock(p))
					result |= (1<<0);
				if (getChain(p) == -1)
					result |= (1<<1);
			}
			if (getState(p) > 0) {
				int remainder = getNumber(p).getNSpace() - getNumber(p).getNumber();
				if (remainder < 0)
					result |= (1<<2);
				else if (remainder > 0)
					result |= (1<<3);
			}
		}
		return result;
	}

	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result == 0)
			return BoardBase.COMPLETE_MESSAGE;
		StringBuffer message = new StringBuffer();
		if ((result&1) == 1)
			message.append(ERR_CONTINUOUS_BLACK);
		if ((result&2) == 2)
			message.append(ERR_DIVIDED_BOARD);
		if ((result&4) == 4)
			message.append(ERR_SMALL_SIZE);
		if ((result&8) == 8)
			message.append(YET_LARGE_SIZE);
		return message.toString();
	}

	static final String ERR_CONTINUOUS_BLACK = Messages.getString("kurodoko.AnswerCheckMessage1"); //$NON-NLS-1$
	static final String ERR_DIVIDED_BOARD = Messages.getString("kurodoko.AnswerCheckMessage2"); //$NON-NLS-1$
	static final String ERR_SMALL_SIZE = Messages.getString("kurodoko.AnswerCheckMessage3"); //$NON-NLS-1$
	static final String YET_LARGE_SIZE = Messages.getString("kurodoko.AnswerCheckMessage4"); //$NON-NLS-1$
}
