package pencilbox.slalom;

import java.util.LinkedList;
import java.util.List;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BorderEditStep;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.Direction;
import pencilbox.common.core.SideAddress;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;

/**
 * uX[vՖʃNX
 */
public class Board extends BoardBase {

	static final int UNKNOWN = 0;
	static final int LINE = 1;
	static final int NOLINE = -1;
	static final int BLANK = -3;
	static final int GOAL = -1;
	static final int OUTER = -9;
	static final int UNDECIDED_NUMBER = 0;
	static final int GATE_VERT = -5;
	static final int GATE_HORIZ = -4;

	private int[][] number;  // }X̏
	private int[][][] state; // ӂ̏
	private int[][] gateNumber;  // ̔ԍ
	private int nGate;  // ̐
	private Address goal;  // X^[g^S[n_̍WBP݂̂Ƃ

	private List<Link> linkList;
	private Link[][][] link;
	private Link initializingLink;

	protected void setup() {
		super.setup();
		number = new int[rows()][cols()];
		gateNumber = new int[rows()][cols()];
		ArrayUtil.initArrayInt2(number, BLANK);
		goal = Address.nowhere();
		state = new int[2][][];
		state[Direction.VERT] = new int[rows()][cols()-1];
		state[Direction.HORIZ] = new int[rows()-1][cols()];
		linkList = new LinkedList<Link>();
		link = new Link[2][][];
		link[Direction.VERT] = new Link[rows()][cols()-1];
		link[Direction.HORIZ] = new Link[rows()-1][cols()];
	}

	/**
	 * w肵}Xɐ}XC}XC}XC󔒃}X̏Ԃݒ肷
	 * S[͂PȉƂB
	 * @param r sW
	 * @param c W
	 * @param n ݒ肷
	 */
	public void setNumber(int r, int c, int n) {
		number[r][c] = n;
	}

	public void setNumber(Address pos, int n) {
		setNumber(pos.r(), pos.c(), n);
	}
	/**
	 * w肵}X̏Ԃ擾
	 * @param r sW
	 * @param c W
	 */
	public int getNumber(int r, int c) {
		return number[r][c];
	}

	public int getNumber(Address pos) {
		return getNumber(pos.r(), pos.c());
	}

	/**
	 * }X
	 * @param p W
	 * @return }Xł true
	 */
	public boolean isWall(Address p) {
		return getNumber(p) >= 0 || getNumber(p) == UNDECIDED_NUMBER;
	}
	/**
	 * }X
	 * @param r sW
	 * @param c W
	 * @return }XC萔}Xł true
	 */
	public boolean isGate(int r, int c) {
		return number[r][c] == GATE_HORIZ || number[r][c] == GATE_VERT;
	}

	public boolean isGate(Address pos) {
		return isGate(pos.r(), pos.c());
	}
	/**
	 * W̗2}Xꂩ}Xǂ
	 * @param p W
	 * @return W̗2}Xꂩ}Xł true
	 */
	public boolean hasWall(SideAddress p) {
		return isWall(SideAddress.nextCellFromBorder(p, 0))
				|| isWall(SideAddress.nextCellFromBorder(p, 1));
	}
	/**
	 * @param p
	 * @return
	 */
	public int getGateNumber(Address p) {
		return gateNumber[p.r()][p.c()];
	}

	public int getGateNumber(int r, int c) {
		return gateNumber[r][c];
	}

	/**
	 * @param p
	 * @return
	 */
	public int setGateNumber(Address p, int n) {
		return gateNumber[p.r()][p.c()] = n;
	}

	public int setGateNumber(int r, int c, int n) {
		return gateNumber[r][c] = n;
	}
	/**
	 * @return the nGate
	 */
	public int getNGate() {
		return nGate;
	}

	/**
	 * @return the Goal
	 */
	public Address getGoal() {
		return goal;
	}

	/**
	 * ӏԂ̎擾
	 * @param d
	 * @param r
	 * @param c
	 * @return ӂ̏ԂԂ
	 */
	public int getState(int d, int r, int c) {
		if (isSideOn(d, r, c))
			return state[d][r][c];
		else
			return OUTER;
	}

	public int getState(SideAddress pos) {
		return getState(pos.d(), pos.r(), pos.c());
	}

	/**
	 * ӏԂ̐ݒ
	 * @param d
	 * @param r
	 * @param c
	 * @param st
	 */
	public void setState(int d, int r, int c, int st) {
		if (isSideOn(d, r, c))
			state[d][r][c] = st;
	}

	public void setState(SideAddress pos, int st) {
		setState(pos.d(), pos.r(), pos.c(), st);
	}

	public Link getLink(SideAddress pos) {
		if (isSideOn(pos))
			return link[pos.d()][pos.r()][pos.c()];
		else
			return null;
	}
	/**
	 * ̃}X܂ Link Ԃ
	 */
	public Link getLink(Address p) {
		for (int d = 0; d < 4; d++) {
			Link link = getLink(SideAddress.get(p, d));
			if (link != null)
				return link;
		}
		return null;
	}

	public void setLink(SideAddress pos, Link l) {
		link[pos.d()][pos.r()][pos.c()] = l;
	}

	/**
	 * }X̏Ԃw肵ԂɕύX
	 * AhDXi[ɕύXʒm
	 * @param p ӍW
	 * @param st ύX̏
	 */
	public void changeNumber(Address p, int st) {
		int prev = getNumber(p);
		if (prev == st)
			return;
		if (prev == Board.GOAL) {
			goal = Address.nowhere();
		}
		if (st == Board.GOAL) {
			if (!goal.isNowhere()) {
				changeNumber(goal, Board.BLANK);
			}
			goal = p;
		}
		if (isRecordUndo()) {
			fireUndoableEditUpdate(new CellEditStep(p, prev, st));
		}
		setNumber(p, st);
	}

	/**
	 * }X㉺E4ɈĂ
	 * }X}X␔}XɕύXꂽꍇɐ邽߂Ɏgp
	 * @param pos }X̍W
	 */
	void eraseLinesAround(Address pos) {
		for (int d = 0; d <= 3; d++) {
			SideAddress side = SideAddress.get(pos, d);
			if (getState(side) == LINE || getState(side) == NOLINE) {
				changeState(side, UNKNOWN);
			}
		}
	}

	/**
	 * ӂ̏Ԃw肵ԂɕύX
	 * AhDXi[ɕύXʒm
	 * @param p ӍW
	 * @param st ύX̏
	 */
	public void changeState(SideAddress p, int st) {
		int prev = getState(p);
		if (st == prev)
			return;
		if (isRecordUndo())
			fireUndoableEditUpdate(new BorderEditStep(p, prev, st));
		setState(p, st);
		if (prev == LINE) {
			cutLink(p);
		}
		if (st == LINE) {
			connectLink(p);
		}
	}

	public void undo(AbstractStep step) {
		if (step instanceof BorderEditStep) {
			BorderEditStep s = (BorderEditStep) step;
			changeState(s.getPos(), s.getBefore());
		} else if (step instanceof CellEditStep) {
			CellEditStep s = (CellEditStep) step;
			changeNumber(s.getPos(), s.getBefore());
		}
	}

	public void redo(AbstractStep step) {
		if (step instanceof BorderEditStep) {
			BorderEditStep s = (BorderEditStep) step;
			changeState(s.getPos(), s.getAfter());
		} else if (step instanceof CellEditStep) {
			CellEditStep s = (CellEditStep) step;
			changeNumber(s.getPos(), s.getAfter());
		}
	}

	public void clearBoard() {
		super.clearBoard();
		ArrayUtil.initArrayInt3(state, UNKNOWN);
		initBoard();
	}

	public void trimAnswer() {
		for (SideAddress p : borderAddrs()) {
			if (getState(p) == NOLINE) {
				changeState(p, UNKNOWN);
			}
		}
	}

	public void initBoard() {
		initGates();
		initLinks();
	}

	/**
	 * B ՖʑŜ̊Ƃ̔ԍݒ肷B
	 */
	void initGates() {
		nGate = 0;
		for (Address p : cellAddrs()) {
			setGateNumber(p, 0);
		}
		for (Address p : cellAddrs()) {
			int n = getNumber(p);
			if (n == GOAL) {
				goal = p;
			} else if (n == GATE_HORIZ) {
				Address p1 = Address.nextCell(p, Direction.LT);
				if (isOn(p1) && getNumber(p1) == GATE_HORIZ) {
				} else {
					nGate ++;
				}
			} else if (n == GATE_VERT) {
				Address p1 = Address.nextCell(p, Direction.UP);
				if (isOn(p1) && getNumber(p1) == GATE_VERT) {
				} else {
					nGate ++;
				}
			}
		}
		for (Address p : cellAddrs()) {
			int n = getNumber(p);
			if (n > 0) {
				initGateNumber(p, n);
			}
		}
	}

	/**
	 * }X̔Α̍}XT
	 * @param p0 N_}X
	 * @param d 
	 * @return@̔Αɍ}X܂͊OȂ΂̍WCȊOnull
	 */
	Address getAnotherPole(Address p0, int d) {
		Address p = p0;
		int gateType = 0;
		if (d == Direction.UP || d == Direction.DN) {
			gateType = GATE_VERT;
		} else if (d == Direction.LT || d == Direction.RT) {
			gateType = GATE_HORIZ;
		}
		while (true) {
			p = Address.nextCell(p, d);
			if (isOn(p)) {
				if (isWall(p)) {
//					System.out.println(p.toString() + "[͍}X");
					return p;
				} else if (getNumber(p) == gateType) {
				} else {
//					System.out.println(p.toString() + "[͕ĂȂ");
					return null;
				}
			} else {
//				System.out.println(p.toString() + "[͊O");
				return p;
			}
		}
	}

	/**
	 * }XN_ɁCɏoĂɔԍݒ肷B
	 * @param p0
	 * @param d
	 * @param n
	 */
	private void setGateNumber(Address p0, int d, int n) {
		int t = 0;
		if (d == 0 || d == 2)
			t = GATE_VERT;
		else
			t = GATE_HORIZ;
		Address p = p0;
		while (true) {
			p = p.nextCell(d);
			if (isOn(p) && getNumber(p) == t) {
				setGateNumber(p, n);
			} else {
				break;
			}
		}
	}
	/**
	 * ̔ԍ𒲂ׂB
	 * ̑猩̂͌߂ɂ̂ŁA}X猩B
	 * t̍}X㉺Eɗאڂ݂B
	 * ̔Αɓ̍}X΁C}X̐̔ԍB
	 * ̔ΑɈقȂ鐔̍}X΁C̔ԍ -1B
	 * }Xɗאڂ傪PŁC̔ԍ܂܂ĂȂ΁C}X̐̔ԍB
	 * @param p0s
	 * @param n0 ̐Ƃ
	 */
	private void initGateNumber(Address p0, int n0) {
		Address p = p0;
		Address p1 = null;
//		System.out.println(p.toString() + "̍}XɂĒׂB");
		int d1 = -1; // Ί݂̍}X̌L^
		int ng = 0;  // 肵ԍL^
		int count = 0; // }X̂S̖̐𐔂
		for (int d = 0; d <= 3; d++) {
			int t = 0;
			if (d == 0 || d == 2)
				t = GATE_VERT;
			else
				t = GATE_HORIZ;
			p = p0;
			p = p.nextCell(d);
			if (isOn(p) && getNumber(p) == t) {
//				System.out.println(d + "̌ɖ傪");
				d1 = d;
				count++;
				p1 = getAnotherPole(p, d);
				if (p1 != null && isOn(p1)) {
					int n1 = getNumber(p1);
					if (n1 == n0) { // Ί݂̖Ɠԍ
						ng = n1;
						setGateNumber(p0, d, n1);
//						System.out.println("Ί݂̐}X" + p1.toString() + "Ƃ̊Ԃ̖̔ԍ " + n1);
					} else if (n1 > 0 && n1 != n0) {
						ng = -1;
						setGateNumber(p0, d, -1);
//						System.out.println("Ί݂̐}XقȂԍł邽߁C̔ԍ -1 ƂB");
					}
				} else {
//					System.out.println("Ί݂ɐ}XȂ");
				}
			}
		}
		if (count == 0) {
//			System.out.println("㉺ESɖ傪Ȃ ");
		} else if (count == 1) {
			if (ng == 0) {
				setGateNumber(p0, d1, n0);
//				System.out.println("אڂ傪PȂ̂ŁC̖̔ԍ " + n0 + "Ɍ߂");
			} else if (ng == -1) {
//				System.out.println("אڂ傪PȂꍇłAقȂ鐔ɂ͂܂ꂽ̔ԍ-1ƂB ");
			} else if (ng > 0) {
//				System.out.println("אڂ傪PȂCς݁B");
			}
		} else if (count > 1) {
//			System.out.println("̖ɗאڂ̂Ŗ̔ԍ܂Ȃ");
		}
	}

	void initLinks() {
		Link.resetId();
		linkList.clear();
		ArrayUtil.initArrayObject2(link[0], null);
		ArrayUtil.initArrayObject2(link[1], null);
		for (Address p : cellAddrs()) {
			initLink(p);
		}
	}

	/**
	 * }X܂ Link ̏
	 * link[][][] ͏Ă̂Ƃ
	 * @param p Link̋N_}X̍W
	 */
	void initLink(Address p) {
		initializingLink = new Link();
		for (int d = 0; d < 4; d++) {
			initLink1(SideAddress.get(p, d));
		}
		if (!initializingLink.isEmpty()) {
			linkList.add(initializingLink);
		}
	}

	private void initLink1(SideAddress p) {
		if (!isSideOn(p))
			return;
		if (getState(p) != LINE)
			return;
		if (getLink(p) != null)
			return;
		initializingLink.add(p);
		setLink(p, initializingLink);
		for (int d = 0; d < 6; d++) {
			initLink1(SideAddress.nextBorder(p, d));
		}
	}
	/**
	 * Link 
	 */	
	void connectLink(SideAddress p) {
		Link newLink = new Link();
		for (int d = 0; d < 2; d++) {
			Link link = getLink(SideAddress.nextCellFromBorder(p, d));
			if (link != null && (link.size() > newLink.size()))
				newLink = link;
		}
		if (newLink.isEmpty()) {
			linkList.add(newLink);
		}
		for (int d = 0; d < 2; d++) {
			Link link = getLink(SideAddress.nextCellFromBorder(p, d));
			if (link != null && link != newLink) {
				for(SideAddress b : link) {
					setLink(b, newLink);
					newLink.add(b);
				}
				linkList.remove(link);
			}
		}
		newLink.add(p);
		setLink(p, newLink);
	}
	/**
	 * Link ؒf
	 */
	void cutLink(SideAddress p) {
		Link oldLink = getLink(p);
		Link longerLink = new Link();
		for (SideAddress b : oldLink) {
			setLink(b, null);
		}
		linkList.remove(oldLink);
		for (int d = 0; d < 2; d++) {
			Address p1 = SideAddress.nextCellFromBorder(p, d);
			initLink(p1);
			if (initializingLink.size() > longerLink.size())
				longerLink = initializingLink;
		}
		longerLink.setId(oldLink.getId());
	}

	/**
	 * }X̏㉺E4̂CݐĂ鐔Ԃ
	 * @param p }X̍W
	 * @return }X̏㉺EɈĂ̐
	 */
	public int countLine(Address p) {
		int no = 0;
		for (int d = 0; d < 4; d++) {
			SideAddress b = SideAddress.get(p, d);
			if (getState(b) == Board.LINE) {
				no++;
			}
		}
		return no;
	}

	/**
	 * Ɋւ`FbN
	 * @return
	 */
	private int checkLinks() {
		int result = 0;
		for (Address p : cellAddrs()) {
			int l = countLine(p);
			if (l > 2) {
				result |= 1;
			} else if (l == 1) {
				result |= 2;
			}
		}
		if (linkList.size() > 1)
			result |= 4;
		else if (linkList.size() == 0)
			result |= 8;
		return result;
	}

	/**
	 * ɂāAʉ߂Ă邩ǂ𒲂ׂB
	 * ƂPӏ݂̂ŒꍇB
	 * Ȃꍇ͌B
	 * 񒼌ꍇ͌B
	 * @return 肪ΐCȂ0
	 */
	private int checkGates() {
		for (Address p : cellAddrs()) {
			if (isGate(p)) {
				int ret = checkGate1(p);
				if (ret == -1) {
					return 16;
				} else if (ret == 0) {
					return 32;
				} else if (ret > 1) {
					return 64;
				} else if (ret == -2) {
				}
			}
		}
		return 0;
	}

	/**
	 * ̃}XɒڂāAʂ𒲂ׂB
	 * c̏[܂͉̍[̃}XɂĒׂB
	 * [܂͍[ȊÕ}X̏ꍇ͂łɒς݂̂͂B
	 * @param p ̃}X̍W
	 * @return ̒ʂĂ -1 , ς݂ -2, 0ȏ̐͐Ɍ񐔂ԂB
	 */
	private int checkGate1(Address p0) {
		int gateType = getNumber(p0);
//		System.out.println(p.toString() + "̖𒲂ׂB");
		int d = 0;
		if (gateType == Board.GATE_HORIZ) {
			d = Direction.RT;
		} else if (gateType == Board.GATE_VERT) {
			d = Direction.DN;
		}
		Address p2 = Address.nextCell(p0, d^2);
		if (isOn(p2) && getNumber(p2) == gateType) { // ЂƂÕ}X̖Ȃ΁C
			return -2; // ς݂̂͂
		}
		int count = 0;
		Address p = p0;
		while (true) {
			int ret = checkGate2(p);
			if (ret == -1) {
//				System.out.println(p.toString() + "̈ʒu̖̒ʂB");
				return -1;
			} else if (ret == 1) {
				count ++;
			}
			p = p.nextCell(d);
			if (isOn(p) && getNumber(p) == gateType) {
			} else {
				break;
			}
		}
//		System.out.println(count + "CB");
		return count;
	}

	/**
	 * ̃}XɒڂāAʂ𒲂ׂB
	 * ƕsɐĂΌCĂΐB
	 * @param p@̃}X̍W
	 * @return sĂ -1AĂ 1, ȊO 0
	 */
	private int checkGate2(Address p) {
		int type = getNumber(p);
		int st4[] = new int[4];
		for (int d = 0; d < 4; d++) {
			st4[d] = getState(SideAddress.get(p, d));
		}
		if (type == GATE_VERT) {
			if (st4[0] == LINE || st4[2] == LINE) {
//				System.out.println("Q[g" + p.toString() + "ƕsɑĂ");
				return -1;
			}
			if (st4[1] == LINE && st4[3] == LINE) {
//				System.out.println("Q[g" + p.toString() + "ƒĂ");
				return 1;
			}
		} else if (type == GATE_HORIZ) {
			if (st4[1] == LINE || st4[3] == LINE) {
//				System.out.println("Q[g" + p.toString() + "ƕsɑĂ");
				return -1;
			}
			if (st4[0] == LINE && st4[2] == LINE) {
//				System.out.println("Q[g" + p.toString() + "ƒĂ");
				return 1;
			}
		}
		return 0;
	}

	/**
	 * X^[gS[܂ł̖ʂԂǂ𒲂ׂB
	 * X^[gS[܂ł̌oHȂĂ邱Ƃ肷B
	 * ׂĂ̖𐳂ʉ߂Ă邱ƂOƂB
	 * S[ȂƂ́AԂǂ̂ݒׂB
	 * @return Œʉ߂Ă 0, Ăΐ
	 */
	private int checkRoute() {
		int[] gateNumber = new int[nGate]; // ʉ߂̔ԍL^B
		int k = 0;
		Address p0; // X^[g^S[n_
		if (goal.isNowhere()) {
			// S[Ȃꍇ́CԂ𐔂N_Ƃ邽߂̉̃S[ݒ肷B
			p0 = emporalGoal();
		} else {
			p0 = goal;
			if (getLink(p0) == null) {
				System.out.println("S[ʉ߂ĂȂB");
				return 512;
			}
		}
		System.out.println("X^[g^S[n_ " + p0.toString());
		Address p = p0;
		int d = -1;
		while (true) {
			d = getLineDirection(p, d);
			p = Address.nextCell(p, d);
			if (isGate(p)) {
								System.out.println("Q[g " + getGateNumber(p) + " ʉ");
				gateNumber[k] = getGateNumber(p);
				k++;
				if (k > nGate) { // ׂĂ̖𐳂ʉ߂Ă邱ƂOȂ΁A肦Ȃ
					System.out.println("" + nGate + "̂" + k + "ӏ߂ʉ߂Bʉ߂傪");
					return 128;
				}
			}
			if (p.equals(p0)) {
				System.out.println("S[B");
				break;
			}
		}
		if (k < nGate) { // ׂĂ̖𐳂ʉ߂Ă邱ƂOȂ΁A肦Ȃ
			System.out.println("" + nGate + "̂" + k + "ӏʉ߂Bʉ߂傪Ȃ");
			return 128;
		}
		for (k = 0; k < nGate; k++) {
			System.out.print(gateNumber[k]);
			System.out.print(' ');
		}
		System.out.println(" ̏Ԃɖʉ߂B");
		int gg = 1;
		// S[ݒ肳ĂȂƂ́AS[͉Ԗڂɒʉ߂Ă悢ƂɂB
		if (goal.isNowhere() && nGate >= 1) {
			gg = nGate;
		}
		for (int g = 0; g < gg; g++) {
			for (k = 0; k < nGate; k++) {
				if (gateNumber[k] > 0) { // ɔԍw肳ĂƂ
					if (gateNumber[k] != ((k + g) % nGate + 1)) {
						break;
					}
				}
			}
			if (k == nGate) {
				System.out.println("̒ʉߏB");
				return 0;
			}
		}
		for (int g = 0; g < gg; g++) {
			for (k = 0; k < nGate; k++) {
				if (gateNumber[k] > 0) {
					if (gateNumber[k] != ((nGate - 1 - k + g) % nGate + 1)) {
						break;
					}
				}
			}
			if (k == nGate) {
				System.out.println("̒ʉߏB");
				return 0;
			}
		}
		System.out.println("̒ʉߏĂB");
		return 256;
	}

	/**
	 * S[ݒ肳ĂȂՖʂŁÃS[ݒ肷B
	 */
	private Address emporalGoal() {
		for (Address p : cellAddrs()) {
			if (countLine(p) > 1) {
				return p;
			}
		}
		return Address.NOWHERE;
	}

	/**
	 * ȊOŐ̉тĂЂƂԂB
	 * Nǂ̂ɗpB
	 * @param p
	 * @param direction
	 * @return
	 */
	private int getLineDirection(Address p, int direction) {
		for (int d = 0; d < 4; d++) {
			if (getState(SideAddress.get(p, d)) == LINE && direction != (d^2))
				return d;
		}
		return -1;
	}

	public int checkAnswerCode() {
		int result = 0;
		result |= checkLinks();
		result |= checkGates();
		if (result == 0) // [vƖ̒ʂƂ̂ݏԂ`FbNB
			result |= checkRoute();
		return result;
	}

	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result == 0)
			return COMPLETE_MESSAGE;
		StringBuffer message = new StringBuffer();
		if ((result & 1) == 1) // ܂͌Ă
			message.append(Messages.getString("slalom.AnswerCheckMessage1")); //$NON-NLS-1$
		if ((result & 2) == 2) // ĂȂ\n
			message.append(Messages.getString("slalom.AnswerCheckMessage2")); //$NON-NLS-1$
		if ((result & 4) == 4) // ̐\n
			message.append(Messages.getString("slalom.AnswerCheckMessage3")); //$NON-NLS-1$
		if ((result & 8) == 8) // Ȃ\n
			message.append(Messages.getString("slalom.AnswerCheckMessage4")); //$NON-NLS-1$
		if ((result & 16) == 16) // ̒ʂ̊ԈႢ\n
			message.append(Messages.getString("slalom.AnswerCheckMessage5")); //$NON-NLS-1$
		if ((result & 32) == 32) // ʂĂȂ傪\n
			message.append(Messages.getString("slalom.AnswerCheckMessage6")); //$NON-NLS-1$
		if ((result & 64) == 64) // ʂ傪\n
			message.append(Messages.getString("slalom.AnswerCheckMessage7")); //$NON-NLS-1$
		if ((result & 256) == 256) // ʂ鏇ԂĂ\n
			message.append(Messages.getString("slalom.AnswerCheckMessage8")); //$NON-NLS-1$
		if ((result & 512) == 512) // ʂĂȂ\n
			message.append(Messages.getString("slalom.AnswerCheckMessage9")); //$NON-NLS-1$
		return message.toString();
	}
}
