/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import pencilbox.common.gui.PanelBase;

public class Frame
extends JFrame {
    private static int signx = 1;
    private static int signy = 1;
    private static int shift = 30;

    public void setup(PanelBase panel) {
        JScrollPane jScrollPane = new JScrollPane();
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)panel, null);
        this.setJMenuBar(new JMenuBar());
    }

    public void resize() {
        if ((this.getExtendedState() & 6) == 6) {
            return;
        }
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        this.setSize(frameSize);
    }

    public void locateAtCenter() {
        Point point = new Point();
        Dimension frameSize = this.getSize();
        Dimension screenSize = this.getToolkit().getScreenSize();
        point.x = (screenSize.width - frameSize.width) / 2;
        point.y = (screenSize.height - frameSize.height) / 2;
        this.setLocation(point);
    }

    public void locateAtSamePosition() {
        if ((this.getExtendedState() & 6) == 6) {
            return;
        }
        Point point = this.getLocation();
        Dimension frameSize = this.getSize();
        Dimension screenSize = this.getToolkit().getScreenSize();
        if (point.x + frameSize.width > screenSize.width) {
            point.x = screenSize.width - frameSize.width;
        }
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y + frameSize.height > screenSize.height) {
            point.y = screenSize.height - frameSize.height;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        this.setLocation(point);
    }

    public void locateAtShiftPosition(JFrame org) {
        Point point = new Point();
        Dimension frameSize = this.getSize();
        Rectangle bound = org.getBounds();
        Dimension screenSize = this.getToolkit().getScreenSize();
        point.x = bound.x + signx * shift;
        point.y = bound.y + signy * shift;
        if (point.x + frameSize.width > screenSize.width) {
            point.x = screenSize.width - frameSize.width;
            signx = -1;
        }
        if (point.x < 0) {
            point.x = 0;
            signx = 1;
        }
        if (point.y + frameSize.height > screenSize.height) {
            point.y = screenSize.height - frameSize.height;
            signy = -1;
        }
        if (point.y < 0) {
            point.y = 0;
            signy = 1;
        }
        this.setLocation(point);
    }
}

