/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pencilbox.common.gui.Frame;
import pencilbox.common.gui.PrintPreviewCanvas;

public class PrintPreviewDialog
extends JDialog {
    private static PrintPreviewDialog instance = new PrintPreviewDialog();
    private PrintRequestAttributeSet attributes;
    private PrintPreviewCanvas pcanvas;
    private Action closeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            PrintPreviewDialog.this.setVisible(false);
        }
    };

    public static PrintPreviewDialog getInstance() {
        return instance;
    }

    private PrintPreviewDialog() {
        super((java.awt.Frame)null, true);
        this.setSize(611, 909);
        this.makeDialog();
        this.attributes = new HashPrintRequestAttributeSet();
    }

    void makeDialog() {
        this.setTitle("Print Preview");
        this.pcanvas = new PrintPreviewCanvas();
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf = job.defaultPage();
        this.pcanvas.setPageFormat(pf);
        JPanel buttonPanel = new JPanel();
        JButton printButton = new JButton("Print");
        JButton pageSetupButton = new JButton("Page Setup");
        JButton closeButton = new JButton("Close");
        JLabel scalingSpinnerLabel = new JLabel("Scaling:");
        JLabel repeatXSpinnerLabel = new JLabel("Repeat X:");
        JLabel repeatYSpinnerLabel = new JLabel("Repeat Y:");
        printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrintPreviewDialog.this.print();
                PrintPreviewDialog.this.setVisible(false);
            }
        });
        pageSetupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrintPreviewDialog.this.pageSetup();
            }
        });
        closeButton.addActionListener(this.closeAction);
        final JSpinner scalingSpinner = new JSpinner(new SpinnerNumberModel(this.pcanvas.scaling, 0.099, 4.0, 0.05));
        scalingSpinner.setEditor(new JSpinner.NumberEditor(scalingSpinner, "#%"));
        scalingSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((PrintPreviewDialog)PrintPreviewDialog.this).pcanvas.scaling = ((SpinnerNumberModel)scalingSpinner.getModel()).getNumber().doubleValue();
                PrintPreviewDialog.this.pcanvas.repaint();
            }
        });
        final JSpinner repeatXSpinner = new JSpinner(new SpinnerNumberModel(this.pcanvas.repeatX, 1, 4, 1));
        repeatXSpinner.setEditor(new JSpinner.NumberEditor(repeatXSpinner, "#"));
        repeatXSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((PrintPreviewDialog)PrintPreviewDialog.this).pcanvas.repeatX = ((SpinnerNumberModel)repeatXSpinner.getModel()).getNumber().intValue();
                PrintPreviewDialog.this.pcanvas.repaint();
            }
        });
        final JSpinner repeatYSpinner = new JSpinner(new SpinnerNumberModel(this.pcanvas.repeatY, 1, 4, 1));
        repeatYSpinner.setEditor(new JSpinner.NumberEditor(repeatYSpinner, "#"));
        repeatYSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((PrintPreviewDialog)PrintPreviewDialog.this).pcanvas.repeatY = ((SpinnerNumberModel)repeatYSpinner.getModel()).getNumber().intValue();
                PrintPreviewDialog.this.pcanvas.repaint();
            }
        });
        buttonPanel.add(printButton);
        buttonPanel.add(pageSetupButton);
        buttonPanel.add(scalingSpinnerLabel);
        buttonPanel.add(scalingSpinner);
        buttonPanel.add(repeatXSpinnerLabel);
        buttonPanel.add(repeatXSpinner);
        buttonPanel.add(repeatYSpinnerLabel);
        buttonPanel.add(repeatYSpinner);
        buttonPanel.add(closeButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.pcanvas, "Center");
        contentPane.add((Component)buttonPanel, "North");
        this.assignKeys();
    }

    public void print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        try {
            job.setPrintable(this.pcanvas);
            if (job.printDialog(this.attributes)) {
                job.print(this.attributes);
            }
        }
        catch (PrinterException e) {
            JOptionPane.showMessageDialog(this, e);
        }
    }

    public void pageSetup() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf = job.pageDialog(this.attributes);
        if (pf != null) {
            this.pcanvas.setPageFormat(pf);
            this.pcanvas.repaint();
        }
    }

    private void assignKeys() {
        InputMap imap = this.getRootPane().getInputMap(1);
        imap.put(KeyStroke.getKeyStroke(27, 0), "close");
        this.getRootPane().getActionMap().put("close", this.closeAction);
    }

    public void setPrintObject(Printable printObject) {
        this.pcanvas.printObject = printObject;
    }

    public void showDialog(Frame frame) {
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }
}

