/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.io;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;

public abstract class PzprWriterBase {
    protected BoardBase boardBase;
    protected int rows;
    protected int cols;
    private String outpflag = "";
    private String outbstr = "";
    protected int[] roomNumbers;
    protected int[] borders;

    public String writeQuestion(BoardBase board) {
        this.boardBase = board;
        this.pzlexport();
        String pflag = this.outpflag.length() > 0 ? "/" + this.outpflag : "";
        return String.valueOf(this.getPzprName()) + pflag + '/' + this.cols + '/' + this.rows + '/' + this.outbstr;
    }

    protected String getPzprName() {
        return "";
    }

    protected void pzlexport() {
    }

    protected void outSize(int r, int c) {
        this.rows = r;
        this.cols = c;
    }

    protected void outbstr(String s) {
        this.outbstr = String.valueOf(this.outbstr) + s;
    }

    protected void outpflag(String s) {
        this.outpflag = s;
    }

    protected void encode4Cell() {
        int count = 0;
        String cm = "";
        int i = 0;
        while (i < this.rows * this.cols) {
            String pstr = "";
            if (this.QnC(i) >= 0) {
                if (i < this.rows * this.cols - 1 && (this.QnC(i + 1) >= 0 || this.QnC(i + 1) == -2)) {
                    pstr = PzprWriterBase.toString(this.QnC(i), 16);
                } else if (i < this.rows * this.cols - 2 && (this.QnC(i + 2) >= 0 || this.QnC(i + 2) == -2)) {
                    pstr = PzprWriterBase.toString(5 + this.QnC(i), 16);
                    ++i;
                } else {
                    pstr = PzprWriterBase.toString(10 + this.QnC(i), 16);
                    i += 2;
                }
            } else if (this.QnC(i) == -2) {
                pstr = ".";
            } else {
                pstr = " ";
                ++count;
            }
            if (count == 0) {
                cm = String.valueOf(cm) + pstr;
            } else if (pstr != " ") {
                cm = String.valueOf(cm) + PzprWriterBase.toString(count + 15, 36) + pstr;
                count = 0;
            } else if (count == 20) {
                cm = String.valueOf(cm) + "z";
                count = 0;
            }
            ++i;
        }
        if (count > 0) {
            cm = String.valueOf(cm) + PzprWriterBase.toString(count + 15, 36);
        }
        this.outbstr(cm);
    }

    protected void encodeNumber16() {
        int count = 0;
        String cm = "";
        int i = 0;
        while (i < this.rows * this.cols) {
            String pstr = "";
            int val = this.QnC(i);
            if (val == -2) {
                pstr = ".";
            } else if (val >= 0 && val < 16) {
                pstr = PzprWriterBase.toString(val, 16);
            } else if (val >= 16 && val < 256) {
                pstr = "-" + PzprWriterBase.toString(val, 16);
            } else if (val >= 256 && val < 4096) {
                pstr = "+" + PzprWriterBase.toString(val, 16);
            } else if (val >= 4096 && val < 8192) {
                pstr = "=" + PzprWriterBase.toString(val - 4096, 16);
            } else if (val >= 8192) {
                pstr = "%" + PzprWriterBase.toString(val - 8192, 16);
            } else {
                ++count;
            }
            if (count == 0) {
                cm = String.valueOf(cm) + pstr;
            } else if (pstr.length() > 0 || count == 20) {
                cm = String.valueOf(cm) + PzprWriterBase.toString(15 + count, 36) + pstr;
                count = 0;
            }
            ++i;
        }
        if (count > 0) {
            cm = String.valueOf(cm) + PzprWriterBase.toString(15 + count, 36);
        }
        this.outbstr(cm);
    }

    protected void encodeRoomNumber16() {
        int count = 0;
        String cm = "";
        int i = 0;
        while (i < this.roomNumbers.length) {
            String pstr = "";
            int val = this.roomNumbers[i];
            if (val >= 0 && val < 16) {
                pstr = PzprWriterBase.toString(val, 16);
            } else if (val >= 16 && val < 256) {
                pstr = "-" + PzprWriterBase.toString(val, 16);
            } else if (val >= 256 && val < 4096) {
                pstr = "+" + PzprWriterBase.toString(val, 16);
            } else if (val >= 4096 && val < 8192) {
                pstr = "=" + PzprWriterBase.toString(val - 4096, 16);
            } else if (val >= 8192 && val < 12240) {
                pstr = "%" + PzprWriterBase.toString(val - 8192, 16);
            } else if (val >= 12240 && val < 77776) {
                pstr = "*" + PzprWriterBase.toString(val - 12240, 16);
            } else if (val >= 77776) {
                pstr = "$" + PzprWriterBase.toString(val - 77776, 16);
            } else {
                ++count;
            }
            if (count == 0) {
                cm = String.valueOf(cm) + pstr;
            } else if (pstr.length() > 0 || count == 20) {
                cm = String.valueOf(cm) + PzprWriterBase.toString(15 + count, 36) + pstr;
                count = 0;
            }
            ++i;
        }
        if (count > 0) {
            cm = String.valueOf(cm) + PzprWriterBase.toString(15 + count, 36);
        }
        this.outbstr(cm);
    }

    protected void encodeArrowNumber16() {
        String cm = "";
        int count = 0;
        int c = 0;
        while (c < this.rows * this.cols) {
            String pstr = "";
            if (this.QnC(c) != -1) {
                if (this.QnC(c) == -2) {
                    pstr = String.valueOf(this.DiC(c) == 0 ? 0 : this.DiC(c)) + ".";
                } else if (this.QnC(c) < 16) {
                    pstr = String.valueOf(this.DiC(c) == 0 ? 0 : this.DiC(c)) + PzprWriterBase.toString(this.QnC(c), 16);
                } else if (this.QnC(c) < 256) {
                    pstr = String.valueOf(this.DiC(c) == 0 ? 5 : this.DiC(c) + 5) + PzprWriterBase.toString(this.QnC(c), 16);
                }
            } else {
                pstr = " ";
                ++count;
            }
            if (count == 0) {
                cm = String.valueOf(cm) + pstr;
            } else if (pstr != " ") {
                cm = String.valueOf(cm) + PzprWriterBase.toString(count + 9, 36) + pstr;
                count = 0;
            } else if (count == 26) {
                cm = String.valueOf(cm) + "z";
                count = 0;
            }
            ++c;
        }
        if (count > 0) {
            cm = String.valueOf(cm) + PzprWriterBase.toString(count + 9, 36);
        }
        this.outbstr(cm);
    }

    protected void encodeBorder() {
        String cm = "";
        int num = 0;
        int pass = 0;
        int i = 0;
        while (i < (this.cols - 1) * this.rows) {
            if (this.QuB(i) == 1) {
                pass += 1 << 4 - num;
            }
            if (++num == 5) {
                cm = String.valueOf(cm) + PzprWriterBase.toString(pass, 32);
                num = 0;
                pass = 0;
            }
            ++i;
        }
        if (num > 0) {
            cm = String.valueOf(cm) + PzprWriterBase.toString(pass, 32);
        }
        num = 0;
        pass = 0;
        i = (this.cols - 1) * this.rows;
        while (i < (this.cols - 1) * this.rows + this.cols * (this.rows - 1)) {
            if (this.QuB(i) == 1) {
                pass += 1 << 4 - num;
            }
            if (++num == 5) {
                cm = String.valueOf(cm) + PzprWriterBase.toString(pass, 32);
                num = 0;
                pass = 0;
            }
            ++i;
        }
        if (num > 0) {
            cm = String.valueOf(cm) + PzprWriterBase.toString(pass, 32);
        }
        this.outbstr(cm);
    }

    protected void makeBorderData() {
        int bdinside = (this.cols - 1) * this.rows + this.cols * (this.rows - 1);
        this.borders = new int[bdinside];
        int i = 0;
        while (i < bdinside) {
            this.borders[i] = this.getBorder(this.i2b(i));
            ++i;
        }
    }

    protected int getBorder(SideAddress b) {
        return 0;
    }

    protected void encodeCircle41_42() {
        String cm = "";
        int num = 0;
        int pass = 0;
        int i = 0;
        while (i < this.rows * this.cols) {
            if (this.QuC(i) == 41) {
                pass = (int)((double)pass + Math.pow(3.0, 2 - num));
            } else if (this.QuC(i) == 42) {
                pass = (int)((double)pass + 2.0 * Math.pow(3.0, 2 - num));
            }
            if (++num == 3) {
                cm = String.valueOf(cm) + PzprWriterBase.toString(pass, 27);
                num = 0;
                pass = 0;
            }
            ++i;
        }
        if (num > 0) {
            cm = String.valueOf(cm) + PzprWriterBase.toString(pass, 27);
        }
        this.outbstr(cm);
    }

    public Address i2a(int i) {
        return Address.address(i / this.cols, i % this.cols);
    }

    public SideAddress i2b(int i) {
        if (i < 0) {
            return SideAddress.NOWHERE;
        }
        if (i < (this.cols - 1) * this.rows) {
            return SideAddress.sideAddress(0, i / (this.cols - 1), i % (this.cols - 1));
        }
        if (i < (this.cols - 1) * this.rows + this.cols * (this.rows - 1)) {
            return SideAddress.sideAddress(1, (i -= (this.cols - 1) * this.rows) / this.cols, i % this.cols);
        }
        return SideAddress.NOWHERE;
    }

    public int a2i(Address a) {
        return a.r() * this.cols + a.c();
    }

    protected int QuC(int i) {
        return 0;
    }

    protected int QnC(int i) {
        return 0;
    }

    protected int DiC(int i) {
        return 0;
    }

    protected int QuB(int i) {
        return this.borders[i];
    }

    public static final String toString(int i, int radix) {
        return Integer.toString(i, radix);
    }
}

