/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slitherlink;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.slitherlink.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = -9;

    public PanelEventHandler() {
        this.setMaxInputNumber(3);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    public boolean isCursorOnBoard(Address pos) {
        return this.board.isNumberOn(pos);
    }

    protected void leftPresseddEdge(SideAddress pos) {
    }

    @Override
    protected void rightPressedEdge(SideAddress pos) {
        this.toggleState(pos, -1);
    }

    @Override
    protected void leftDragged(Address dragStart, Address dragEnd) {
        this.changeLineState(dragStart, dragEnd, 1);
    }

    @Override
    protected void leftReleased(Address pos) {
        this.currentState = -9;
    }

    private void toggleState(SideAddress pos, int st) {
        if (st == this.board.getState(pos)) {
            st = 0;
        }
        this.board.changeState(pos, st);
    }

    private void changeLineState(Address pos0, Address pos1, int st) {
        int direction = pos0.getDirectionTo(pos1);
        if (direction < 0) {
            return;
        }
        SideAddress side = SideAddress.get(pos0, direction);
        if (this.currentState == -9) {
            this.currentState = this.board.getState(side) == st ? 0 : st;
        }
        Address p = pos0;
        while (!p.equals(pos1)) {
            side = SideAddress.get(p, direction);
            if (this.board.getState(side) != this.currentState) {
                this.board.changeState(side, this.currentState);
            }
            p = Address.nextCell(p, direction);
        }
    }

    @Override
    protected void moveCursor(Address pos) {
    }

    @Override
    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos, num);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.changeNumber(posS, 5);
            }
        }
    }

    @Override
    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos, -1);
            if (this.isSymmetricPlacementMode() && this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.changeNumber(posS, -1);
            }
        }
    }

    @Override
    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos, 5);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.changeNumber(posS, 5);
            }
        }
    }

    @Override
    public Address getSymmetricPosition(Address pos) {
        return Address.address(this.board.rows() - 2 - pos.r(), this.board.cols() - 2 - pos.c());
    }
}

