/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.kakuro.DigitPatternHint;
import pencilbox.kakuro.Word;
import pencilbox.resource.Messages;

public class Board
extends BoardBase {
    static final int WALL = -1;
    static final int BLANK = -2;
    static final int maxNumber = 9;
    private int[][] number;
    private int[][] sumH;
    private int[][] sumV;
    private Word[][] wordH;
    private Word[][] wordV;
    private int[][] multi;
    private DigitPatternHint hint;

    @Override
    protected void setup() {
        super.setup();
        this.number = new int[this.rows()][this.cols()];
        this.sumH = new int[this.rows()][this.cols()];
        this.sumV = new int[this.rows()][this.cols()];
        int c = 0;
        while (c < this.cols()) {
            this.number[0][c] = -1;
            this.sumH[0][c] = 0;
            this.sumV[0][c] = 0;
            ++c;
        }
        int r = 1;
        while (r < this.rows()) {
            this.number[r][0] = -1;
            this.sumH[r][0] = 0;
            this.sumV[r][0] = 0;
            ++r;
        }
        this.wordH = new Word[this.rows()][this.cols()];
        this.wordV = new Word[this.rows()][this.cols()];
        this.multi = new int[this.rows()][this.cols()];
        this.hint = new DigitPatternHint();
        this.hint.setupHint(this);
    }

    @Override
    public void clearBoard() {
        Address p;
        super.clearBoard();
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            if (!this.isWall(p)) {
                this.setNumber(p, 0);
            }
            ++n2;
        }
        addressArray = this.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            this.setMulti(p, 0);
            ++n2;
        }
        addressArray = this.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            int d = 0;
            while (d < 2) {
                if (this.getSum(p, d) > 0) {
                    this.getWord(p, d).clear();
                }
                ++d;
            }
            ++n2;
        }
        this.initHint();
    }

    @Override
    public void clearQuestion() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.isWall(p)) {
                int d = 0;
                while (d < 2) {
                    Address pp = Address.nextCell(p, d | 2);
                    if (this.isOn(pp) && !this.isWall(pp)) {
                        this.setSum(p, d, 0);
                    }
                    ++d;
                }
            }
            ++n2;
        }
        this.initBoard();
    }

    @Override
    public void reconstructQuestion() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.isWall(p)) {
                int d = 0;
                while (d < 2) {
                    Address pp = Address.nextCell(p, d | 2);
                    if (this.isOn(pp) && !this.isWall(pp)) {
                        this.setSum(p, d, this.getWord(pp, d).extractSum());
                    }
                    ++d;
                }
            }
            ++n2;
        }
        this.initBoard();
    }

    int[][] getSumH() {
        return this.sumH;
    }

    int[][] getSumV() {
        return this.sumV;
    }

    int[][] getNumber() {
        return this.number;
    }

    int getMaxNumber() {
        return 9;
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public boolean isWall(int r, int c) {
        if (!this.isOn(r, c)) {
            return true;
        }
        return this.number[r][c] == -1;
    }

    public boolean isWall(Address pos) {
        return this.isWall(pos.r(), pos.c());
    }

    public int getSumV(int r, int c) {
        return this.sumV[r][c];
    }

    public int getSumV(Address p) {
        return this.sumV[p.r()][p.c()];
    }

    public int getSumH(int r, int c) {
        return this.sumH[r][c];
    }

    public int getSumH(Address p) {
        return this.sumH[p.r()][p.c()];
    }

    public int getSum(Address p, int dir) {
        if (dir == 0) {
            return this.sumV[p.r()][p.c()];
        }
        if (dir == 1) {
            return this.sumH[p.r()][p.c()];
        }
        return 0;
    }

    public void setSumV(int r, int c, int n) {
        this.number[r][c] = -1;
        this.sumV[r][c] = n;
    }

    public void setSumH(int r, int c, int n) {
        this.number[r][c] = -1;
        this.sumH[r][c] = n;
    }

    public void setSum(Address pos, int dir, int n) {
        if (dir == 0) {
            this.setSumV(pos.r(), pos.c(), n);
        }
        if (dir == 1) {
            this.setSumH(pos.r(), pos.c(), n);
        }
    }

    public void setWall(int r, int c, int a, int b) {
        this.number[r][c] = -1;
        this.sumH[r][c] = a;
        this.sumV[r][c] = b;
    }

    public void setWall(Address pos, int a, int b) {
        this.setWall(pos.r(), pos.c(), a, b);
    }

    public void removeWall(int r, int c) {
        this.number[r][c] = 0;
        this.sumH[r][c] = 0;
        this.sumV[r][c] = 0;
    }

    public void removeWall(Address pos) {
        this.removeWall(pos.r(), pos.c());
    }

    public int getSum2(Address p) {
        return this.getSum(p, 0) | this.getSum(p, 1) << 8;
    }

    public Word getWord(Address p, int dir) {
        if (dir == 0) {
            return this.wordV[p.r()][p.c()];
        }
        if (dir == 1) {
            return this.wordH[p.r()][p.c()];
        }
        return null;
    }

    public void setWord(Address p, int dir, Word w) {
        if (dir == 0) {
            this.wordV[p.r()][p.c()] = w;
        }
        if (dir == 1) {
            this.wordH[p.r()][p.c()] = w;
        }
    }

    public int getMulti(Address pos) {
        return this.multi[pos.r()][pos.c()];
    }

    public void setMulti(Address pos, int n) {
        this.multi[pos.r()][pos.c()] = n;
    }

    @Override
    public void initBoard() {
        this.initWord();
        this.initMulti();
        this.initHint();
    }

    void initWord() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getNumber(p) == -1) {
                int d = 0;
                while (d < 2) {
                    Address pp = Address.nextCell(p, d | 2);
                    int i = 0;
                    while (this.isOn(pp) && this.getNumber(pp) != -1) {
                        pp = Address.nextCell(pp, d | 2);
                        ++i;
                    }
                    Word word = new Word(p, i, this.getSum(p, d));
                    this.setWord(p, d, word);
                    pp = Address.nextCell(p, d | 2);
                    while (this.isOn(pp) && this.getNumber(pp) != -1) {
                        this.setWord(pp, d, word);
                        if (this.getNumber(pp) > 0) {
                            word.changeNumber(0, this.getNumber(pp));
                        }
                        pp = Address.nextCell(pp, d | 2);
                    }
                    ++d;
                }
            }
            ++n2;
        }
    }

    public boolean isMultipleNumber(Address p) {
        return this.getMulti(p) > 1;
    }

    public void changeSum(Address p, int dir, int n) {
        int nn = 0;
        if (dir == 0) {
            nn = n | this.getSum(p, 1) << 8;
        } else if (dir == 1) {
            nn = this.getSum(p, 0) | n << 8;
        }
        this.changeWall(p, nn);
    }

    public void changeWall(Address p, int n) {
        int prev;
        if (this.getNumber(p) > 0) {
            this.changeAnswerNumber(p, 0);
        }
        int n2 = prev = this.isWall(p) ? this.getSum2(p) : -2;
        if (n == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.FIXED, p, prev, n));
        }
        if (n == -2) {
            this.removeWall(p);
        } else {
            this.setWall(p, 0, 0);
            this.setSum(p, 0, n & 0xFF);
            this.setSum(p, 1, n >> 8 & 0xFF);
        }
    }

    public void changeAnswerNumber(Address p, int n) {
        int prev;
        if (this.isWall(p)) {
            this.changeWall(p, 0);
        }
        if (n == (prev = this.getNumber(p))) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.NUMBER, p, prev, n));
        }
        this.getWord(p, 1).changeNumber(prev, n);
        this.getWord(p, 0).changeNumber(prev, n);
        this.updateMulti(p, prev, n);
        this.setNumber(p, n);
        this.updateHint(p);
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (s.getType() == AbstractStep.EditType.NUMBER) {
                this.changeAnswerNumber(s.getPos(), s.getBefore());
            } else if (s.getType() == AbstractStep.EditType.FIXED) {
                this.changeWall(s.getPos(), s.getBefore());
            }
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (s.getType() == AbstractStep.EditType.NUMBER) {
                this.changeAnswerNumber(s.getPos(), s.getAfter());
            } else if (s.getType() == AbstractStep.EditType.FIXED) {
                this.changeWall(s.getPos(), s.getAfter());
            }
        }
    }

    void initMulti() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int n3 = this.getNumber(p);
            if (n3 > 0) {
                this.setMulti(p, 1);
                this.updateMulti1(p, n3, 1, 0);
            }
            ++n2;
        }
    }

    void updateMulti(Address p0, int prev, int num) {
        if (this.getMulti(p0) > 1) {
            this.updateMulti1(p0, prev, 0, -1);
        }
        if (num > 0) {
            this.setMulti(p0, 1);
            this.updateMulti1(p0, num, 1, 1);
        } else if (num == 0) {
            this.setMulti(p0, 0);
        }
    }

    private void updateMulti1(Address p0, int num, int m, int k) {
        int d = 0;
        while (d < 2) {
            Address p = this.getWordHead(p0, d);
            int i = 0;
            while (i < this.getWordSize(p0, d)) {
                if (!(p = Address.nextCell(p, d | 2)).equals(p0) && this.getNumber(p) == num) {
                    this.setMulti(p, this.getMulti(p) + k);
                    this.setMulti(p0, this.getMulti(p0) + m);
                }
                ++i;
            }
            ++d;
        }
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (!this.isWall(p)) {
                if (this.getNumber(p) == 0) {
                    result |= 1;
                } else if (this.isMultipleNumber(p)) {
                    result |= 2;
                }
            } else if (this.isWall(p)) {
                if (this.getSumH(p) > 0 && this.getWordStatus(p, 1) == -1) {
                    result |= 4;
                }
                if (this.getSumV(p) > 0 && this.getWordStatus(p, 0) == -1) {
                    result |= 4;
                }
            }
            ++n2;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return BoardBase.COMPLETE_MESSAGE;
        }
        if (result == 1) {
            return Messages.getString("kakuro.AnswerCheckMessage1");
        }
        StringBuffer message = new StringBuffer();
        if ((result & 2) == 2) {
            message.append(Messages.getString("kakuro.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("kakuro.AnswerCheckMessage3"));
        }
        return message.toString();
    }

    void initHint() {
        this.hint.initHint();
    }

    protected void updateHint(Address p) {
        this.hint.updatePattern(p);
    }

    int getPattern(Address p) {
        return this.hint.getPattern(p);
    }

    int getWordSize(Address p, int dir) {
        return this.getWord(p, dir).getSize();
    }

    Address getWordHead(Address p, int dir) {
        return this.getWord(p, dir).getHead();
    }

    int getWordSum(Address p, int dir) {
        return this.getWord(p, dir).getSum();
    }

    int getWordStatus(Address p, int dir) {
        return this.getWord(p, dir).getStatus();
    }
}

