/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hitori;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.Direction;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int WHITE = -1;
    static final int BLACK = -2;
    static final int UNKNOWN = 0;
    static final int UNDECIDED_NUMBER = -1;
    private int[][] state;
    private int[][] number;
    private int[][] multiH;
    private int[][] multiV;
    private boolean[][] single;
    private int[][] chain;
    private int maxNumber;
    private int maxChain = 1;
    private int[] adjacentChain = new int[4];

    @Override
    protected void setup() {
        super.setup();
        int rows = this.rows();
        int cols = this.cols();
        this.number = new int[rows][cols];
        this.state = new int[rows][cols];
        this.single = new boolean[rows][cols];
        this.multiH = new int[rows][cols];
        this.multiV = new int[rows][cols];
        this.chain = new int[rows][cols];
        this.maxNumber = rows > cols ? rows : cols;
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        ArrayUtil.initArrayInt2(this.state, 0);
        this.initBoard();
    }

    @Override
    public void trimAnswer() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getState(p) == -1) {
                this.changeState(p, 0);
            }
            ++n2;
        }
    }

    @Override
    public void initBoard() {
        this.initSingle();
        this.initMulti();
        this.initChain();
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public boolean isBlack(Address p) {
        return this.isOn(p) && this.getState(p) == -2;
    }

    public boolean isRedundantNumber(Address p) {
        return this.multiH[p.r()][p.c()] > 1 || this.multiV[p.r()][p.c()] > 1;
    }

    public boolean isSingle(Address p) {
        return this.single[p.r()][p.c()];
    }

    int getChain(Address p) {
        return this.chain[p.r()][p.c()];
    }

    void setChain(Address p, int n) {
        this.chain[p.r()][p.c()] = n;
    }

    public void changeNumber(Address p, int n) {
        int prev = this.getNumber(p);
        if (n == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.FIXED, p, prev, n));
        }
        this.setNumber(p, n);
    }

    public void changeState(Address p, int st) {
        int prev = this.getState(p);
        if (st == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.STATE, p, prev, st));
        }
        this.setState(p, st);
        if (st == -2) {
            this.updateMulti(p, -1);
            this.connectChain(p);
        } else if (prev == -2) {
            this.updateMulti(p, 1);
            this.cutChain(p);
        }
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (step.getType() == AbstractStep.EditType.STATE) {
                this.changeState(s.getPos(), s.getBefore());
            } else if (step.getType() == AbstractStep.EditType.FIXED) {
                this.changeNumber(s.getPos(), s.getBefore());
            }
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (step.getType() == AbstractStep.EditType.STATE) {
                this.changeState(s.getPos(), s.getAfter());
            } else if (step.getType() == AbstractStep.EditType.FIXED) {
                this.changeNumber(s.getPos(), s.getAfter());
            }
        }
    }

    boolean isBlock(Address p) {
        int d = 0;
        while (d < 4) {
            if (this.isBlack(Address.nextCell(p, d))) {
                return true;
            }
            ++d;
        }
        return false;
    }

    void initChain() {
        Address p;
        this.maxChain = 1;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            this.setChain(p, 0);
            ++n2;
        }
        addressArray = this.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            if (this.isOnPeriphery(p) && this.isBlack(p) && this.getChain(p) == 0 && this.initChain1(p, -1, 1) == -1) {
                this.updateChain(p, -1);
            }
            ++n2;
        }
        addressArray = this.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            if (!this.isOnPeriphery(p) && this.isBlack(p) && this.getChain(p) == 0 && this.initChain1(p, -1, ++this.maxChain) == -1) {
                this.updateChain(p, -1);
            }
            ++n2;
        }
    }

    int initChain1(Address p, int d, int n) {
        if (n == 1 && d != -1 && this.isOnPeriphery(p)) {
            return -1;
        }
        if (n >= 0 && this.isOnPeriphery(p)) {
            this.setChain(p, 1);
        } else {
            this.setChain(p, n);
        }
        int[] nArray = Direction.DIAGONAL4;
        int n2 = Direction.DIAGONAL4.length;
        int n3 = 0;
        while (n3 < n2) {
            int dd = nArray[n3];
            Address pp = Address.nextCell(p, dd);
            if (dd != (d ^ 2) && this.isBlack(pp)) {
                if (this.getChain(pp) == n) {
                    return -1;
                }
                if (this.initChain1(pp, dd, n) == -1) {
                    return -1;
                }
            }
            ++n3;
        }
        return n;
    }

    void connectChain(Address p) {
        int[] adjacent = this.adjacentChain;
        int k = 0;
        int newChain = Integer.MAX_VALUE;
        if (this.isOnPeriphery(p)) {
            newChain = 1;
        }
        int[] nArray = Direction.DIAGONAL4;
        int n = Direction.DIAGONAL4.length;
        int n2 = 0;
        while (n2 < n) {
            int dd = nArray[n2];
            Address pp = Address.nextCell(p, dd);
            if (this.isBlack(pp)) {
                int c1 = this.getChain(pp);
                if (this.isOnPeriphery(p) && c1 == 1) {
                    newChain = -1;
                }
                adjacent[k] = c1;
                int l = 0;
                while (l < k) {
                    if (adjacent[k] == adjacent[l]) {
                        newChain = -1;
                    }
                    ++l;
                }
                ++k;
                if (c1 < newChain) {
                    newChain = c1;
                }
            }
            ++n2;
        }
        if (newChain == Integer.MAX_VALUE) {
            this.setChain(p, ++this.maxChain);
        } else {
            this.updateChain(p, newChain);
        }
    }

    void cutChain(Address p) {
        this.initChain();
    }

    void updateChain(Address p, int n) {
        this.setChain(p, n);
        int[] nArray = Direction.DIAGONAL4;
        int n2 = Direction.DIAGONAL4.length;
        int n3 = 0;
        while (n3 < n2) {
            int dd = nArray[n3];
            Address pp = Address.nextCell(p, dd);
            if (this.isBlack(pp) && this.getChain(pp) != n) {
                this.updateChain(pp, n);
            }
            ++n3;
        }
    }

    boolean checkDivision() {
        boolean ret = true;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getChain(p) == -1) {
                ret = false;
            }
            ++n2;
        }
        return ret;
    }

    boolean checkContinuousBlack() {
        boolean ret = true;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.isBlack(p) && this.isBlock(p)) {
                ret = false;
            }
            ++n2;
        }
        return ret;
    }

    boolean checkMulti() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.isRedundantNumber(p)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        if (!this.checkContinuousBlack()) {
            result |= 1;
        }
        if (!this.checkDivision()) {
            result |= 2;
        }
        if (!this.checkMulti()) {
            result |= 4;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return BoardBase.COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("hitori.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            message.append(Messages.getString("hitori.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("hitori.AnswerCheckMessage3"));
        }
        return message.toString();
    }

    void initSingle() {
        int i;
        int c;
        int r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                this.single[r][c] = true;
                ++c;
            }
            ++r;
        }
        int[] used = new int[this.maxNumber + 1];
        int r2 = 0;
        while (r2 < this.rows()) {
            i = 1;
            while (i <= this.maxNumber) {
                used[i] = 0;
                ++i;
            }
            int c2 = 0;
            while (c2 < this.cols()) {
                int n = this.number[r2][c2];
                used[n] = used[n] + 1;
                ++c2;
            }
            c2 = 0;
            while (c2 < this.cols()) {
                if (used[this.number[r2][c2]] > 1) {
                    this.single[r2][c2] = false;
                }
                ++c2;
            }
            ++r2;
        }
        c = 0;
        while (c < this.cols()) {
            i = 1;
            while (i <= this.maxNumber) {
                used[i] = 0;
                ++i;
            }
            int r3 = 0;
            while (r3 < this.rows()) {
                int n = this.number[r3][c];
                used[n] = used[n] + 1;
                ++r3;
            }
            r3 = 0;
            while (r3 < this.rows()) {
                if (used[this.number[r3][c]] > 1) {
                    this.single[r3][c] = false;
                }
                ++r3;
            }
            ++c;
        }
    }

    void initMulti() {
        int i;
        int[] used = new int[this.maxNumber + 1];
        int r = 0;
        while (r < this.rows()) {
            i = 0;
            while (i <= this.maxNumber) {
                used[i] = 0;
                ++i;
            }
            int c = 0;
            while (c < this.cols()) {
                if (this.state[r][c] != -2 && this.number[r][c] > 0) {
                    int n = this.number[r][c];
                    used[n] = used[n] + 1;
                }
                ++c;
            }
            c = 0;
            while (c < this.cols()) {
                this.multiH[r][c] = used[this.number[r][c]];
                ++c;
            }
            ++r;
        }
        int c = 0;
        while (c < this.cols()) {
            i = 0;
            while (i <= this.maxNumber) {
                used[i] = 0;
                ++i;
            }
            int r2 = 0;
            while (r2 < this.rows()) {
                if (this.state[r2][c] != -2 && this.number[r2][c] > 0) {
                    int n = this.number[r2][c];
                    used[n] = used[n] + 1;
                }
                ++r2;
            }
            r2 = 0;
            while (r2 < this.rows()) {
                this.multiV[r2][c] = used[this.number[r2][c]];
                ++r2;
            }
            ++c;
        }
    }

    private void updateMulti(Address p0, int k) {
        int r0 = p0.r();
        int c0 = p0.c();
        int c = 0;
        while (c < this.cols()) {
            if (this.number[r0][c] == this.number[r0][c0]) {
                int[] nArray = this.multiH[r0];
                int n = c;
                nArray[n] = nArray[n] + k;
            }
            ++c;
        }
        int r = 0;
        while (r < this.rows()) {
            if (this.number[r][c0] == this.number[r0][c0]) {
                int[] nArray = this.multiV[r];
                int n = c0;
                nArray[n] = nArray[n] + k;
            }
            ++r;
        }
    }

    int getMaxNumber() {
        return this.maxNumber;
    }

    int[][] getChain() {
        return this.chain;
    }

    int[][] getNumber() {
        return this.number;
    }

    int[][] getState() {
        return this.state;
    }
}

