/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.bijutsukan;

import pencilbox.bijutsukan.Board;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = -1;

    public PanelEventHandler() {
        this.setMaxInputNumber(5);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    protected void leftPressed(Address pos) {
        this.toggleState(pos, -2);
    }

    @Override
    protected void rightPressed(Address pos) {
        this.toggleState(pos, -3);
        this.currentState = this.board.isWall(pos) ? -1 : this.board.getState(pos);
    }

    @Override
    protected void leftDragged(Address pos) {
    }

    @Override
    protected void rightDragged(Address pos) {
        this.sweepState(pos);
    }

    private void toggleState(Address pos, int st) {
        if (this.board.isWall(pos)) {
            return;
        }
        if (st == this.board.getState(pos)) {
            st = -1;
        }
        this.board.changeState(pos, st);
    }

    private void sweepState(Address pos) {
        if (this.board.isWall(pos)) {
            return;
        }
        if (this.currentState == this.board.getState(pos)) {
            return;
        }
        this.board.changeState(pos, this.currentState);
    }

    @Override
    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos, num);
            if (this.isSymmetricPlacementMode() && !this.board.isWall(posS = this.getSymmetricPosition(pos))) {
                this.board.changeState(posS, 5);
            }
        }
    }

    @Override
    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos, -1);
            if (this.isSymmetricPlacementMode() && this.board.isWall(posS = this.getSymmetricPosition(pos))) {
                this.board.changeState(posS, -1);
            }
        }
    }

    @Override
    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos, 5);
            if (this.isSymmetricPlacementMode() && !this.board.isWall(posS = this.getSymmetricPosition(pos))) {
                this.board.changeState(posS, 5);
            }
        }
    }
}

