/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.satogaeri;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelBase;
import pencilbox.satogaeri.Area;
import pencilbox.satogaeri.Board;

public class Panel
extends PanelBase {
    private Board board;
    private Area draggingArea;
    private Color errorColor2;

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setCursorMode(false);
        this.setLineColor(new Color(39423));
        this.setMarkStyle(2);
        this.successColor = new Color(0xCCFFFF);
        this.errorColor2 = new Color(0xFFCCCC);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    Area getDraggingArea() {
        return this.draggingArea;
    }

    void setDraggingArea(Area draggingArea) {
        this.draggingArea = draggingArea;
    }

    @Override
    public void setDisplaySize(int cellSize) {
        super.setDisplaySize(cellSize);
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.paintCells(g);
        this.drawGrid(g);
        this.drawRoutes(g);
        this.drawNumbers(g);
        this.drawAreaBorders(g);
        this.drawBoardBorder(g);
    }

    private void paintCells(Graphics2D g) {
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.board.getArea(p) == null) {
                g.setColor(this.noAreaColor);
                this.paintCell(g, p);
            } else if (this.board.getArea(p) == this.draggingArea) {
                g.setColor(this.draggingAreaColor);
                this.paintCell(g, p);
            }
            ++n2;
        }
        if (this.isIndicateErrorMode()) {
            for (Area a : this.board.getAreaList()) {
                int n3 = this.board.checkArea(a, false);
                if (n3 == 1) {
                    g.setColor(this.successColor);
                } else if (n3 > 1) {
                    g.setColor(this.errorColor2);
                } else {
                    g.setColor(this.getBackgroundColor());
                }
                for (Address p : a) {
                    this.paintCell(g, p);
                }
            }
        }
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int n3 = this.board.getNumber(p);
            if (n3 >= 0 || n3 == -2) {
                int ch;
                g.setColor(this.getNumberColor());
                this.placeCircle(g, p, this.getCellSize() - 2);
                if (this.isIndicateErrorMode() && n3 >= 0 && (ch = this.board.checkNumber(p)) != 0) {
                    g.setColor(this.getErrorColor());
                }
                if (n3 >= 0) {
                    this.placeNumber(g, p, n3);
                }
            }
            ++n2;
        }
    }

    private void drawAreaBorders(Graphics2D g) {
        g.setColor(this.getAreaBorderColor());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int[] nArray = Direction.DN_RT;
            int n3 = Direction.DN_RT.length;
            int n4 = 0;
            while (n4 < n3) {
                int d = nArray[n4];
                Address p1 = p.nextCell(d);
                SideAddress b = SideAddress.get(p, d);
                if (this.board.isSideOn(b) && this.board.getArea(p) != this.board.getArea(p1)) {
                    this.placeSideLine(g, b);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void drawRoutes(Graphics2D g) {
        g.setColor(this.getLineColor());
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int state = this.board.getRoute(p);
            if (state != -1) {
                this.placeRoute(g, p, state);
            }
            ++n2;
        }
    }

    private void placeRoute(Graphics2D g, Address p, int st) {
        g.setColor(this.getLineColor());
        if (st == 0 || st == 1 || st == 2 || st == 3) {
            this.placeLink(g, SideAddress.get(p, st));
        } else if (st == 8) {
            int m = this.getMarkStyle();
            if (m == 2) {
                this.placeFilledCircle(g, p);
            } else if (m == 4) {
                this.placeArrow(g, p, this.board.getIncomingDirection(p));
            }
        }
    }

    private void placeArrow(Graphics2D g, Address p, int dir) {
        g.setColor(this.getLineColor());
        int x = this.toX(p.c()) + this.getHalfCellSize();
        int y = this.toY(p.r()) + this.getHalfCellSize();
        int halfSize = this.getCellSize() / 4;
        if (dir == 0) {
            this.drawLine(g, x, y, halfSize, 5);
            this.drawLine(g, x, y, halfSize, 6);
        } else if (dir == 1) {
            this.drawLine(g, x, y, halfSize, 7);
            this.drawLine(g, x, y, halfSize, 6);
        } else if (dir == 2) {
            this.drawLine(g, x, y, halfSize, 4);
            this.drawLine(g, x, y, halfSize, 7);
        } else if (dir == 3) {
            this.drawLine(g, x, y, halfSize, 4);
            this.drawLine(g, x, y, halfSize, 5);
        } else if (dir == 8) {
            this.drawLine(g, x, y, halfSize, 4);
            this.drawLine(g, x, y, halfSize, 5);
            this.drawLine(g, x, y, halfSize, 6);
            this.drawLine(g, x, y, halfSize, 7);
        }
    }

    private void drawLine(Graphics2D g, int x, int y, int l, int d) {
        if (d == 4) {
            g.drawLine(x + 1, y + 1, x - l - 1, y - l - 1);
            g.drawLine(x, y + 1, x - l - 1, y - l);
            g.drawLine(x + 1, y, x - l, y - l - 1);
        } else if (d == 5) {
            g.drawLine(x + 1, y - 1, x - l, y + l + 1);
            g.drawLine(x, y - 1, x - l - 1, y + l);
            g.drawLine(x + 1, y, x - l, y + l + 1);
        } else if (d == 6) {
            g.drawLine(x - 1, y - 1, x + l + 1, y + l + 1);
            g.drawLine(x, y - 1, x + l + 1, y + l);
            g.drawLine(x - 1, y, x + l, y + l + 1);
        } else if (d == 7) {
            g.drawLine(x - 1, y + 1, x + l + 1, y - l - 1);
            g.drawLine(x, y + 1, x + l + 1, y - l);
            g.drawLine(x - 1, y, x + l, y - l - 1);
        }
    }
}

